/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.client;

import dev.lopyluna.slag.content.items.modular.DataDynamicParts;
import dev.lopyluna.slag.content.items.modular.ModularItem;
import dev.lopyluna.slag.content.types.ModularType;
import dev.lopyluna.slag.register.AllLangs;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;

public class ClientTooltips {
    public static void appendHoverTextModularTool(ModularItem item, ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        Level level = context.level();
        if (level instanceof ClientLevel) {
            ClientLevel level2 = (ClientLevel)level;
            DataDynamicParts parts = item.getParts(stack);
            if (parts != null && !parts.isEmpty()) {
                List<ItemStack> copyParts = parts.itemsCopy();
                if (copyParts.isEmpty()) {
                    tooltip.add((Component)AllLangs.tr("modular_tool_waiting").withStyle(ChatFormatting.GRAY));
                    return;
                }
                if (!item.hasModularType(stack)) {
                    LocalPlayer player = Minecraft.getInstance().player;
                    float tier = item.getTier(stack);
                    boolean f = true;
                    if (player != null) {
                        BlockState lookState = level2.getBlockState(Item.getPlayerPOVHitResult((Level)level2, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE).getBlockPos());
                        int size = parts.size();
                        if (size > 4) {
                            if (!lookState.is(BlockTags.ANVIL)) {
                                tooltip.add((Component)AllLangs.tr("modular_tool_anvil").withStyle(ChatFormatting.RED));
                                f = false;
                            }
                        } else if (size > 3) {
                            if (!lookState.is(Blocks.SMITHING_TABLE) && !lookState.is(BlockTags.ANVIL)) {
                                tooltip.add((Component)AllLangs.tr("modular_tool_smithing_table").withStyle(ChatFormatting.RED));
                                f = false;
                            }
                        } else if (!(lookState.is(Tags.Blocks.PLAYER_WORKSTATIONS_CRAFTING_TABLES) || lookState.is(Blocks.SMITHING_TABLE) || lookState.is(BlockTags.ANVIL))) {
                            tooltip.add((Component)AllLangs.tr("modular_tool_crafting_table").withStyle(ChatFormatting.RED));
                            f = false;
                        }
                    }
                    if (f) {
                        if (3.5f >= tier) {
                            tooltip.add((Component)AllLangs.tr("modular_tool_crafting_hammer_weak").withStyle(ChatFormatting.RED));
                        } else {
                            tooltip.add((Component)AllLangs.trArgs("modular_tool_crafting_hammer", String.valueOf(tier)).withStyle(ChatFormatting.RED));
                        }
                    }
                }
                if (!item.hasModularType(stack)) {
                    AllLangs.modularToolStats(tooltip, parts, stack, item);
                } else if (ClientTooltips.isTool(item, stack)) {
                    AllLangs.modularToolStats(tooltip, parts, stack, item);
                }
                AllLangs.modularParts(tooltip, copyParts);
            } else {
                tooltip.add((Component)AllLangs.tr("modular_tool_waiting").withStyle(ChatFormatting.GRAY));
            }
        }
    }

    public static boolean isTool(ModularItem item, ItemStack stack) {
        ModularType modularType = item.getModularType(stack);
        return modularType != null && modularType.actions.contains("isTool");
    }
}

