/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.createmod.catnip.annotations.ClientOnly;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.platform.services.ModFluidHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class FluidRenderHelper {
    private FluidRenderHelper() {
    }

    @ClientOnly
    public static TextureAtlasSprite getFlowingTexture(FluidStack fluid) {
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getFlowingTexture(fluid));
    }

    @ClientOnly
    public static TextureAtlasSprite getFlowingTextureOrMissing(FluidStack fluid) {
        TextureAtlasSprite texture = FluidRenderHelper.getFlowingTexture(fluid);
        if (texture != null) {
            return texture;
        }
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(MissingTextureAtlasSprite.getLocation());
    }

    public static void renderFlowingFluidBox(FluidStack fluid, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, MultiBufferSource buffer, PoseStack ms, int light, boolean renderBottom, boolean invertGasses) {
        FluidRenderHelper.renderFlowingFluidBox(fluid, xMin, yMin, zMin, xMax, yMax, zMax, FluidRenderHelper.getFluidBuilder(buffer), ms, light, renderBottom, invertGasses);
    }

    public static void renderFlowingFluidBox(FluidStack fluid, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, VertexConsumer builder, PoseStack ms, int light, boolean renderBottom, boolean invertGasses) {
        ModFluidHelper helper = CatnipServices.FLUID_HELPER;
        TextureAtlasSprite fluidTexture = FluidRenderHelper.getFlowingTextureOrMissing(fluid);
        int color = helper.getColor((Object)fluid, null, null);
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, helper.getLuminosity((Object)fluid));
        light = light & 0xF00000 | luminosity << 4;
        Vec3 center = new Vec3((double)(xMin + (xMax - xMin) / 2.0f), (double)(yMin + (yMax - yMin) / 2.0f), (double)(zMin + (zMax - zMin) / 2.0f));
        ms.pushPose();
        if (invertGasses && helper.isLighterThanAir((Object)fluid)) {
            ms.translate(center.x, center.y, center.z);
            ms.mulPose(Axis.XP.rotationDegrees(180.0f));
            ms.translate(-center.x, -center.y, -center.z);
        }
        for (Direction side : Iterate.directions) {
            boolean positive;
            if (side == Direction.DOWN && !renderBottom) continue;
            boolean bl = positive = side.getAxisDirection() == Direction.AxisDirection.POSITIVE;
            if (side.getAxis().isHorizontal()) {
                if (side.getAxis() == Direction.Axis.X) {
                    net.createmod.catnip.render.FluidRenderHelper.renderTiledFace((Direction)side, (float)zMin, (float)yMin, (float)zMax, (float)yMax, (float)(positive ? xMax : xMin), (VertexConsumer)builder, (PoseStack)ms, (int)light, (int)color, (TextureAtlasSprite)fluidTexture, (float)0.5f);
                    continue;
                }
                net.createmod.catnip.render.FluidRenderHelper.renderTiledFace((Direction)side, (float)xMin, (float)yMin, (float)xMax, (float)yMax, (float)(positive ? zMax : zMin), (VertexConsumer)builder, (PoseStack)ms, (int)light, (int)color, (TextureAtlasSprite)fluidTexture, (float)0.5f);
                continue;
            }
            net.createmod.catnip.render.FluidRenderHelper.renderTiledFace((Direction)side, (float)xMin, (float)zMin, (float)xMax, (float)zMax, (float)(positive ? yMax : yMin), (VertexConsumer)builder, (PoseStack)ms, (int)light, (int)color, (TextureAtlasSprite)fluidTexture, (float)0.5f);
        }
        ms.popPose();
    }

    public static void drawFluidBox(GuiGraphics g, int x, int y, int sizeX, int sizeY, FluidStack fs) {
        if (fs == null || fs.isEmpty()) {
            return;
        }
        TextureAtlasSprite spr = FluidRenderHelper.getStillTextureOrMissing(fs);
        int argb = FluidRenderHelper.getColor(fs, null, null);
        FluidRenderHelper.drawFluidBox(g, x, y, sizeX, sizeY, spr, argb);
    }

    public static void drawFluidBox(GuiGraphics g, int x, int y, int sizeX, int sizeY, TextureAtlasSprite spr, int argb) {
        int h;
        if (spr == null) {
            return;
        }
        float a = (float)(argb >>> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >>> 16 & 0xFF) / 255.0f;
        float gg = (float)(argb >>> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        g.setColor(r, gg, b, a);
        int u0px = spr.getX();
        int v0px = spr.getY();
        int sw = spr.contents().width();
        int sh = spr.contents().height();
        float u0 = spr.getU0();
        float u1 = spr.getU1();
        float v0 = spr.getV0();
        float v1 = spr.getV1();
        int atlasW = Math.round((float)sw / (u1 - u0));
        int atlasH = Math.round((float)sh / (v1 - v0));
        for (int oy = 0; oy < sizeY; oy += h) {
            int w;
            h = Math.min(sh, sizeY - oy);
            for (int ox = 0; ox < sizeX; ox += w) {
                w = Math.min(sw, sizeX - ox);
                g.blit(spr.atlasLocation(), x + ox, y + oy, w, h, (float)u0px, (float)v0px, w, h, atlasW, atlasH);
            }
        }
        g.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderFluidBox(FluidState fluid, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, MultiBufferSource buffer, PoseStack ms, int light, boolean renderBottom, boolean invertGasses) {
        FluidRenderHelper.renderFluidBox(fluid, xMin, yMin, zMin, xMax, yMax, zMax, FluidRenderHelper.getFluidBuilder(buffer), ms, light, renderBottom, invertGasses);
    }

    public static void renderFluidBox(FluidState fluid, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, VertexConsumer builder, PoseStack ms, int light, boolean renderBottom, boolean invertGasses) {
        FluidRenderHelper.renderFluidBox(FluidRenderHelper.toStack(fluid), xMin, yMin, zMin, xMax, yMax, zMax, builder, ms, light, renderBottom, invertGasses);
    }

    public static void renderFluidBox(FluidStack fluid, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, MultiBufferSource buffer, PoseStack ms, int light, boolean renderBottom, boolean invertGasses) {
        FluidRenderHelper.renderFluidBox(fluid, xMin, yMin, zMin, xMax, yMax, zMax, FluidRenderHelper.getFluidBuilder(buffer), ms, light, renderBottom, invertGasses);
    }

    public static VertexConsumer getFluidBuilder(MultiBufferSource buffer) {
        return buffer.getBuffer(RenderType.translucent());
    }

    public static void renderFluidBox(FluidStack fluid, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, VertexConsumer builder, PoseStack ms, int light, boolean renderBottom, boolean invertGasses) {
        TextureAtlasSprite fluidTexture = FluidRenderHelper.getStillTextureOrMissing(fluid);
        int color = FluidRenderHelper.getColor(fluid, null, null);
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, FluidRenderHelper.getLuminosity(fluid));
        light = light & 0xF00000 | luminosity << 4;
        Vec3 center = new Vec3((double)(xMin + (xMax - xMin) / 2.0f), (double)(yMin + (yMax - yMin) / 2.0f), (double)(zMin + (zMax - zMin) / 2.0f));
        ms.pushPose();
        if (invertGasses && FluidRenderHelper.isLighterThanAir(fluid)) {
            ms.translate(center.x, center.y, center.z);
            ms.mulPose(Axis.XP.rotationDegrees(180.0f));
            ms.translate(-center.x, -center.y, -center.z);
        }
        for (Direction side : Direction.values()) {
            boolean positive;
            if (side == Direction.DOWN && !renderBottom) continue;
            boolean bl = positive = side.getAxisDirection() == Direction.AxisDirection.POSITIVE;
            if (side.getAxis().isHorizontal()) {
                if (side.getAxis() == Direction.Axis.X) {
                    FluidRenderHelper.renderStillTiledFace(side, zMin, yMin, zMax, yMax, positive ? xMax : xMin, builder, ms, light, color, fluidTexture);
                    continue;
                }
                FluidRenderHelper.renderStillTiledFace(side, xMin, yMin, xMax, yMax, positive ? zMax : zMin, builder, ms, light, color, fluidTexture);
                continue;
            }
            FluidRenderHelper.renderStillTiledFace(side, xMin, zMin, xMax, zMax, positive ? yMax : yMin, builder, ms, light, color, fluidTexture);
        }
        ms.popPose();
    }

    public static void renderStillTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture) {
        FluidRenderHelper.renderTiledFace(dir, left, down, right, up, depth, builder, ms, light, color, texture, 1.0f);
    }

    public static void renderTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture, float textureScale) {
        boolean positive = dir.getAxisDirection() == Direction.AxisDirection.POSITIVE;
        boolean horizontal = dir.getAxis().isHorizontal();
        boolean x = dir.getAxis() == Direction.Axis.X;
        float shrink = texture.uvShrinkRatio() * 0.25f * textureScale;
        float centerU = texture.getU0() + (texture.getU1() - texture.getU0()) * 0.5f * textureScale;
        float centerV = texture.getV0() + (texture.getV1() - texture.getV0()) * 0.5f * textureScale;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float x1 = left;
        while (x1 < right) {
            float u2;
            float u1;
            float f = Mth.floor((float)x1);
            x2 = Math.min(f + 1.0f, right);
            if (dir == Direction.NORTH || dir == Direction.EAST) {
                f = Mth.ceil((float)x2);
                u1 = texture.getU((f - x2) * textureScale);
                u2 = texture.getU((f - x1) * textureScale);
            } else {
                u1 = texture.getU((x1 - f) * textureScale);
                u2 = texture.getU((x2 - f) * textureScale);
            }
            u1 = Mth.lerp((float)shrink, (float)u1, (float)centerU);
            u2 = Mth.lerp((float)shrink, (float)u2, (float)centerU);
            float y1 = down;
            while (y1 < up) {
                float v2;
                float v1;
                f = Mth.floor((float)y1);
                y2 = Math.min(f + 1.0f, up);
                if (dir == Direction.UP) {
                    v1 = texture.getV((y1 - f) * textureScale);
                    v2 = texture.getV((y2 - f) * textureScale);
                } else {
                    f = Mth.ceil((float)y2);
                    v1 = texture.getV((f - y2) * textureScale);
                    v2 = texture.getV((f - y1) * textureScale);
                }
                v1 = Mth.lerp((float)shrink, (float)v1, (float)centerV);
                v2 = Mth.lerp((float)shrink, (float)v2, (float)centerV);
                if (horizontal) {
                    if (x) {
                        FluidRenderHelper.putVertex(builder, ms, depth, y2, positive ? x2 : x1, color, u1, v1, dir, light);
                        FluidRenderHelper.putVertex(builder, ms, depth, y1, positive ? x2 : x1, color, u1, v2, dir, light);
                        FluidRenderHelper.putVertex(builder, ms, depth, y1, positive ? x1 : x2, color, u2, v2, dir, light);
                        FluidRenderHelper.putVertex(builder, ms, depth, y2, positive ? x1 : x2, color, u2, v1, dir, light);
                    } else {
                        FluidRenderHelper.putVertex(builder, ms, positive ? x1 : x2, y2, depth, color, u1, v1, dir, light);
                        FluidRenderHelper.putVertex(builder, ms, positive ? x1 : x2, y1, depth, color, u1, v2, dir, light);
                        FluidRenderHelper.putVertex(builder, ms, positive ? x2 : x1, y1, depth, color, u2, v2, dir, light);
                        FluidRenderHelper.putVertex(builder, ms, positive ? x2 : x1, y2, depth, color, u2, v1, dir, light);
                    }
                } else {
                    FluidRenderHelper.putVertex(builder, ms, x1, depth, positive ? y1 : y2, color, u1, v1, dir, light);
                    FluidRenderHelper.putVertex(builder, ms, x1, depth, positive ? y2 : y1, color, u1, v2, dir, light);
                    FluidRenderHelper.putVertex(builder, ms, x2, depth, positive ? y2 : y1, color, u2, v2, dir, light);
                    FluidRenderHelper.putVertex(builder, ms, x2, depth, positive ? y1 : y2, color, u2, v1, dir, light);
                }
                y1 = y2;
            }
            x1 = x2;
        }
    }

    private static void putVertex(VertexConsumer builder, PoseStack ms, float x, float y, float z, int color, float u, float v, Direction face, int light) {
        Vec3i normal = face.getNormal();
        PoseStack.Pose peek = ms.last();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.addVertex(peek.pose(), x, y, z).setColor(r, g, b, a).setUv(u, v).setLight(light).setNormal(peek.copy(), (float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
    }

    private static TextureAtlasSprite safe(Function<ResourceLocation, TextureAtlasSprite> atlas, ResourceLocation rl) {
        return rl != null ? atlas.apply(rl) : atlas.apply(MissingTextureAtlasSprite.getLocation());
    }

    public static int getLuminosity(FluidStack fluid) {
        return fluid.getFluid().getFluidType().getLightLevel();
    }

    public static TextureAtlasSprite getStillTexture(FluidStack fluid) {
        ResourceLocation id = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getStillTexture(fluid);
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(id);
    }

    public static TextureAtlasSprite getStillTextureOrMissing(FluidStack fluid) {
        TextureAtlasSprite texture = FluidRenderHelper.getStillTexture(fluid);
        if (texture != null) {
            return texture;
        }
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(MissingTextureAtlasSprite.getLocation());
    }

    public static int getColor(FluidStack stack, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos) {
        Fluid fluid = stack.getFluid();
        IClientFluidTypeExtensions extension = IClientFluidTypeExtensions.of((Fluid)fluid);
        if (level == null || pos == null) {
            return extension.getTintColor(stack);
        }
        return extension.getTintColor(fluid.defaultFluidState(), level, pos);
    }

    public static boolean isLighterThanAir(FluidStack fluid) {
        return fluid.getFluid().getFluidType().isLighterThanAir();
    }

    public static FluidStack toStack(FluidState state) {
        return new FluidStack(state.getType(), 1000);
    }
}

