/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.client;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class PaletteHelper {
    public static BufferedImage gradientToImage(int size, int ... colors) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int color : colors) {
            list.add(color);
        }
        return PaletteHelper.gradientToImage(size, list);
    }

    public static BufferedImage gradientToImage(int size, List<Integer> colors) {
        return PaletteHelper.paletteToImage(PaletteHelper.colorsToGradient(size, colors));
    }

    public static BufferedImage paletteToImage(int ... colors) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int color : colors) {
            list.add(color);
        }
        return PaletteHelper.paletteToImage(list);
    }

    public static BufferedImage paletteToImage(List<Integer> colors) {
        int width = colors.size();
        int height = 1;
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int i = 0; i < colors.size(); ++i) {
            image.setRGB(i, 0, colors.get(i));
        }
        return image;
    }

    public static List<Integer> colorsToGradient(int size, int ... colors) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int color : colors) {
            list.add(color);
        }
        return PaletteHelper.colorsToGradient(size, list);
    }

    public static List<Integer> colorsToGradient(int size, List<Integer> colors) {
        if (size == colors.size()) {
            return new ArrayList<Integer>(colors);
        }
        ArrayList<Integer> gradient = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            float position = (float)i / (float)(size - 1);
            float scaledPosition = position * (float)(colors.size() - 1);
            int segmentIndex = (int)scaledPosition;
            float segmentT = scaledPosition - (float)segmentIndex;
            if (segmentIndex >= colors.size() - 1) {
                gradient.add(colors.getLast());
                continue;
            }
            int color = PaletteHelper.getColor(colors, segmentIndex, segmentT);
            gradient.add(color);
        }
        return gradient;
    }

    private static int getColor(List<Integer> colors, int segmentIndex, float segmentT) {
        Integer color1 = colors.get(segmentIndex);
        Integer color2 = colors.get(segmentIndex + 1);
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * segmentT);
        int g = (int)((float)g1 + (float)(g2 - g1) * segmentT);
        int b = (int)((float)b1 + (float)(b2 - b1) * segmentT);
        return r << 16 | g << 8 | b;
    }
}

