/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.client.PaletteHelper;
import dev.lopyluna.slag.content.types.MaterialType;
import dev.lopyluna.slag.content.types.ModularType;
import dev.lopyluna.slag.content.types.PartType;
import dev.lopyluna.slag.register.AllDynamicTypes;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;

@EventBusSubscriber(modid="slag", value={Dist.CLIENT})
public class ResourceFallbackGenerator {
    private static final Map<ResourceLocation, JsonObject> RUNTIME_MODELS = new ConcurrentHashMap<ResourceLocation, JsonObject>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Path GENERATED_PACK_PATH;

    @SubscribeEvent
    public static void onRegisterAdditional(ModelEvent.RegisterAdditional event) {
        try {
            ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
            Set namespaces = resourceManager.getNamespaces();
            for (String namespace : namespaces) {
                String partPath = "models/item/dynamic_parts";
                String modularPath = "models/item/modular";
                try {
                    Map partResources = resourceManager.listResources(partPath, path -> path.getPath().endsWith(".json") && path.getNamespace().equals(namespace));
                    for (ResourceLocation resourceKey : partResources.keySet()) {
                        String path2 = resourceKey.getPath();
                        if (!path2.startsWith("models/") || !path2.endsWith(".json")) continue;
                        String modelPath = path2.substring("models/".length(), path2.length() - ".json".length());
                        ResourceLocation modelLocation = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)modelPath);
                        event.register(ModelResourceLocation.standalone((ResourceLocation)modelLocation));
                    }
                    Map modularResources = resourceManager.listResources(modularPath, path -> path.getPath().endsWith(".json") && path.getNamespace().equals(namespace));
                    for (ResourceLocation resourceKey : modularResources.keySet()) {
                        String path3 = resourceKey.getPath();
                        if (!path3.startsWith("models/") || !path3.endsWith(".json")) continue;
                        String modelPath = path3.substring("models/".length(), path3.length() - ".json".length());
                        ResourceLocation modelLocation = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)modelPath);
                        event.register(ModelResourceLocation.standalone((ResourceLocation)modelLocation));
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void onAddPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() != PackType.CLIENT_RESOURCES) {
            return;
        }
        try {
            GENERATED_PACK_PATH = ResourceFallbackGenerator.getGeneratedPackPath();
            ResourceFallbackGenerator.generateModelsFromRegistry();
            int generated = ResourceFallbackGenerator.generateAllModels();
            int palettesGenerated = ResourceFallbackGenerator.generateAllPalettes();
            ResourceFallbackGenerator.generateAtlasFile(generated > 0 || palettesGenerated > 0);
            ResourceFallbackGenerator.createPackMcmeta();
            PackLocationInfo packLocationInfo = new PackLocationInfo("slag_generated_models", (Component)Component.literal((String)"Slag Generated Assets"), PackSource.BUILT_IN, Optional.empty());
            PathPackResources.PathResourcesSupplier packResources = new PathPackResources.PathResourcesSupplier(GENERATED_PACK_PATH);
            PackSelectionConfig packSelectionConfig = new PackSelectionConfig(true, Pack.Position.BOTTOM, true);
            Pack pack = Pack.readMetaAndCreate((PackLocationInfo)packLocationInfo, (Pack.ResourcesSupplier)packResources, (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)packSelectionConfig);
            if (pack != null) {
                event.addRepositorySource(consumer -> consumer.accept(pack));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Path getGeneratedPackPath() {
        return FMLPaths.GAMEDIR.get().resolve("generated");
    }

    private static int generateAllModels() {
        int generated = 0;
        for (Map.Entry<ResourceLocation, JsonObject> entry : RUNTIME_MODELS.entrySet()) {
            ResourceLocation modelLocation = entry.getKey();
            JsonObject modelJson = entry.getValue();
            try {
                if (!ResourceFallbackGenerator.writeModelFileIfMissing(modelLocation, modelJson)) continue;
                ++generated;
            }
            catch (IOException iOException) {}
        }
        return generated;
    }

    private static boolean createPackMcmeta() throws IOException {
        Path packMcmeta = GENERATED_PACK_PATH.resolve("pack.mcmeta");
        if (Files.exists(packMcmeta, new LinkOption[0])) {
            return false;
        }
        Files.createDirectories(GENERATED_PACK_PATH, new FileAttribute[0]);
        JsonObject pack = new JsonObject();
        JsonObject packInfo = new JsonObject();
        packInfo.addProperty("pack_format", (Number)34);
        packInfo.addProperty("description", "Runtime generated assets for Slag n' Embers");
        pack.add("pack", (JsonElement)packInfo);
        String jsonString = GSON.toJson((JsonElement)pack);
        Files.writeString(packMcmeta, (CharSequence)jsonString, new OpenOption[0]);
        return true;
    }

    private static boolean writeModelFileIfMissing(ResourceLocation modelLocation, JsonObject modelJson) throws IOException {
        String path;
        String namespace = modelLocation.getNamespace();
        Path modelFile = GENERATED_PACK_PATH.resolve("assets/" + namespace + "/models/" + (path = modelLocation.getPath()) + ".json");
        if (Files.exists(modelFile, new LinkOption[0])) {
            return false;
        }
        Files.createDirectories(modelFile.getParent(), new FileAttribute[0]);
        String jsonString = GSON.toJson((JsonElement)modelJson);
        Files.writeString(modelFile, (CharSequence)jsonString, new OpenOption[0]);
        return true;
    }

    private static void generateModelsFromRegistry() {
        List<Pair<ResourceLocation, ResourceLocation>> requestedModels = ResourceFallbackGenerator.getRequestedModels();
        for (Pair<ResourceLocation, ResourceLocation> pair : requestedModels) {
            ResourceLocation modelLocation = (ResourceLocation)pair.getFirst();
            ResourceLocation textureLocation = (ResourceLocation)pair.getSecond();
            String texturePath = textureLocation.getNamespace() + ":" + textureLocation.getPath();
            JsonObject model = new JsonObject();
            model.addProperty("parent", "minecraft:item/generated");
            JsonObject textures = new JsonObject();
            textures.addProperty("layer0", texturePath);
            model.add("textures", (JsonElement)textures);
            RUNTIME_MODELS.put(modelLocation, model);
        }
    }

    private static boolean generateAtlasFile(boolean force) throws IOException {
        JsonArray sources;
        JsonObject root;
        JsonObject existingJson;
        Path atlasFile = GENERATED_PACK_PATH.resolve("assets/minecraft/atlases/blocks.json");
        boolean fileExists = Files.exists(atlasFile, new LinkOption[0]);
        if (fileExists && !force && (existingJson = (JsonObject)GSON.fromJson(Files.readString(atlasFile), JsonObject.class)).has("sources") && !existingJson.getAsJsonArray("sources").isEmpty()) {
            return false;
        }
        Files.createDirectories(atlasFile.getParent(), new FileAttribute[0]);
        if (fileExists) {
            try {
                root = (JsonObject)GSON.fromJson(Files.readString(atlasFile), JsonObject.class);
                sources = root.has("sources") ? root.getAsJsonArray("sources") : new JsonArray();
            }
            catch (Exception e) {
                root = new JsonObject();
                sources = new JsonArray();
            }
        } else {
            root = new JsonObject();
            sources = new JsonArray();
        }
        Collection<MaterialType> materials = AllDynamicTypes.getAllMaterials();
        Collection<PartType> parts = AllDynamicTypes.getAllParts();
        Collection<ModularType> modulars = AllDynamicTypes.getAllModulars();
        HashMap materialsTextures = new HashMap();
        for (MaterialType materialType : materials) {
            String string = materialType.id.getPath();
            String paletteKey = materialType.id.getNamespace() + ":color_palettes/" + string;
            String texture = materialType.texture;
            if (materialsTextures.containsKey(texture)) {
                ((Map)materialsTextures.get(texture)).put(string, paletteKey);
                continue;
            }
            HashMap<String, CallSite> matTextures = new HashMap<String, CallSite>();
            matTextures.put(string, (CallSite)((Object)paletteKey));
            materialsTextures.put(texture, matTextures);
        }
        if (materialsTextures.isEmpty()) {
            return false;
        }
        boolean anyChanges = false;
        for (Map.Entry entry : materialsTextures.entrySet()) {
            String textureCategory = (String)entry.getKey();
            Map mats = (Map)entry.getValue();
            JsonObject existingEntry = ResourceFallbackGenerator.findSlagEntryByTextureCategory(sources, textureCategory, modulars, parts, false);
            if (existingEntry != null) {
                boolean changed = ResourceFallbackGenerator.updatePalettedPermutation(existingEntry, modulars, parts, textureCategory, mats, false);
                if (changed) {
                    anyChanges = true;
                }
            } else {
                sources.add((JsonElement)ResourceFallbackGenerator.createPalettedPermutation(modulars, parts, textureCategory, mats, false));
                anyChanges = true;
            }
            JsonObject existingArmorEntry = ResourceFallbackGenerator.findSlagEntryByTextureCategory(sources, textureCategory, modulars, parts, true);
            HashMap<String, String> armorMats = new HashMap<String, String>();
            for (Map.Entry matEntry : mats.entrySet()) {
                armorMats.put((String)matEntry.getKey(), ((String)matEntry.getValue()).replace("color_palettes/", "color_palettes/armor/"));
            }
            if (existingArmorEntry != null) {
                boolean changed = ResourceFallbackGenerator.updatePalettedPermutation(existingArmorEntry, modulars, parts, textureCategory, armorMats, true);
                if (!changed) continue;
                anyChanges = true;
                continue;
            }
            sources.add((JsonElement)ResourceFallbackGenerator.createPalettedPermutation(modulars, parts, textureCategory, armorMats, true));
            anyChanges = true;
        }
        if (!anyChanges) {
            return false;
        }
        root.add("sources", (JsonElement)sources);
        String string = GSON.toJson((JsonElement)root);
        Files.writeString(atlasFile, (CharSequence)string, new OpenOption[0]);
        return true;
    }

    private static int generateAllPalettes() {
        List<Pair<ResourceLocation, List<Integer>>> requestedPalettes = ResourceFallbackGenerator.getRequestedPalettes();
        int generated = 0;
        for (Pair<ResourceLocation, List<Integer>> palette : requestedPalettes) {
            try {
                if (!ResourceFallbackGenerator.generatePaletteImage((ResourceLocation)palette.getFirst(), (List)palette.getSecond())) continue;
                ++generated;
            }
            catch (IOException iOException) {}
        }
        return generated;
    }

    private static boolean generatePaletteImage(ResourceLocation loc, List<Integer> colors) throws IOException {
        String namespace = loc.getNamespace();
        String path = loc.getPath();
        Path modelFile = GENERATED_PACK_PATH.resolve("assets/" + namespace + "/textures/color_palettes/" + path + ".png");
        Path modelFileArmor = GENERATED_PACK_PATH.resolve("assets/" + namespace + "/textures/color_palettes/armor/" + path + ".png");
        if (Files.exists(modelFile, new LinkOption[0])) {
            return false;
        }
        Files.createDirectories(modelFile.getParent(), new FileAttribute[0]);
        Files.createDirectories(modelFileArmor.getParent(), new FileAttribute[0]);
        BufferedImage image = PaletteHelper.gradientToImage(8, colors);
        List<Integer> armorColors = PaletteHelper.colorsToGradient(8, colors);
        armorColors.removeLast();
        BufferedImage imageArmor = PaletteHelper.gradientToImage(9, armorColors);
        ImageIO.write((RenderedImage)image, "png", modelFile.toFile());
        ImageIO.write((RenderedImage)imageArmor, "png", modelFileArmor.toFile());
        return true;
    }

    private static JsonObject findSlagEntryByTextureCategory(JsonArray sources, String textureCategory, Collection<ModularType> modulars, Collection<PartType> parts, boolean isArmor) {
        String paletteKey = isArmor ? "slag:color_palettes/armor/base_palette" : "slag:color_palettes/base_palette";
        for (int i = 0; i < sources.size(); ++i) {
            Object prefix;
            JsonArray textures;
            JsonObject obj;
            JsonElement element = sources.get(i);
            if (!element.isJsonObject() || !(obj = element.getAsJsonObject()).has("type") || !obj.get("type").getAsString().equals("paletted_permutations") || !obj.has("palette_key") || !obj.get("palette_key").getAsString().equals(paletteKey) || !obj.has("textures") || !obj.get("textures").isJsonArray() || (textures = obj.getAsJsonArray("textures")).isEmpty()) continue;
            String firstTexture = textures.get(0).getAsString();
            if (isArmor) {
                if (!firstTexture.startsWith("slag:armors/" + textureCategory + "_layer_")) continue;
                return obj;
            }
            Object object = prefix = textureCategory.isEmpty() ? "slag:item/dynamic_parts/" : "slag:item/dynamic_parts/" + textureCategory + "/";
            if (!firstTexture.startsWith((String)prefix)) continue;
            return obj;
        }
        return null;
    }

    private static boolean updatePalettedPermutation(JsonObject entry, Collection<ModularType> modulars, Collection<PartType> parts, String textureCategory, Map<String, String> materials, boolean isArmor) {
        JsonArray existingTextures = entry.has("textures") ? entry.getAsJsonArray("textures") : new JsonArray();
        HashSet<String> existingTextureSet = new HashSet<String>();
        for (int i = 0; i < existingTextures.size(); ++i) {
            existingTextureSet.add(existingTextures.get(i).getAsString());
        }
        int texturesAdded = 0;
        if (isArmor) {
            for (int layer = 1; layer <= 2; ++layer) {
                String textureLocation = "slag:armors/" + textureCategory + "_layer_" + layer;
                if (existingTextureSet.contains(textureLocation)) continue;
                existingTextures.add(textureLocation);
                ++texturesAdded;
            }
            for (PartType part : parts) {
                String partID = part.id.getPath();
                if (partID.contains("helmet") || partID.contains("chestplate") || partID.contains("leggings") || partID.contains("boots")) continue;
                for (int i = 1; i <= 2; ++i) {
                    String partTextureLocation = "slag:armors/" + partID + "/" + textureCategory + "_layer_" + i;
                    if (existingTextureSet.contains(partTextureLocation)) continue;
                    existingTextures.add(partTextureLocation);
                    ++texturesAdded;
                }
            }
        } else {
            Object prefix = textureCategory.isEmpty() ? "slag:item/dynamic_parts/" : "slag:item/dynamic_parts/" + textureCategory + "/";
            Object modularPrefix = textureCategory.isEmpty() ? "slag:item/modular/" : "slag:item/modular/${modular}/" + textureCategory + "/";
            for (PartType partType : parts) {
                String partID = partType.id.getPath();
                String textureLocation = (String)prefix + partID;
                if (!existingTextureSet.contains(textureLocation)) {
                    existingTextures.add(textureLocation);
                    ++texturesAdded;
                }
                for (ModularType modular : modulars) {
                    String modularID;
                    String textLoc;
                    if (!modular.segments.contains(partType.segmentPart) || existingTextureSet.contains(textLoc = ((String)modularPrefix).replace("${modular}", modularID = modular.id.getPath()) + partID)) continue;
                    existingTextures.add(textLoc);
                    ++texturesAdded;
                }
            }
        }
        entry.add("textures", (JsonElement)existingTextures);
        JsonObject existingPermutations = entry.has("permutations") ? entry.getAsJsonObject("permutations") : new JsonObject();
        int permutationsAdded = 0;
        for (Map.Entry entry2 : materials.entrySet()) {
            if (!existingPermutations.has((String)entry2.getKey())) {
                ++permutationsAdded;
            }
            existingPermutations.addProperty((String)entry2.getKey(), (String)entry2.getValue());
        }
        entry.add("permutations", (JsonElement)existingPermutations);
        return texturesAdded > 0 || permutationsAdded > 0;
    }

    private static JsonObject createPalettedPermutation(Collection<ModularType> modulars, Collection<PartType> parts, String textureCategory, Map<String, String> materials, boolean isArmor) {
        JsonObject entry = new JsonObject();
        entry.addProperty("type", "paletted_permutations");
        JsonArray textures = new JsonArray();
        if (isArmor) {
            for (int layer = 1; layer <= 2; ++layer) {
                textures.add("slag:armors/" + textureCategory + "_layer_" + layer);
            }
            for (PartType part : parts) {
                String partID = part.id.getPath();
                if (partID.contains("helmet") || partID.contains("chestplate") || partID.contains("leggings") || partID.contains("boots")) continue;
                for (int layer = 1; layer <= 2; ++layer) {
                    textures.add("slag:armors/" + (String)partID + "/" + textureCategory + "_layer_" + layer);
                }
            }
            entry.addProperty("palette_key", "slag:color_palettes/armor/base_palette");
        } else {
            Object prefix = textureCategory.isEmpty() ? "slag:item/dynamic_parts/" : "slag:item/dynamic_parts/" + textureCategory + "/";
            Object modularPrefix = textureCategory.isEmpty() ? "slag:item/modular/" : "slag:item/modular/${modular}/" + textureCategory + "/";
            for (PartType part : parts) {
                String partID = part.id.getPath();
                textures.add((String)prefix + partID);
                for (ModularType modular : modulars) {
                    if (!modular.segments.contains(part.segmentPart)) continue;
                    String modularID = modular.id.getPath();
                    textures.add(((String)modularPrefix).replace("${modular}", modularID) + partID);
                }
            }
            entry.addProperty("palette_key", "slag:color_palettes/base_palette");
        }
        entry.add("textures", (JsonElement)textures);
        JsonObject permutations = new JsonObject();
        for (Map.Entry<String, String> materialEntry : materials.entrySet()) {
            permutations.addProperty(materialEntry.getKey(), materialEntry.getValue());
        }
        entry.add("permutations", (JsonElement)permutations);
        return entry;
    }

    public static void addRuntimeModel(ResourceLocation modelLocation, JsonObject modelJson) {
        RUNTIME_MODELS.put(modelLocation, modelJson);
    }

    public static void addRuntimeModel(ResourceLocation modelLocation, String textureLayer0) {
        JsonObject model = new JsonObject();
        model.addProperty("parent", "minecraft:item/generated");
        JsonObject textures = new JsonObject();
        textures.addProperty("layer0", textureLayer0);
        model.add("textures", (JsonElement)textures);
        RUNTIME_MODELS.put(modelLocation, model);
    }

    public static void clearRuntimeModels() {
        RUNTIME_MODELS.clear();
    }

    public static void reloadModels(boolean reloadPack) {
        try {
            boolean genPackPath;
            boolean bl = genPackPath = GENERATED_PACK_PATH == null;
            if (genPackPath) {
                GENERATED_PACK_PATH = ResourceFallbackGenerator.getGeneratedPackPath();
            }
            ResourceFallbackGenerator.generateModelsFromRegistry();
            int generated = ResourceFallbackGenerator.generateAllModels();
            int palettesGenerated = ResourceFallbackGenerator.generateAllPalettes();
            Path atlasFile = GENERATED_PACK_PATH.resolve("assets/minecraft/atlases/blocks.json");
            boolean atlasExists = Files.exists(atlasFile, new LinkOption[0]);
            boolean forceAtlas = reloadPack || generated > 0 || palettesGenerated > 0 || !atlasExists;
            boolean atlasChanged = ResourceFallbackGenerator.generateAtlasFile(forceAtlas);
            boolean packCreated = ResourceFallbackGenerator.createPackMcmeta();
            if ((generated > 0 || palettesGenerated > 0 || atlasChanged || packCreated || genPackPath) && reloadPack) {
                Minecraft.getInstance().execute(() -> Minecraft.getInstance().reloadResourcePacks());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static List<Pair<ResourceLocation, ResourceLocation>> getRequestedModels() {
        ArrayList<Pair<ResourceLocation, ResourceLocation>> list = new ArrayList<Pair<ResourceLocation, ResourceLocation>>();
        Collection<MaterialType> materials = AllDynamicTypes.getAllMaterials();
        Collection<PartType> parts = AllDynamicTypes.getAllParts();
        Collection<ModularType> modulars = AllDynamicTypes.getAllModulars();
        for (MaterialType material : materials) {
            String matID = material.id.getPath();
            String targetMod = material.id.getNamespace();
            for (PartType part : parts) {
                String partID = part.id.getPath();
                String namePath = "item/dynamic_parts/" + matID + "/" + partID;
                String texturePath = "item/dynamic_parts/" + material.texture + "/" + partID + "_" + matID;
                list.add((Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)SlagEmbers.loc(targetMod, namePath), (Object)SlagEmbers.loc(targetMod, texturePath)));
                for (ModularType modular : modulars) {
                    if (!modular.segments.contains(part.segmentPart)) continue;
                    String modularID = modular.id.getPath();
                    namePath = "item/modular/" + modularID + "/" + matID + "/" + partID;
                    texturePath = "item/modular/" + modularID + "/" + material.texture + "/" + partID + "_" + matID;
                    list.add((Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)SlagEmbers.loc(targetMod, namePath), (Object)SlagEmbers.loc(targetMod, texturePath)));
                }
            }
        }
        return list;
    }

    public static List<Pair<ResourceLocation, List<Integer>>> getRequestedPalettes() {
        ArrayList<Pair<ResourceLocation, List<Integer>>> list = new ArrayList<Pair<ResourceLocation, List<Integer>>>();
        Collection<MaterialType> materials = AllDynamicTypes.getAllMaterials();
        for (MaterialType material : materials) {
            List<Integer> palette = material.palette;
            if (palette == null || palette.isEmpty()) continue;
            list.add((Pair<ResourceLocation, List<Integer>>)Pair.of((Object)material.id, material.palette));
        }
        return list;
    }
}

