/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import org.jetbrains.annotations.NotNull;

public class SolidBufferSource
implements MultiBufferSource {
    private final MultiBufferSource parent;

    public SolidBufferSource(MultiBufferSource parent) {
        this.parent = parent;
    }

    @NotNull
    public VertexConsumer getBuffer(@NotNull RenderType type) {
        RenderType rt = type;
        if (type == Sheets.cutoutBlockSheet() || type == Sheets.translucentItemSheet() || type == Sheets.translucentCullBlockSheet()) {
            rt = Sheets.solidBlockSheet();
        }
        return new SolidVertexConsumer(this.parent.getBuffer(rt));
    }

    @MethodsReturnNonnullByDefault
    private static class SolidVertexConsumer
    implements VertexConsumer {
        private final VertexConsumer d;

        SolidVertexConsumer(VertexConsumer delegate) {
            this.d = delegate;
        }

        public VertexConsumer addVertex(float x, float y, float z) {
            return this.d.addVertex(x, y, z);
        }

        public VertexConsumer setColor(int r, int g, int b, int a) {
            return this.d.setColor(r, g, b, 255);
        }

        public VertexConsumer setUv(float u, float v) {
            return this.d.setUv(u, v);
        }

        public VertexConsumer setUv1(int u, int v) {
            return this.d.setUv1(u, v);
        }

        public VertexConsumer setUv2(int u, int v) {
            return this.d.setUv2(u, v);
        }

        public VertexConsumer setNormal(float x, float y, float z) {
            return this.d.setNormal(x, y, z);
        }
    }
}

