/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content;

import com.tterrag.registrate.builders.BlockEntityBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.content.items.dynamic_part.IDynamicPart;
import dev.lopyluna.slag.content.items.modular.ModularItem;
import dev.lopyluna.slag.content.types.ModularType;
import dev.lopyluna.slag.content.types.PartType;
import dev.lopyluna.slag.register.AllDataComponents;
import dev.lopyluna.slag.register.AllTags;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class AllUtils {
    public static final LinkedHashMap<ResourceKey<TrimMaterial>, Float> TRIM_MATERIALS = new LinkedHashMap();

    public static <T extends BlockEntity> BlockEntityEntry<T> simpleBE(String name, BlockEntry<?> entry, BlockEntityBuilder.BlockEntityFactory<T> factory) {
        return SlagEmbers.REG.blockEntity(name, factory).validBlock(entry).register();
    }

    public static <T extends BlockEntity> BlockEntityEntry<T> simpleBE(String name, BlockEntry<?> entry, NonNullFunction<BlockEntityRendererProvider.Context, BlockEntityRenderer<? super T>> renderer, BlockEntityBuilder.BlockEntityFactory<T> factory) {
        return SlagEmbers.REG.blockEntity(name, factory).renderer(() -> renderer).validBlock(entry).register();
    }

    public static <T> StreamCodec<ByteBuf, TagKey<T>> tagKeyStreamCodec(ResourceKey<? extends Registry<T>> registry) {
        return ResourceLocation.STREAM_CODEC.map(loc -> TagKey.create((ResourceKey)registry, (ResourceLocation)loc), TagKey::location);
    }

    public static boolean tagPresentInHotbar(Player player, TagKey<Item> tag) {
        Inventory inv = player.getInventory();
        for (int i = 0; i < Inventory.getSelectionSize(); ++i) {
            if (!inv.getItem(i).is(tag)) continue;
            return true;
        }
        return false;
    }

    public static List<ItemStack> getStacksFromTag(TagKey<Block> tag) {
        Optional opt = BuiltInRegistries.BLOCK.getTag(tag);
        if (opt.isEmpty()) {
            return List.of();
        }
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        for (Holder holder : (HolderSet.Named)opt.get()) {
            ItemStack stack = AllUtils.getStackFromBlock((Block)holder.value(), true);
            if (stack.isEmpty()) continue;
            out.add(stack);
        }
        return out;
    }

    public static ItemStack getStackFromBlock(Block block, boolean requireHeater) {
        ItemStack stack;
        BlockState state = block.defaultBlockState();
        FluidState fState = state.getFluidState();
        if (!state.is(AllTags.MELTER_HEATER) && requireHeater) {
            return ItemStack.EMPTY;
        }
        if (state.getBlock() instanceof BaseFireBlock) {
            stack = Items.BLAZE_POWDER.getDefaultInstance();
        } else if (!fState.isEmpty()) {
            Fluid type = fState.getType();
            stack = type.getBucket().getDefaultInstance();
        } else {
            stack = state.getBlock().asItem().getDefaultInstance();
        }
        stack.set(DataComponents.ITEM_NAME, (Object)block.getName());
        if (stack.isEmpty()) {
            return stack.transmuteCopy((ItemLike)Items.BARRIER);
        }
        return stack;
    }

    public static void compressible9x(DataGenContext<Item, Item> c, RegistrateRecipeProvider p, Ingredient decompact, Ingredient compact, ItemLike decompactResult, ItemLike compactResult) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)compactResult, (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), decompact).unlockedBy("has_decompact", RegistrateRecipeProvider.has((ItemLike)decompactResult)).save((RecipeOutput)p, SlagEmbers.loc("crafting/ingot_to_block_" + c.getName()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)decompactResult, (int)9).requires(compact).unlockedBy("has_compact", RegistrateRecipeProvider.has((ItemLike)compactResult)).save((RecipeOutput)p, SlagEmbers.loc("crafting/ingot_from_block_" + c.getName()));
    }

    public static boolean matchesAnyTag(ModularItem item, ItemStack self, TagKey<Item> tag) {
        if (!item.hasModularType(self) || !self.has(AllDataComponents.BAKED)) {
            return false;
        }
        ModularType modularType = item.getModularType(self);
        if (modularType == null) {
            return false;
        }
        for (TagKey<Item> itemTag : modularType.itemTags) {
            if (!AllUtils.eqOrSuperset(tag, itemTag)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesAnyTag(IDynamicPart item, ItemStack self, TagKey<Item> tag) {
        Optional<PartType> type = item.getPartType(self);
        if (type.isEmpty()) {
            return false;
        }
        for (TagKey<Item> itemTag : type.get().itemTags) {
            if (!AllUtils.eqOrSuperset(tag, itemTag)) continue;
            return true;
        }
        return false;
    }

    public static List<TagKey<Item>> getTags(ModularItem item, ItemStack self) {
        if (!item.hasModularType(self) || !self.has(AllDataComponents.BAKED)) {
            return List.of();
        }
        ModularType modularType = item.getModularType(self);
        if (modularType == null) {
            return List.of();
        }
        return modularType.itemTags;
    }

    public static List<TagKey<Item>> getTags(IDynamicPart item, ItemStack self) {
        Optional<PartType> type = item.getPartType(self);
        if (type.isEmpty()) {
            return List.of();
        }
        return type.get().itemTags;
    }

    private static boolean eqOrSuperset(TagKey<Item> tag, TagKey<Item> child) {
        if (tag.equals(child)) {
            return true;
        }
        Optional<Registry<Item>> regOpt = AllUtils.itemRegistry();
        if (regOpt.isEmpty()) {
            return false;
        }
        Registry<Item> reg = regOpt.get();
        HolderSet.Named parentSet = reg.getTag(tag).orElse(null);
        HolderSet.Named childSet = reg.getTag(child).orElse(null);
        if (parentSet == null || childSet == null) {
            return false;
        }
        HashSet parent = new HashSet();
        parentSet.forEach(parent::add);
        for (Holder h : childSet) {
            if (parent.contains(h)) continue;
            return false;
        }
        return true;
    }

    private static Optional<Registry<Item>> itemRegistry() {
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        if (srv != null) {
            return Optional.of(srv.registryAccess().registryOrThrow(Registries.ITEM));
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null) {
            return Optional.of(mc.level.registryAccess().registryOrThrow(Registries.ITEM));
        }
        return Optional.empty();
    }

    static {
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ, Float.valueOf(0.1f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.IRON, Float.valueOf(0.2f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE, Float.valueOf(0.3f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE, Float.valueOf(0.4f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.COPPER, Float.valueOf(0.5f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.GOLD, Float.valueOf(0.6f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.EMERALD, Float.valueOf(0.7f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND, Float.valueOf(0.8f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.LAPIS, Float.valueOf(0.9f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST, Float.valueOf(1.0f));
    }
}

