/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks;

import dev.lopyluna.slag.content.blocks.BEBlock;
import dev.lopyluna.slag.content.blocks.SimpleBE;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public abstract class SimpleBEBlock
extends BEBlock {
    protected SimpleBEBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    @Nonnull
    public abstract BlockEntityType<? extends BlockEntity> getBlockEntityType();

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SimpleBE) {
            SimpleBE be = (SimpleBE)blockEntity;
            if (!state.is(newState.getBlock())) {
                be.onRemoved(level, pos, state);
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SimpleBE) {
            SimpleBE be = (SimpleBE)blockEntity;
            be.onPlaced(placer, stack, level, pos, state);
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        SimpleBE be;
        ItemInteractionResult result;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SimpleBE && (result = (be = (SimpleBE)blockEntity).useItem(stack, state, level, pos, player, hand, hitResult)) != null) {
            return result;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        SimpleBE be;
        ItemInteractionResult result;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SimpleBE && (result = (be = (SimpleBE)blockEntity).useItem(ItemStack.EMPTY, state, level, pos, player, InteractionHand.MAIN_HAND, hitResult)) != null) {
            return result.result();
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> blockEntityType) {
        return (level, blockPos, blockState, t) -> {
            if (t instanceof SimpleBE) {
                SimpleBE be = (SimpleBE)t;
                be.tick(level, blockPos, blockState);
            }
        };
    }
}

