/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.basin;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lopyluna.slag.content.blocks.basin.BasinCastingRecipe;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class BasinCastingRecipeSer
implements RecipeSerializer<BasinCastingRecipe> {
    private final BasinCastingRecipe.Factory factory;
    private final MapCodec<BasinCastingRecipe> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, BasinCastingRecipe> streamCodec;

    public BasinCastingRecipeSer(BasinCastingRecipe.Factory factory) {
        this.factory = factory;
        this.codec = RecordCodecBuilder.mapCodec(instance -> {
            Products.P3 recipe = instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(Recipe::getGroup), (App)FluidStack.CODEC.fieldOf("ingredient").forGetter(BasinCastingRecipe::getInput), (App)ItemStack.CODEC.fieldOf("result").forGetter(BasinCastingRecipe::getOutput));
            Objects.requireNonNull(factory);
            return recipe.apply((Applicative)instance, factory::create);
        });
        this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
    }

    @NotNull
    public MapCodec<BasinCastingRecipe> codec() {
        return this.codec;
    }

    @NotNull
    public StreamCodec<RegistryFriendlyByteBuf, BasinCastingRecipe> streamCodec() {
        return this.streamCodec;
    }

    public String toString() {
        return "basin_casting";
    }

    private BasinCastingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        String s = buffer.readUtf();
        FluidStack input = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer);
        ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        return this.factory.create(s, input, output);
    }

    private void toNetwork(RegistryFriendlyByteBuf buffer, BasinCastingRecipe recipe) {
        buffer.writeUtf(recipe.getGroup());
        FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getInput());
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getOutput());
    }

    public BasinCastingRecipe create(String group, FluidStack input, ItemStack result) {
        return this.factory.create(group, input, result);
    }
}

