/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.basin;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.lopyluna.slag.client.AlphaBufferSource;
import dev.lopyluna.slag.client.SolidBufferSource;
import dev.lopyluna.slag.content.blocks.basin.BasinBE;
import dev.lopyluna.slag.content.blocks.basin.BasinTank;
import dev.lopyluna.slag.content.blocks.multiblock.LerpedFloat;
import dev.lopyluna.slag.content.blocks.multiblock.renderer.SafeBlockEntityRenderer;
import net.createmod.catnip.platform.NeoForgeCatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class BasinRenderer
extends SafeBlockEntityRenderer<BasinBE> {
    public BasinRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(BasinBE be, float pt, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        boolean preview;
        this.renderFluid(be, pt, ms, buffer, light);
        ItemStack stack = be.resultItemStack.isEmpty() ? be.getStack() : be.resultItemStack;
        boolean bl = preview = !be.resultItemStack.isEmpty() && be.getStack().isEmpty();
        if (stack.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ms.pushPose();
        ms.translate(0.5f, 0.575f, 0.5f);
        ms.scale(1.5f, 1.5f, 1.5f);
        float cooling = !preview ? 1.0f : (be.coolingTarget == 0 ? 0.0f : Mth.clamp((float)((float)be.coolingProgress / (float)be.coolingTarget - 0.2f), (float)0.0f, (float)1.0f));
        mc.getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, light, overlay, ms, (MultiBufferSource)new AlphaBufferSource(buffer, cooling), (Level)mc.level, 0);
        ms.popPose();
    }

    public void renderFluid(BasinBE be, float pt, PoseStack ms, MultiBufferSource buffer, int light) {
        LerpedFloat fluidLevel = be.getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        BasinTank tank = be.tankInventory;
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        float capHeight = 0.0625f;
        float tankHullWidth = 0.0140625f;
        float minPuddleHeight = 0.25f;
        float totalHeight = 1.0f - 2.0f * capHeight - minPuddleHeight;
        float level = fluidLevel.getValue(pt) + 0.00140625f;
        if (level < 1.0f / (512.0f * totalHeight)) {
            return;
        }
        float clampedLevel = Mth.clamp((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        float xMax = tankHullWidth + 1.0f - 2.0f * tankHullWidth;
        float yMin = totalHeight + capHeight + minPuddleHeight - clampedLevel;
        float yMax = yMin + clampedLevel;
        float zMax = tankHullWidth + 1.0f - 2.0f * tankHullWidth;
        ms.pushPose();
        ms.translate(0.0f, clampedLevel - totalHeight, 0.0f);
        NeoForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)fluidStack, tankHullWidth, yMin, tankHullWidth, xMax, yMax, zMax, new SolidBufferSource(buffer).getBuffer(RenderType.SOLID), ms, light, false, true);
        ms.popPose();
    }
}

