/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.crucible;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lopyluna.slag.content.blocks.crucible.AlloyingRecipe;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class AlloyingRecipeSer
implements RecipeSerializer<AlloyingRecipe> {
    private final AlloyingRecipe.Factory factory;
    private final MapCodec<AlloyingRecipe> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, AlloyingRecipe> streamCodec;

    public AlloyingRecipeSer(AlloyingRecipe.Factory factory) {
        this.factory = factory;
        this.codec = RecordCodecBuilder.mapCodec(instance -> {
            Products.P3 recipe = instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(Recipe::getGroup), (App)FluidStack.CODEC.listOf().fieldOf("ingredients").forGetter(AlloyingRecipe::getInputs), (App)FluidStack.CODEC.fieldOf("result").forGetter(AlloyingRecipe::getOutput));
            Objects.requireNonNull(factory);
            return recipe.apply((Applicative)instance, factory::create);
        });
        this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
    }

    @NotNull
    public MapCodec<AlloyingRecipe> codec() {
        return this.codec;
    }

    @NotNull
    public StreamCodec<RegistryFriendlyByteBuf, AlloyingRecipe> streamCodec() {
        return this.streamCodec;
    }

    public String toString() {
        return "alloying";
    }

    private AlloyingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        String s = buffer.readUtf();
        List inputs = (List)FluidStack.STREAM_CODEC.apply(ByteBufCodecs.list()).decode((Object)buffer);
        FluidStack fluidStack = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer);
        return this.factory.create(s, inputs, fluidStack);
    }

    private void toNetwork(RegistryFriendlyByteBuf buffer, AlloyingRecipe recipe) {
        buffer.writeUtf(recipe.getGroup());
        FluidStack.STREAM_CODEC.apply(ByteBufCodecs.list()).encode((Object)buffer, recipe.getInputs());
        FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getOutput());
    }

    public AlloyingRecipe create(String group, List<FluidStack> inputs, FluidStack result) {
        return this.factory.create(group, inputs, result);
    }
}

