/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.crucible;

import dev.lopyluna.slag.content.blocks.crucible.CrucibleTank;
import dev.lopyluna.slag.content.blocks.multiblock.FluidMultiBlockEntity;
import dev.lopyluna.slag.register.AllBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class CrucibleBE
extends FluidMultiBlockEntity {
    public boolean hasCover = false;
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.create((String)"bottom");
    public static final BooleanProperty WINDOW = BooleanProperty.create((String)"window");
    public static final EnumProperty<Shape> SHAPE = EnumProperty.create((String)"shape", Shape.class);

    public CrucibleBE(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Override
    public void lazyTick() {
        Boolean cover;
        super.lazyTick();
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide) {
            return;
        }
        CrucibleTank tank = this.getTankInventory();
        if (tank.tryAlloy(this.level, 1)) {
            tank.onContentsChanged();
        }
        if ((cover = this.hasCover()) == null) {
            return;
        }
        if (this.hasCover != cover) {
            this.hasCover = this.hasCover();
            this.setChanged();
        }
        if (!this.hasCover) {
            tank.noCoverTick();
        }
    }

    public Boolean hasCover() {
        for (int widthX = 0; widthX < this.getWidthX(); ++widthX) {
            for (int widthZ = 0; widthZ < this.getWidthZ(); ++widthZ) {
                BlockPos pos = this.getBlockPos().offset(widthX, this.height, widthZ);
                if (!this.level.isLoaded(pos)) {
                    return null;
                }
                BlockState state = this.level.getBlockState(pos);
                if (state.isAir()) {
                    return false;
                }
                if (!state.isFaceSturdy((BlockGetter)this.level, pos, Direction.DOWN)) {
                    return false;
                }
                if (!state.canBeReplaced()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void notifyMultiUpdated() {
        super.notifyMultiUpdated();
        BlockState state = this.getBlockState();
        if (state.is(AllBlocks.CRUCIBLE)) {
            state = (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(this.getController().getY() == this.getBlockPos().getY()));
            state = (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(this.getController().getY() + this.getHeight() - 1 == this.getBlockPos().getY()));
            this.level.setBlock(this.getBlockPos(), state, 6);
        }
        if (this.isController()) {
            this.setShapes();
        }
        this.setChanged();
    }

    @Override
    public void removeController(boolean keepFluids) {
        BlockState state;
        super.removeController(keepFluids);
        if (this.level != null && !this.level.isClientSide && (state = this.getBlockState()).is(AllBlocks.CRUCIBLE)) {
            state = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).setValue((Property)TOP, (Comparable)Boolean.valueOf(true))).setValue((Property)WINDOW, (Comparable)Boolean.valueOf(false))).setValue(SHAPE, (Comparable)((Object)Shape.PLAIN));
            this.level.setBlock(this.getBlockPos(), state, 22);
        }
    }

    public boolean isSameController(Level level, BlockPos pos) {
        CrucibleBE be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity instanceof CrucibleBE && (be = (CrucibleBE)blockEntity).getController().equals((Object)this.getController());
    }

    @Override
    public void setWindows(boolean window) {
        super.setWindows(window);
        this.setShapes();
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.hasCover = compound.getBoolean("hasCover");
    }

    @Override
    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putBoolean("hasCover", this.hasCover);
    }

    public void setShapes() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        boolean window = this.isWindow();
        int widthX = this.getWidthX();
        int widthZ = this.getWidthZ();
        int height = this.getHeight();
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < widthX; ++xOffset) {
                for (int zOffset = 0; zOffset < widthZ; ++zOffset) {
                    BlockPos pos = this.worldPosition.offset(xOffset, yOffset, zOffset);
                    BlockState blockState = this.level.getBlockState(pos);
                    if (!blockState.is(AllBlocks.CRUCIBLE)) continue;
                    Shape shape = this.calculateShapeForPosition(xOffset, zOffset, widthX, widthZ);
                    this.level.setBlock(pos, (BlockState)((BlockState)blockState.setValue((Property)WINDOW, (Comparable)Boolean.valueOf(window))).setValue(SHAPE, (Comparable)((Object)shape)), 22);
                }
            }
        }
    }

    private Shape calculateShapeForPosition(int xOffset, int zOffset, int widthX, int widthZ) {
        boolean isEast;
        boolean isWest;
        boolean isSouth;
        if (widthX == 1 || widthZ == 1) {
            return Shape.PLAIN;
        }
        boolean isNorth = zOffset == 0;
        int edgeCount = (isNorth ? 1 : 0) + ((isSouth = zOffset == widthZ - 1) ? 1 : 0) + ((isWest = xOffset == 0) ? 1 : 0) + ((isEast = xOffset == widthX - 1) ? 1 : 0);
        if (edgeCount == 2) {
            if (isNorth && isWest) {
                return Shape.NW;
            }
            if (isNorth && isEast) {
                return Shape.NE;
            }
            if (isSouth && isWest) {
                return Shape.SW;
            }
            if (isSouth && isEast) {
                return Shape.SE;
            }
        }
        if (edgeCount == 1) {
            if (isNorth) {
                return Shape.NORTH;
            }
            if (isSouth) {
                return Shape.SOUTH;
            }
            if (isWest) {
                return Shape.WEST;
            }
            if (isEast) {
                return Shape.EAST;
            }
        }
        return Shape.INNER;
    }

    public static enum Shape implements StringRepresentable
    {
        PLAIN,
        INNER,
        NW,
        SW,
        NE,
        SE,
        NORTH,
        SOUTH,
        WEST,
        EAST;


        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase();
        }

        public static Shape fromDir(Direction direction) {
            return switch (direction) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN, Direction.UP -> PLAIN;
                case Direction.NORTH -> NORTH;
                case Direction.SOUTH -> SOUTH;
                case Direction.WEST -> WEST;
                case Direction.EAST -> EAST;
            };
        }

        public static Shape fromDirDir(Direction dir1, Direction dir2) {
            return switch (dir1) {
                case Direction.NORTH -> {
                    switch (dir2) {
                        case NORTH: {
                            yield NORTH;
                        }
                        case WEST: {
                            yield NW;
                        }
                        case EAST: {
                            yield NE;
                        }
                    }
                    yield PLAIN;
                }
                case Direction.SOUTH -> {
                    switch (dir2) {
                        case SOUTH: {
                            yield SOUTH;
                        }
                        case WEST: {
                            yield SW;
                        }
                        case EAST: {
                            yield SE;
                        }
                    }
                    yield PLAIN;
                }
                case Direction.WEST -> {
                    switch (dir2) {
                        case NORTH: {
                            yield NW;
                        }
                        case SOUTH: {
                            yield SW;
                        }
                        case WEST: {
                            yield WEST;
                        }
                    }
                    yield PLAIN;
                }
                case Direction.EAST -> {
                    switch (dir2) {
                        case NORTH: {
                            yield NE;
                        }
                        case SOUTH: {
                            yield SE;
                        }
                        case EAST: {
                            yield EAST;
                        }
                    }
                    yield PLAIN;
                }
                default -> PLAIN;
            };
        }

        public boolean isWall() {
            return this.equals((Object)NORTH) || this.equals((Object)SOUTH) || this.equals((Object)WEST) || this.equals((Object)EAST);
        }

        public boolean isCorner() {
            return this.equals((Object)NW) || this.equals((Object)SW) || this.equals((Object)NE) || this.equals((Object)SE);
        }

        public Direction toDirection() {
            return switch (this.ordinal()) {
                case 4, 6 -> Direction.NORTH;
                case 2, 8 -> Direction.WEST;
                case 3, 7 -> Direction.SOUTH;
                case 5, 9 -> Direction.EAST;
                default -> Direction.DOWN;
            };
        }
    }
}

