/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.crucible;

import dev.lopyluna.slag.content.AllUtils;
import dev.lopyluna.slag.content.blocks.crucible.CrucibleBE;
import dev.lopyluna.slag.content.blocks.crucible.CrucibleBlock;
import dev.lopyluna.slag.content.blocks.multiblock.IMultiBlockEntityContainer;
import dev.lopyluna.slag.content.blocks.multiblock.connectivity.ConnectivityHandler;
import dev.lopyluna.slag.content.blocks.smart.SmartBlock;
import dev.lopyluna.slag.content.utils.NBTHelper;
import dev.lopyluna.slag.register.AllBETypes;
import dev.lopyluna.slag.register.AllTags;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class CrucibleItem
extends BlockItem {
    public CrucibleItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @NotNull
    public InteractionResult place(BlockPlaceContext ctx) {
        InteractionResult initialResult = super.place(ctx);
        if (!initialResult.consumesAction()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        MinecraftServer server = level.getServer();
        if (server == null) {
            return false;
        }
        CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (data != null) {
            CompoundTag nbt = data.copyTag();
            nbt.remove("Luminosity");
            nbt.remove("Size");
            nbt.remove("Height");
            nbt.remove("Controller");
            nbt.remove("LastKnownPos");
            if (nbt.contains("TankContent")) {
                int baseCapacity;
                RegistryAccess.Frozen provider = server.registryAccess();
                List<FluidStack> fluids = NBTHelper.readFluidList(nbt.getCompound("TankContent").getList("Fluids", 10), (HolderLookup.Provider)provider);
                int totalAmount = fluids.stream().mapToInt(FluidStack::getAmount).sum();
                if (totalAmount > (baseCapacity = CrucibleBE.getCapacityMultiplier())) {
                    int toRemove = totalAmount - baseCapacity;
                    for (int i = fluids.size() - 1; i >= 0 && toRemove > 0; --i) {
                        FluidStack fluid = fluids.get(i);
                        int take = Math.min(fluid.getAmount(), toRemove);
                        fluid.shrink(take);
                        toRemove -= take;
                        if (!fluid.isEmpty()) continue;
                        fluids.remove(i);
                    }
                }
                CompoundTag tag = new CompoundTag();
                tag.put("Fluids", (Tag)NBTHelper.writeFluidList(fluids, (HolderLookup.Provider)provider));
                nbt.put("TankContent", (Tag)tag);
            }
            BlockEntity.addEntityType((CompoundTag)nbt, ((SmartBlock)this.getBlock()).getBlockEntityType());
            stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)nbt));
        }
        return super.updateCustomBlockEntityTag(pos, level, player, stack, state);
    }

    private void tryMultiPlace(BlockPlaceContext ctx) {
        BlockState state;
        BlockPos offPos;
        int bOff;
        int aOff;
        BlockPos pos;
        BlockPos placedOnPos;
        Player player = ctx.getPlayer();
        if (player == null) {
            return;
        }
        if (player.isShiftKeyDown()) {
            return;
        }
        Direction face = ctx.getClickedFace();
        ItemStack stack = ctx.getItemInHand();
        Level level = ctx.getLevel();
        BlockState placedOnState = level.getBlockState(placedOnPos = (pos = ctx.getClickedPos()).relative(face.getOpposite()));
        if (!(placedOnState.getBlock() instanceof CrucibleBlock)) {
            return;
        }
        if (AllUtils.tagPresentInHotbar(player, AllTags.BLACKLISTED_HOTBAR_ITEMS)) {
            return;
        }
        Object crucibleAt = ConnectivityHandler.partAt((BlockEntityType)AllBETypes.CRUCIBLE.get(), (BlockGetter)level, placedOnPos);
        if (crucibleAt == null) {
            return;
        }
        Object ctrlBE = ((IMultiBlockEntityContainer)crucibleAt).getControllerBE();
        if (ctrlBE == null) {
            return;
        }
        int widthZ = ((IMultiBlockEntityContainer)ctrlBE).getWidthZ();
        int widthX = ((IMultiBlockEntityContainer)ctrlBE).getWidthX();
        int height = ((IMultiBlockEntityContainer)ctrlBE).getHeight();
        if (1 >= widthZ || 1 >= widthX || 0 >= height) {
            return;
        }
        int crucibleToPlace = 0;
        BlockPos startPos = switch (face) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> ctrlBE.getBlockPos().below();
            case Direction.UP -> ctrlBE.getBlockPos().above(height);
            case Direction.NORTH -> ctrlBE.getBlockPos().north();
            case Direction.SOUTH -> ctrlBE.getBlockPos().south(widthZ);
            case Direction.WEST -> ctrlBE.getBlockPos().west();
            case Direction.EAST -> ctrlBE.getBlockPos().east(widthX);
        };
        Direction.Axis axis = face.getAxis();
        if (startPos.get(axis) != pos.get(axis)) {
            return;
        }
        Direction.Axis aAxis = switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.Z, Direction.Axis.Y -> Direction.Axis.X;
            case Direction.Axis.X -> Direction.Axis.Y;
        };
        Direction.Axis bAxis = switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.Y, Direction.Axis.X -> Direction.Axis.Z;
            case Direction.Axis.Z -> Direction.Axis.Y;
        };
        int aTarget = switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.Z, Direction.Axis.Y -> widthX;
            case Direction.Axis.X -> height;
        };
        int bTarget = switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.Y, Direction.Axis.X -> widthZ;
            case Direction.Axis.Z -> height;
        };
        for (aOff = 0; aOff < aTarget; ++aOff) {
            for (bOff = 0; bOff < bTarget; ++bOff) {
                offPos = startPos.relative(aAxis, aOff).relative(bAxis, bOff);
                state = level.getBlockState(offPos);
                if (state.getBlock() instanceof CrucibleBlock) continue;
                if (!state.canBeReplaced()) {
                    return;
                }
                ++crucibleToPlace;
            }
        }
        if (!player.isCreative() && stack.getCount() < crucibleToPlace) {
            return;
        }
        for (aOff = 0; aOff < aTarget; ++aOff) {
            for (bOff = 0; bOff < bTarget; ++bOff) {
                offPos = startPos.relative(aAxis, aOff).relative(bAxis, bOff);
                state = level.getBlockState(offPos);
                if (state.getBlock() instanceof CrucibleBlock) continue;
                BlockPlaceContext ctxAt = BlockPlaceContext.at((BlockPlaceContext)ctx, (BlockPos)offPos, (Direction)face);
                player.getPersistentData().putBoolean("SilencePlacingSound", true);
                super.place(ctxAt);
                player.getPersistentData().remove("SilencePlacingSound");
            }
        }
    }
}

