/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.crucible;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.lopyluna.slag.client.FluidRenderHelper;
import dev.lopyluna.slag.content.blocks.crucible.CrucibleBE;
import dev.lopyluna.slag.content.blocks.multiblock.LerpedFloat;
import dev.lopyluna.slag.content.blocks.multiblock.renderer.SafeBlockEntityRenderer;
import java.util.ArrayList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.fluids.FluidStack;

public class CrucibleRenderer
extends SafeBlockEntityRenderer<CrucibleBE> {
    public CrucibleRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(CrucibleBE be, float pt, PoseStack ms, MultiBufferSource bs, int light, int overlay) {
        if (!be.isController()) {
            return;
        }
        LerpedFloat fluidLevel = be.getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        float capHeight = 0.0625f;
        float tankHullWidth = 0.0140625f;
        float minPuddleHeight = 0.225f;
        float totalHeight = (float)be.getHeight() - 2.0f * capHeight - minPuddleHeight;
        float level = fluidLevel.getValue(pt) + 0.00140625f;
        if (level < 1.0f / (512.0f * totalHeight)) {
            return;
        }
        float clampedLevel = Mth.clamp((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        float xMax = tankHullWidth + (float)be.getWidthX() - 2.0f * tankHullWidth;
        float zMax = tankHullWidth + (float)be.getWidthZ() - 2.0f * tankHullWidth;
        float yBase = totalHeight + capHeight + minPuddleHeight - clampedLevel;
        ArrayList<FluidStack> all = new ArrayList<FluidStack>();
        if (be.hasTank()) {
            for (FluidStack fs : be.getFluids()) {
                if (!fs.isEmpty()) {
                    all.add(fs);
                    continue;
                }
                FluidStack one = be.getTankInventory().getFluid();
                if (one.isEmpty()) continue;
                all.add(one);
            }
        }
        if (all.isEmpty()) {
            return;
        }
        ArrayList<FluidStack> liquids = new ArrayList<FluidStack>();
        int totalMb = 0;
        for (FluidStack f : all) {
            totalMb += f.getAmount();
            liquids.add(f);
        }
        if (totalMb == 0) {
            return;
        }
        float unit = clampedLevel / (float)totalMb;
        float eps = 0.001953125f;
        ms.pushPose();
        ms.translate(0.0f, clampedLevel - totalHeight, 0.0f);
        float yCur = yBase;
        for (int i = 0; i < liquids.size(); ++i) {
            FluidStack f = (FluidStack)liquids.get(i);
            float h = Math.max(0.0f, (float)f.getAmount() * unit);
            if (i == liquids.size() - 1) {
                h = yBase + clampedLevel - yCur;
            }
            if (!(h > 0.001953125f)) continue;
            boolean renderTop = i == liquids.size() - 1;
            FluidRenderHelper.renderFluidBox(f, tankHullWidth, yCur, tankHullWidth, xMax, yCur + h, zMax, bs, ms, light, true, renderTop);
            yCur += h;
        }
        ms.popPose();
    }

    public boolean shouldRenderOffScreen(CrucibleBE be) {
        return be.isController();
    }
}

