/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.crucible_interface;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.lopyluna.slag.client.ClientUtils;
import dev.lopyluna.slag.content.blocks.crucible.CrucibleTank;
import dev.lopyluna.slag.content.blocks.crucible_interface.InterfaceBE;
import dev.lopyluna.slag.content.blocks.multiblock.renderer.SafeBlockEntityRenderer;
import dev.lopyluna.slag.content.utils.ShapeUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class InterfaceRenderer
extends SafeBlockEntityRenderer<InterfaceBE> {
    public InterfaceRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(InterfaceBE be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        Level level = be.getLevel();
        if (level == null) {
            return;
        }
        BlockPos pos = be.getBlockPos();
        FluidStack fluidStack = this.getFluid(level, pos);
        if (fluidStack == null || fluidStack.isEmpty()) {
            return;
        }
        BlockState state = be.getBlockState();
        Direction facing = state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) ? (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) : (state.hasProperty((Property)BlockStateProperties.FACING) ? (Direction)state.getValue((Property)BlockStateProperties.FACING) : Direction.NORTH);
        VoxelShape shape = ShapeUtils.shape(-0.01, 7.0, 7.99, 16.009999999999998, 10.0, 9.0).forDirectional(Direction.NORTH).get(facing);
        ms.pushPose();
        ClientUtils.renderFluidShape(fluidStack, shape, buffer, ms, light, true, true);
        ms.popPose();
    }

    public IFluidHandler getFluidHandler(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof InterfaceBE) {
            InterfaceBE be = (InterfaceBE)blockEntity;
            return be.targetCap;
        }
        return null;
    }

    public FluidStack getFluid(Level level, BlockPos pos) {
        IFluidHandler handler = this.getFluidHandler(level, pos);
        if (handler == null) {
            return FluidStack.EMPTY;
        }
        if (handler instanceof CrucibleTank) {
            CrucibleTank tank = (CrucibleTank)handler;
            return tank.getFluid();
        }
        for (int i = 0; handler.getTanks() > i; ++i) {
            FluidStack fluid = handler.getFluidInTank(i);
            if (fluid.isEmpty()) continue;
            return fluid;
        }
        return FluidStack.EMPTY;
    }
}

