/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.crucible_interface.client;

import dev.lopyluna.slag.content.blocks.crucible.CrucibleTank;
import dev.lopyluna.slag.content.blocks.crucible_interface.InterfaceBE;
import dev.lopyluna.slag.content.blocks.multiblock.IMultiBlockEntityContainer;
import dev.lopyluna.slag.register.AllMenuTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class InterfaceMenu
extends AbstractContainerMenu {
    protected final Player player;
    protected final Level level;
    protected final BlockPos pos;

    public InterfaceMenu(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(windowId, playerInventory, buf.readBlockPos());
    }

    public InterfaceMenu(int syncId, Inventory playerInventory, BlockPos pos) {
        super((MenuType)AllMenuTypes.INTERFACE.get(), syncId);
        int m;
        this.player = playerInventory.player;
        this.level = this.player.level();
        this.pos = pos;
        for (m = 0; m < 3; ++m) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + m * 9 + 9, 8 + l * 18, 84 + m * 18));
            }
        }
        for (m = 0; m < 9; ++m) {
            this.addSlot(new Slot((Container)playerInventory, m, 8 + m * 18, 142));
        }
    }

    public BlockPos getControllerPos() {
        IMultiBlockEntityContainer.FluidMulti mb;
        BlockState s = this.level.getBlockState(this.pos);
        Direction facing = s.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) ? (Direction)s.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) : (s.hasProperty((Property)BlockStateProperties.FACING) ? (Direction)s.getValue((Property)BlockStateProperties.FACING) : Direction.NORTH);
        BlockPos back = this.pos.relative(facing.getOpposite());
        BlockEntity be = this.level.getBlockEntity(back);
        if (be instanceof IMultiBlockEntityContainer.FluidMulti && (mb = (IMultiBlockEntityContainer.FluidMulti)be).getControllerBE() != null) {
            return be.getBlockPos();
        }
        return back;
    }

    public boolean isCrucible() {
        return this.getFluidHandler() instanceof CrucibleTank;
    }

    public IFluidHandler getFluidHandler() {
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        if (blockEntity instanceof InterfaceBE) {
            InterfaceBE be = (InterfaceBE)blockEntity;
            return be.targetCap;
        }
        return null;
    }

    public int getCapacity() {
        IFluidHandler handler = this.getFluidHandler();
        if (handler == null) {
            return 0;
        }
        int capacity = 0;
        for (int i = 0; handler.getTanks() > i; ++i) {
            capacity += handler.getTankCapacity(i);
        }
        return capacity;
    }

    public int getAmount() {
        IFluidHandler handler = this.getFluidHandler();
        if (handler == null) {
            return 0;
        }
        int amount = 0;
        for (int i = 0; handler.getTanks() > i; ++i) {
            amount += handler.getFluidInTank(i).getAmount();
        }
        return amount;
    }

    public List<FluidStack> getFluids() {
        ArrayList<FluidStack> list = new ArrayList<FluidStack>();
        IFluidHandler handler = this.getFluidHandler();
        if (handler == null) {
            return list;
        }
        if (handler instanceof CrucibleTank) {
            CrucibleTank tank = (CrucibleTank)handler;
            list.addAll(tank.getFluidCopy());
        } else {
            for (int i = 0; handler.getTanks() > i; ++i) {
                FluidStack fluid = handler.getFluidInTank(i);
                if (fluid.isEmpty()) continue;
                list.add(fluid);
            }
        }
        return list;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack copy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            copy = stack.copy();
            int size = this.slots.size();
            if (index >= 0 && index < 27 ? !this.moveItemStackTo(stack, 27, size, false) : index >= 27 && index < size && !this.moveItemStackTo(stack, 0, 27, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack.getCount() == copy.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack);
        }
        return copy;
    }

    public boolean stillValid(Player player) {
        InterfaceBE be;
        Vec3 dist = player.getEyePosition().subtract(this.pos.getCenter());
        double dx = dist.x;
        double dy = dist.y;
        double dz = dist.z;
        if (dx * dx + dy * dy + dz * dz > 64.0) {
            return false;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        return blockEntity instanceof InterfaceBE && !(be = (InterfaceBE)blockEntity).isRemoved();
    }
}

