/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.forge;

import dev.lopyluna.slag.register.AllRecipes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class DoubleSmeltingRecipe
implements Recipe<DoubleRecipeInput> {
    protected final RecipeType<?> type;
    protected final String group;
    private final Ingredient inputA;
    private final Ingredient inputB;
    private final ItemStack output;
    private final int cookingTime;
    private final float experience;

    public DoubleSmeltingRecipe(String group, Ingredient inputA, Ingredient inputB, ItemStack output, float experience, int cookingTime) {
        this((RecipeType)AllRecipes.DOUBLE_SMELTING.get(), group, inputA, inputB, output, cookingTime, experience);
    }

    public DoubleSmeltingRecipe(RecipeType<?> type, String group, Ingredient inputA, Ingredient inputB, ItemStack output, int cookingTime, float experience) {
        this.inputA = inputA;
        this.inputB = inputB;
        this.output = output;
        this.type = type;
        this.group = group;
        this.cookingTime = cookingTime;
        this.experience = experience;
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    public Ingredient getInputA() {
        return this.inputA;
    }

    public Ingredient getInputB() {
        return this.inputB;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public float getExperience() {
        return this.experience;
    }

    public boolean matches(DoubleRecipeInput doubleRecipeInput, Level level) {
        return this.inputA.test(doubleRecipeInput.getItem(0)) && this.inputB.test(doubleRecipeInput.getItem(1)) || this.inputA.test(doubleRecipeInput.getItem(1)) && this.inputB.test(doubleRecipeInput.getItem(0));
    }

    @NotNull
    public ItemStack assemble(DoubleRecipeInput doubleRecipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int i, int j) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AllRecipes.DOUBLE_SMELTING_SER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return this.type;
    }

    public record DoubleRecipeInput(ItemStack itemA, ItemStack itemB) implements RecipeInput
    {
        @NotNull
        public ItemStack getItem(int i) {
            return switch (i) {
                case 0 -> this.itemA;
                case 1 -> this.itemB;
                default -> throw new IllegalArgumentException("Recipe does not contain slot " + i);
            };
        }

        public int size() {
            return 2;
        }

        public boolean isEmpty() {
            return this.itemA.isEmpty() && this.itemB.isEmpty();
        }
    }

    public static interface Factory {
        public DoubleSmeltingRecipe create(String var1, Ingredient var2, Ingredient var3, ItemStack var4, float var5, int var6);
    }

    public static class Type
    implements RecipeType<DoubleSmeltingRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }

        public String toString() {
            return "double_smelting";
        }
    }
}

