/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.forge.client;

import dev.lopyluna.slag.content.blocks.forge.DoubleSmeltingRecipe;
import dev.lopyluna.slag.content.blocks.forge.client.ForgeFuelSlot;
import dev.lopyluna.slag.content.blocks.forge.client.ForgeResultSlot;
import dev.lopyluna.slag.register.AllMenuTypes;
import dev.lopyluna.slag.register.AllRecipes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class ForgeMenu
extends AbstractContainerMenu {
    private final Container inventory;
    private final ContainerData data;
    protected final Level level;
    private static final List<Ingredient> aIngredients = new ArrayList<Ingredient>();
    private static final List<Ingredient> bIngredients = new ArrayList<Ingredient>();

    public ForgeMenu(int syncId, Inventory inventory) {
        this(syncId, inventory, (Container)new SimpleContainer(4), (ContainerData)new SimpleContainerData(4));
    }

    public ForgeMenu(int syncId, Inventory playerInventory, Container inventory, ContainerData data) {
        super((MenuType)AllMenuTypes.FORGE.get(), syncId);
        int m;
        ForgeMenu.checkContainerSize((Container)inventory, (int)4);
        RecipeType recipeType = (RecipeType)AllRecipes.DOUBLE_SMELTING.get();
        this.inventory = inventory;
        this.data = data;
        this.level = playerInventory.player.level();
        if (aIngredients.isEmpty() || bIngredients.isEmpty() || this.level.random.nextInt(100) >= 90) {
            List recipes = this.level.getRecipeManager().getAllRecipesFor(recipeType);
            ArrayList<Ingredient> aIngredients = new ArrayList<Ingredient>();
            ArrayList<Ingredient> bIngredients = new ArrayList<Ingredient>();
            for (RecipeHolder holder : recipes) {
                DoubleSmeltingRecipe recipe = (DoubleSmeltingRecipe)holder.value();
                aIngredients.add(recipe.getInputA());
                bIngredients.add(recipe.getInputB());
            }
            ForgeMenu.aIngredients.addAll(aIngredients);
            ForgeMenu.bIngredients.addAll(bIngredients);
        }
        this.addSlot(new Slot(inventory, 0, 46, 17));
        this.addSlot(new Slot(inventory, 1, 66, 17));
        this.addSlot(new ForgeFuelSlot(this, inventory, 2, 56, 53));
        this.addSlot((Slot)new ForgeResultSlot(playerInventory.player, inventory, 3, 116, 35));
        for (m = 0; m < 3; ++m) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + m * 9 + 9, 8 + l * 18, 84 + m * 18));
            }
        }
        for (m = 0; m < 9; ++m) {
            this.addSlot(new Slot((Container)playerInventory, m, 8 + m * 18, 142));
        }
        this.addDataSlots(data);
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack copy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            copy = stack.copy();
            int size = this.slots.size();
            if (index == 3) {
                if (!this.moveItemStackTo(stack, 4, size, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(stack, copy);
            } else if (index != 2 && index != 1 && index != 0 ? (this.canSmelt(stack) != -1 ? !this.moveItemStackTo(stack, 0, 2, false) : (this.isFuel(stack) ? !this.moveItemStackTo(stack, 2, 3, false) : (index >= 4 && index < 31 ? !this.moveItemStackTo(stack, 31, size, false) : index >= 31 && index < size && !this.moveItemStackTo(stack, 4, 31, false)))) : !this.moveItemStackTo(stack, 4, size, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack.getCount() == copy.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack);
        }
        return copy;
    }

    public float getBurnProgress() {
        int i = this.data.get(2);
        int j = this.data.get(3);
        return j != 0 && i != 0 ? Mth.clamp((float)((float)i / (float)j), (float)0.0f, (float)1.0f) : 0.0f;
    }

    public float getLitProgress() {
        int i = this.data.get(1);
        if (i == 0) {
            i = 200;
        }
        return Mth.clamp((float)((float)this.data.get(0) / (float)i), (float)0.0f, (float)1.0f);
    }

    public boolean isLit() {
        return this.data.get(0) > 0;
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    protected int canSmelt(ItemStack stack) {
        for (Ingredient ingredient : aIngredients) {
            if (!ingredient.test(stack)) continue;
            return 0;
        }
        for (Ingredient ingredient : bIngredients) {
            if (!ingredient.test(stack)) continue;
            return 1;
        }
        return -1;
    }

    protected boolean isFuel(ItemStack stack) {
        return stack.getBurnTime(RecipeType.SMELTING) > 0;
    }
}

