/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.melter;

import com.mojang.serialization.MapCodec;
import dev.lopyluna.slag.content.blocks.melter.MelterBE;
import dev.lopyluna.slag.content.blocks.smart.SmartBlock;
import dev.lopyluna.slag.content.utils.ShapeUtils;
import dev.lopyluna.slag.register.AllBETypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class MelterBlock
extends SmartBlock<MelterBE> {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final MapCodec<MelterBlock> CODEC = MelterBlock.simpleCodec(MelterBlock::new);

    public MelterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getOpposite());
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof MelterBE) {
                MelterBE be = (MelterBE)blockEntity;
                player.openMenu((MenuProvider)be);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack stack = itemEntity.getItem();
            if (stack.isEmpty()) {
                return;
            }
            IItemHandler cap = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)Direction.DOWN);
            if (cap == null) {
                return;
            }
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)cap, (ItemStack)stack, (boolean)false);
            System.out.println("Tried insert: in= " + String.valueOf(stack) + " out= " + String.valueOf(remainder));
            if (remainder.getCount() == stack.getCount()) {
                return;
            }
            if (remainder.isEmpty()) {
                entity.discard();
            } else {
                itemEntity.setItem(remainder);
            }
        }
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShaper wall;
        ShapeUtils.Builder shaper = ShapeUtils.shape(0.0, 0.0, 0.0, 16.0, 4.0, 16.0);
        ShapeUtils.Builder newShape = shaper.add((wall = ShapeUtils.shape(0.0, 0.0, 0.0, 16.0, 16.0, 3.0).forHorizontal(Direction.NORTH)).get(Direction.NORTH)).add(wall.get(Direction.SOUTH)).add(wall.get(Direction.EAST)).add(wall.get(Direction.WEST));
        if (newShape != null) {
            shaper = newShape;
        }
        return shaper.build();
    }

    @Override
    public Class<MelterBE> getBlockEntityClass() {
        return MelterBE.class;
    }

    @Override
    public BlockEntityType<? extends MelterBE> getBlockEntityType() {
        return (BlockEntityType)AllBETypes.MELTER.get();
    }

    @NotNull
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return super.rotate(pState, pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof MelterBE)) return 0;
        MelterBE be = (MelterBE)blockEntity;
        if (be.itemInventory == null) return 0;
        int n = AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be.itemInventory);
        return n;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

