/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.melter;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.lopyluna.slag.client.ClientUtils;
import dev.lopyluna.slag.content.blocks.melter.MelterBE;
import dev.lopyluna.slag.content.blocks.melter.MelterBlock;
import dev.lopyluna.slag.content.blocks.melter.MelterInventory;
import dev.lopyluna.slag.content.blocks.multiblock.LerpedFloat;
import dev.lopyluna.slag.content.blocks.multiblock.renderer.SafeBlockEntityRenderer;
import dev.lopyluna.slag.content.blocks.smart.SmartFluidTank;
import dev.lopyluna.slag.content.utils.ShapeUtils;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.platform.NeoForgeCatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Random;

public class MelterRenderer
extends SafeBlockEntityRenderer<MelterBE> {
    public MelterRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(MelterBE be, float pt, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = be.getBlockState();
        Direction facing = state.hasProperty((Property)MelterBlock.FACING) ? (Direction)state.getValue((Property)MelterBlock.FACING) : Direction.NORTH;
        this.renderFluid(be, facing, pt, ms, buffer, light, overlay);
        float level = 0.0f;
        LerpedFloat fluidLevel = be.getFluidLevel();
        level = fluidLevel == null ? 0.0f : fluidLevel.getValue(pt);
        MelterInventory inv = be.getItemInventory();
        if (inv == null || inv.isEmpty()) {
            return;
        }
        ItemStack item = inv.getFirstItem();
        if (item.isEmpty()) {
            return;
        }
        float angle = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel()) * 0.1f;
        Item ite = item.getItem();
        for (int i = 0; Math.min(item.getMaxStackSize(), (int)Mth.clamp((float)(11.0f * ((float)item.getCount() / (float)item.getMaxStackSize())), (float)0.0f, (float)11.0f) + 1) > i; ++i) {
            Random r = new Random((long)(i + ite.hashCode() + be.getBlockPos().hashCode()));
            float offset = (float)i / 11.0f;
            Vec3 vecOff = i == 0 ? Vec3.ZERO : new Vec3((double)r.nextFloat() * 0.2 - 0.1, 0.0, (double)r.nextFloat() * 0.2 - 0.1);
            float angleOffset = i == 0 ? 0.0f : 360.0f * offset * 1.5f;
            ms.pushPose();
            ms.translate(0.5, 0.3 + (double)(offset * 0.5f) + (double)(level * 0.26f), 0.5);
            ms.translate(vecOff.x, 0.0, vecOff.z);
            ms.mulPose(Axis.YP.rotationDegrees(AngleHelper.horizontalAngle((Direction)facing)));
            ms.mulPose(Axis.YP.rotationDegrees(angleOffset));
            ms.mulPose(Axis.XP.rotationDegrees(90.0f));
            ms.mulPose(Axis.ZP.rotationDegrees(AngleHelper.wrapAngle180((float)(angle * (0.75f + r.nextFloat() * 0.25f)))));
            ms.translate(0.0f, -0.1f, 0.0f);
            this.renderItem(ms, buffer, light, overlay, item);
            ms.popPose();
        }
    }

    public void renderFluid(MelterBE be, Direction facing, float pt, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        LerpedFloat fluidLevel = be.getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        SmartFluidTank tank = be.tankInventory;
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        ms.pushPose();
        ClientUtils.renderFluidShape(fluidStack, ShapeUtils.shape(4.0, 7.0, -0.01, 6.0, 10.0, 0.99).add(7.0, 7.0, -0.01, 9.0, 10.0, 0.99).add(10.0, 7.0, -0.01, 12.0, 10.0, 0.99).forHorizontal(Direction.NORTH).get(facing), buffer, ms, light, true, true);
        ms.popPose();
        float capHeight = 0.0625f;
        float tankHullWidth = 0.0140625f;
        float minPuddleHeight = 0.25f;
        float totalHeight = 1.0f - 2.0f * capHeight - minPuddleHeight;
        float level = fluidLevel.getValue(pt) + 0.00140625f;
        if (level < 1.0f / (512.0f * totalHeight)) {
            return;
        }
        float clampedLevel = Mth.clamp((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        float xMax = tankHullWidth + 1.0f - 2.0f * tankHullWidth;
        float yMin = totalHeight + capHeight + minPuddleHeight - clampedLevel;
        float yMax = yMin + clampedLevel;
        float zMax = tankHullWidth + 1.0f - 2.0f * tankHullWidth;
        ms.pushPose();
        ms.translate(0.0f, clampedLevel - totalHeight, 0.0f);
        NeoForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)fluidStack, tankHullWidth, yMin, tankHullWidth, xMax, yMax, zMax, buffer, ms, light, false, true);
        ms.popPose();
    }

    protected void renderItem(PoseStack ms, MultiBufferSource buffer, int light, int overlay, ItemStack stack) {
        Minecraft mc = Minecraft.getInstance();
        mc.getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, light, overlay, ms, buffer, (Level)mc.level, 0);
    }
}

