/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.melter;

import dev.lopyluna.slag.content.blocks.crucible.AlloyingRecipe;
import dev.lopyluna.slag.register.AllRecipes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class MeltingRecipe
implements Recipe<SingleRecipeInput> {
    protected final RecipeType<?> type;
    protected final String group;
    private final List<ItemStack> inputs;
    private final Ingredient input;
    private final List<FluidStack> outputs;

    public MeltingRecipe(String group, List<ItemStack> inputs, Ingredient input, List<FluidStack> outputs) {
        this((RecipeType)AllRecipes.MELTING.get(), group, inputs, input, outputs);
    }

    public MeltingRecipe(RecipeType<?> type, String group, List<ItemStack> inputs, Ingredient input, List<FluidStack> outputs) {
        this.type = type;
        this.group = group;
        this.inputs = inputs;
        this.input = input;
        this.outputs = outputs;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        if (input.item().isEmpty()) {
            return false;
        }
        if (!this.inputs.isEmpty()) {
            for (ItemStack stack : this.inputs) {
                if (stack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)input.item())) continue;
                return true;
            }
        }
        return this.input.test(input.item());
    }

    public List<FluidStack> assembleWithFluid(AlloyingRecipe.AlloyRecipeInput alloyRecipeInput, HolderLookup.Provider provider) {
        return this.getResultFluids(provider);
    }

    public List<FluidStack> getResultFluids(HolderLookup.Provider provider) {
        ArrayList<FluidStack> list = new ArrayList<FluidStack>();
        int i = 0;
        for (FluidStack stack : this.outputs) {
            if (i > 12) break;
            list.add(stack.copy());
            ++i;
        }
        return list;
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    public List<ItemStack> getInputs() {
        return this.inputs;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public List<FluidStack> getOutputs() {
        return this.outputs;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    @NotNull
    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AllRecipes.MELTING_SER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return this.type;
    }

    public static interface Factory {
        public MeltingRecipe create(String var1, List<ItemStack> var2, Ingredient var3, List<FluidStack> var4);
    }

    public static class Type
    implements RecipeType<MeltingRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }

        public String toString() {
            return "melting";
        }
    }
}

