/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.melter.client;

import com.mojang.datafixers.util.Pair;
import dev.lopyluna.slag.content.AllUtils;
import dev.lopyluna.slag.content.blocks.melter.MelterBE;
import dev.lopyluna.slag.register.AllMenuTypes;
import dev.lopyluna.slag.register.AllTags;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class MelterMenu
extends AbstractContainerMenu {
    private final Container inventory;
    protected final Player player;
    protected final Level level;
    protected final BlockPos pos;

    public MelterMenu(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(windowId, playerInventory, (Container)new SimpleContainer(1), buf.readBlockPos());
    }

    public MelterMenu(int syncId, Inventory playerInventory, Container inventory, BlockPos pos) {
        super((MenuType)AllMenuTypes.MELTER.get(), syncId);
        int m;
        MelterMenu.checkContainerSize((Container)inventory, (int)1);
        this.inventory = inventory;
        this.player = playerInventory.player;
        this.level = this.player.level();
        this.pos = pos;
        this.addSlot(new Slot(inventory, 0, 56, 17));
        for (m = 0; m < 3; ++m) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + m * 9 + 9, 8 + l * 18, 84 + m * 18));
            }
        }
        for (m = 0; m < 9; ++m) {
            this.addSlot(new Slot((Container)playerInventory, m, 8 + m * 18, 142));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack copy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            copy = stack.copy();
            int size = this.slots.size();
            if (index != 0) {
                if (!this.moveItemStackTo(stack, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
                if (index >= 1 && index < 28 ? !this.moveItemStackTo(stack, 28, size, false) : index >= 28 && index < size && !this.moveItemStackTo(stack, 1, 28, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (!this.moveItemStackTo(stack, 1, size, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack.getCount() == copy.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack);
        }
        return copy;
    }

    public MelterBE getBE() {
        MelterBE be;
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        return blockEntity instanceof MelterBE ? (be = (MelterBE)blockEntity) : null;
    }

    public Pair<Float, Boolean> isMelting() {
        MelterBE be = this.getBE();
        if (be == null) {
            return Pair.of((Object)Float.valueOf(0.0f), (Object)false);
        }
        float progress = be.meltingTarget == 0 ? -1.0f : (float)be.meltingProgress / (float)be.meltingTarget;
        return Pair.of((Object)Float.valueOf(progress), (Object)be.melting);
    }

    public BlockState getBelowState() {
        return this.level.getBlockState(this.pos.below());
    }

    public Pair<ItemStack, Boolean> getBelowData() {
        boolean bool = false;
        BlockState below = this.getBelowState();
        if (below.is(AllTags.MELTER_HEATER)) {
            bool = true;
        }
        ItemStack stack = AllUtils.getStackFromBlock(below.getBlock(), false);
        return Pair.of((Object)stack, (Object)bool);
    }

    public FluidStack getFluid() {
        MelterBE be = this.getBE();
        if (be == null) {
            return FluidStack.EMPTY;
        }
        return be.getTankInventory().getFluid();
    }

    public int getCapacity() {
        MelterBE be = this.getBE();
        if (be == null) {
            return 0;
        }
        return be.getTankInventory().getCapacity();
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }
}

