/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.multiblock.connectivity;

import dev.lopyluna.slag.content.blocks.multiblock.IMultiBlockEntityContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;

public class ConnectivityHandler {
    public static <T extends BlockEntity> void formMulti(T be) {
        SearchCache cache = new SearchCache();
        ArrayList<T> frontier = new ArrayList<T>();
        frontier.add(be);
        ConnectivityHandler.formMulti(be.getType(), (BlockGetter)be.getLevel(), cache, frontier);
    }

    private static <T extends BlockEntity> void formMulti(BlockEntityType<?> type, BlockGetter level, SearchCache<T> cache, List<T> frontier) {
        PriorityQueue<Pair<Integer, T>> creationQueue = ConnectivityHandler.makeCreationQueue();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        Direction.Axis mainAxis = ((IMultiBlockEntityContainer)((BlockEntity)frontier.getFirst())).getMainConnectionAxis();
        int minX = mainAxis == Direction.Axis.Y ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int minY = mainAxis != Direction.Axis.Y ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int minZ = mainAxis == Direction.Axis.Y ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        for (BlockEntity be : frontier) {
            BlockPos pos = be.getBlockPos();
            minX = Math.min(pos.getX(), minX);
            minY = Math.min(pos.getY(), minY);
            minZ = Math.min(pos.getZ(), minZ);
        }
        if (mainAxis == Direction.Axis.Y) {
            minX -= ((IMultiBlockEntityContainer)((BlockEntity)frontier.getFirst())).getMaxWidth();
        }
        if (mainAxis != Direction.Axis.Y) {
            minY -= ((IMultiBlockEntityContainer)((BlockEntity)frontier.getFirst())).getMaxWidth();
        }
        if (mainAxis == Direction.Axis.Y) {
            minZ -= ((IMultiBlockEntityContainer)((BlockEntity)frontier.getFirst())).getMaxWidth();
        }
        while (!frontier.isEmpty()) {
            BlockEntity part = (BlockEntity)frontier.removeFirst();
            BlockPos partPos = part.getBlockPos();
            if (visited.contains(partPos)) continue;
            visited.add(partPos);
            int amount = ConnectivityHandler.tryToFormNewMulti(part, cache, true);
            if (amount > 1) {
                creationQueue.add(Pair.of((Object)amount, (Object)part));
            }
            for (Direction.Axis axis : Direction.Axis.values()) {
                T nextBe;
                Direction dir = Direction.get((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis);
                BlockPos next = partPos.relative(dir);
                if (next.getX() <= minX || next.getY() <= minY || next.getZ() <= minZ || visited.contains(next) || (nextBe = ConnectivityHandler.partAt(type, level, next)) == null || nextBe.isRemoved()) continue;
                frontier.add(nextBe);
            }
        }
        visited.clear();
        while (!creationQueue.isEmpty()) {
            Pair<Integer, T> next = creationQueue.poll();
            BlockEntity toCreate = (BlockEntity)next.getValue();
            if (visited.contains(toCreate.getBlockPos())) continue;
            visited.add(toCreate.getBlockPos());
            ConnectivityHandler.tryToFormNewMulti(toCreate, cache, false);
        }
    }

    private static <T extends BlockEntity> int tryToFormNewMulti(T be, SearchCache<T> cache, boolean simulate) {
        if (!((IMultiBlockEntityContainer)be).isController()) {
            return 0;
        }
        int bestWX = 1;
        int bestWZ = 1;
        int bestAmount = -1;
        int maxX = ((IMultiBlockEntityContainer)be).getMaxWidthX();
        int maxZ = ((IMultiBlockEntityContainer)be).getMaxWidthZ();
        for (int wX = 1; wX <= maxX; ++wX) {
            for (int wZ = 1; wZ <= maxZ; ++wZ) {
                int amount;
                if (wX == 1 && wZ > 1 || wX > 1 && wZ == 1 || (amount = ConnectivityHandler.tryToFormNewMultiOfWidth(be, wX, wZ, cache, true)) < bestAmount) continue;
                bestWX = wX;
                bestWZ = wZ;
                bestAmount = amount;
            }
        }
        if (!simulate) {
            IMultiBlockEntityContainer.FluidMulti ifluid;
            IMultiBlockEntityContainer.Fluid ifluid2;
            int curWX = ((IMultiBlockEntityContainer)be).getWidthX();
            int curWZ = ((IMultiBlockEntityContainer)be).getWidthZ();
            if (curWX == bestWX && curWZ == bestWZ && curWX * curWZ * ((IMultiBlockEntityContainer)be).getHeight() == bestAmount) {
                return bestAmount;
            }
            ConnectivityHandler.splitMultiAndInvalidate(be, cache, false);
            if (be instanceof IMultiBlockEntityContainer.Fluid && (ifluid2 = (IMultiBlockEntityContainer.Fluid)be).hasTank()) {
                ifluid2.setTankSize(0, bestAmount);
            }
            if (be instanceof IMultiBlockEntityContainer.FluidMulti && (ifluid = (IMultiBlockEntityContainer.FluidMulti)be).hasTank()) {
                ifluid.setTankSize(bestAmount);
            }
            ConnectivityHandler.tryToFormNewMultiOfWidth(be, bestWX, bestWZ, cache, false);
            ((IMultiBlockEntityContainer)be).preventConnectivityUpdate();
            ((IMultiBlockEntityContainer)be).setWidthX(bestWX);
            ((IMultiBlockEntityContainer)be).setWidthZ(bestWZ);
            ((IMultiBlockEntityContainer)be).setHeight(bestAmount / (bestWX * bestWZ));
            ((IMultiBlockEntityContainer)be).notifyMultiUpdated();
        }
        return bestAmount;
    }

    private static <T extends BlockEntity> int tryToFormNewMultiOfWidth(T be, int widthX, int widthZ, SearchCache<T> cache, boolean simulate) {
        IMultiBlockEntityContainer ifluid;
        if (widthX == 1 && widthZ > 1 || widthX > 1 && widthZ == 1) {
            return 0;
        }
        int amount = 0;
        int height = 0;
        BlockEntityType type = be.getType();
        Level level = be.getLevel();
        if (level == null) {
            return 0;
        }
        BlockPos origin = be.getBlockPos();
        IFluidTank beTank = null;
        FluidStack fluid = FluidStack.EMPTY;
        if (be instanceof IMultiBlockEntityContainer.Fluid && (ifluid = (IMultiBlockEntityContainer.Fluid)be).hasTank()) {
            beTank = ifluid.getTank(0);
            fluid = beTank.getFluid();
        }
        if (be instanceof IMultiBlockEntityContainer.FluidMulti && (ifluid = (IMultiBlockEntityContainer.FluidMulti)be).hasTank()) {
            beTank = ifluid.getTank();
        }
        Direction.Axis axis = ((IMultiBlockEntityContainer)be).getMainConnectionAxis();
        int maxLen = ((IMultiBlockEntityContainer)be).getMaxLength(axis, Math.max(widthX, widthZ));
        block10: for (int yOffset = 0; yOffset < maxLen; ++yOffset) {
            for (int xOffset = 0; xOffset < widthX; ++xOffset) {
                for (int zOffset = 0; zOffset < widthZ; ++zOffset) {
                    IMultiBlockEntityContainer.Fluid ifluidCon;
                    BlockPos conPos;
                    Direction.Axis conAxis;
                    BlockPos pos = switch (axis) {
                        default -> throw new MatchException(null, null);
                        case Direction.Axis.X -> origin.offset(yOffset, xOffset, zOffset);
                        case Direction.Axis.Y -> origin.offset(xOffset, yOffset, zOffset);
                        case Direction.Axis.Z -> origin.offset(xOffset, zOffset, yOffset);
                    };
                    Optional<T> part = cache.getOrCache(type, (BlockGetter)level, pos);
                    if (part.isEmpty()) break block10;
                    BlockEntity controller = (BlockEntity)part.get();
                    int otherWidthX = ((IMultiBlockEntityContainer)controller).getWidthX();
                    int otherWidthZ = ((IMultiBlockEntityContainer)controller).getWidthZ();
                    if (otherWidthX > widthX || otherWidthZ > widthZ || otherWidthX == widthX && otherWidthZ == widthZ && ((IMultiBlockEntityContainer)controller).getHeight() == maxLen || axis != (conAxis = ((IMultiBlockEntityContainer)controller).getMainConnectionAxis()) || !(conPos = controller.getBlockPos()).equals((Object)origin) && (axis != Direction.Axis.Y ? axis == Direction.Axis.Z && conPos.getX() < origin.getX() || conPos.getY() < origin.getY() || axis == Direction.Axis.X && conPos.getZ() < origin.getZ() || axis == Direction.Axis.Z && conPos.getX() + otherWidthX > origin.getX() + widthX || conPos.getY() + height > origin.getY() + ((IMultiBlockEntityContainer)be).getMaxLength(axis, Math.max(widthZ, widthX)) || axis == Direction.Axis.X && conPos.getZ() + otherWidthZ > origin.getZ() + widthX : conPos.getX() < origin.getX() || conPos.getZ() < origin.getZ() || conPos.getX() + otherWidthX > origin.getX() + widthX || conPos.getZ() + otherWidthZ > origin.getZ() + widthZ)) break block10;
                    if (!(controller instanceof IMultiBlockEntityContainer.Fluid) || !(ifluidCon = (IMultiBlockEntityContainer.Fluid)controller).hasTank()) continue;
                    FluidStack otherFluid = ifluidCon.getFluid(0);
                    if (!fluid.isEmpty() && !otherFluid.isEmpty() && !FluidStack.isSameFluidSameComponents((FluidStack)fluid, (FluidStack)otherFluid)) break block10;
                }
            }
            amount += widthX * widthZ;
            ++height;
        }
        if (simulate) {
            return amount;
        }
        Object extraData = ((IMultiBlockEntityContainer)be).getExtraData();
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < widthX; ++xOffset) {
                for (int zOffset = 0; zOffset < widthZ; ++zOffset) {
                    IMultiBlockEntityContainer.FluidMulti ifluidPart;
                    IMultiBlockEntityContainer.Fluid ifluidPart2;
                    BlockPos pos = switch (axis) {
                        default -> throw new MatchException(null, null);
                        case Direction.Axis.X -> origin.offset(yOffset, xOffset, zOffset);
                        case Direction.Axis.Y -> origin.offset(xOffset, yOffset, zOffset);
                        case Direction.Axis.Z -> origin.offset(xOffset, zOffset, yOffset);
                    };
                    T part = ConnectivityHandler.partAt(type, (BlockGetter)level, pos);
                    if (part == null || part == be) continue;
                    extraData = ((IMultiBlockEntityContainer)be).modifyExtraData(extraData);
                    if (part instanceof IMultiBlockEntityContainer.Fluid && (ifluidPart2 = (IMultiBlockEntityContainer.Fluid)part).hasTank()) {
                        IMultiBlockEntityContainer.Fluid ifluidBE;
                        tankAt = ifluidPart2.getTank(0);
                        FluidStack fluidAt = tankAt.getFluid();
                        if (!fluidAt.isEmpty() && be instanceof IMultiBlockEntityContainer.Fluid && (ifluidBE = (IMultiBlockEntityContainer.Fluid)be).hasTank() && beTank != null) {
                            beTank.fill(fluidAt, IFluidHandler.FluidAction.EXECUTE);
                        }
                        tankAt.drain(tankAt.getCapacity(), IFluidHandler.FluidAction.EXECUTE);
                    } else if (part instanceof IMultiBlockEntityContainer.FluidMulti && (ifluidPart = (IMultiBlockEntityContainer.FluidMulti)part).hasTank()) {
                        tankAt = ifluidPart.getTank();
                        for (FluidStack fluidAt : ifluidPart.getFluids()) {
                            IMultiBlockEntityContainer.FluidMulti ifluidBE;
                            if (fluidAt.isEmpty() || !(be instanceof IMultiBlockEntityContainer.FluidMulti) || !(ifluidBE = (IMultiBlockEntityContainer.FluidMulti)be).hasTank() || beTank == null) continue;
                            beTank.fill(fluidAt, IFluidHandler.FluidAction.EXECUTE);
                        }
                        while (!tankAt.getFluid().isEmpty()) {
                            tankAt.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                    ConnectivityHandler.splitMultiAndInvalidate(part, cache, false);
                    ((IMultiBlockEntityContainer)part).setController(origin);
                    ((IMultiBlockEntityContainer)part).preventConnectivityUpdate();
                    cache.put(pos, be);
                    ((IMultiBlockEntityContainer)part).setHeight(height);
                    ((IMultiBlockEntityContainer)part).setWidthX(widthX);
                    ((IMultiBlockEntityContainer)part).setWidthZ(widthZ);
                    ((IMultiBlockEntityContainer)part).notifyMultiUpdated();
                }
            }
        }
        ((IMultiBlockEntityContainer)be).setExtraData(extraData);
        ((IMultiBlockEntityContainer)be).notifyMultiUpdated();
        return amount;
    }

    public static <T extends BlockEntity> void splitMulti(T be) {
        ConnectivityHandler.splitMultiAndInvalidate(be, null, false);
    }

    private static <T extends BlockEntity> void splitMultiAndInvalidate(T be, @Nullable SearchCache<T> cache, boolean tryReconnect) {
        IMultiBlockEntityContainer.FluidMulti fm;
        IMultiBlockEntityContainer.Fluid f;
        IMultiBlockEntityContainer.Inventory inv;
        IMultiBlockEntityContainer.FluidMulti cr;
        IMultiBlockEntityContainer.Fluid ifluidBE;
        Level level = be.getLevel();
        if (level == null) {
            return;
        }
        if ((be = ((IMultiBlockEntityContainer)be).getControllerBE()) == null) {
            return;
        }
        int height = ((IMultiBlockEntityContainer)be).getHeight();
        int widthX = ((IMultiBlockEntityContainer)be).getWidthX();
        int widthZ = ((IMultiBlockEntityContainer)be).getWidthZ();
        if (widthX == 1 && widthZ == 1 && height == 1) {
            return;
        }
        BlockPos origin = be.getBlockPos();
        ArrayList<T> frontier = new ArrayList<T>();
        Direction.Axis axis = ((IMultiBlockEntityContainer)be).getMainConnectionAxis();
        FluidStack toDistribute = FluidStack.EMPTY;
        ArrayList<FluidStack> toDistributeList = new ArrayList<FluidStack>();
        int maxCapacity = 0;
        boolean controllerIsMulti = false;
        IFluidTank controllerTank = null;
        if (be instanceof IMultiBlockEntityContainer.Fluid && (ifluidBE = (IMultiBlockEntityContainer.Fluid)be).hasTank()) {
            toDistribute = ifluidBE.getFluid(0);
            maxCapacity = ifluidBE.getTankSize(0);
            if (!toDistribute.isEmpty() && !be.isRemoved()) {
                toDistribute.shrink(maxCapacity);
            }
            ifluidBE.setTankSize(0, 1);
        }
        if (be instanceof IMultiBlockEntityContainer.FluidMulti && (cr = (IMultiBlockEntityContainer.FluidMulti)be).hasTank()) {
            controllerIsMulti = true;
            maxCapacity = cr.getTankSize();
            controllerTank = cr.getTank();
            toDistributeList = new ArrayList<FluidStack>(cr.getFluids());
            while (!controllerTank.getFluid().isEmpty()) {
                controllerTank.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < widthX; ++xOffset) {
                for (int zOffset = 0; zOffset < widthZ; ++zOffset) {
                    BlockPos pos = switch (axis) {
                        default -> throw new MatchException(null, null);
                        case Direction.Axis.X -> origin.offset(yOffset, xOffset, zOffset);
                        case Direction.Axis.Y -> origin.offset(xOffset, yOffset, zOffset);
                        case Direction.Axis.Z -> origin.offset(xOffset, zOffset, yOffset);
                    };
                    T partAt = ConnectivityHandler.partAt(be.getType(), (BlockGetter)level, pos);
                    if (partAt == null || !((IMultiBlockEntityContainer)partAt).getController().equals((Object)origin)) continue;
                    Object controllerBE = ((IMultiBlockEntityContainer)partAt).getControllerBE();
                    ((IMultiBlockEntityContainer)partAt).setExtraData(controllerBE == null ? null : ((IMultiBlockEntityContainer)controllerBE).getExtraData());
                    ((IMultiBlockEntityContainer)partAt).removeController(true);
                    if (partAt != be) {
                        if (controllerIsMulti && !toDistributeList.isEmpty()) {
                            Object cr2;
                            IFluidTank tank;
                            IFluidTank iFluidTank = tank = partAt instanceof IMultiBlockEntityContainer.FluidMulti && (cr2 = (IMultiBlockEntityContainer.FluidMulti)partAt).hasTank() ? cr2.getTank() : null;
                            if (tank != null) {
                                cr2 = ConnectivityHandler.shrinkFluids(toDistributeList, maxCapacity).iterator();
                                while (cr2.hasNext()) {
                                    FluidStack distribute = (FluidStack)cr2.next();
                                    tank.fill(distribute, IFluidHandler.FluidAction.EXECUTE);
                                }
                            }
                        } else if (!toDistribute.isEmpty()) {
                            IFluidTank iFluidTank;
                            FluidStack copy = toDistribute.copy();
                            if (partAt instanceof IMultiBlockEntityContainer.Fluid) {
                                IMultiBlockEntityContainer.Fluid ifluidPart = (IMultiBlockEntityContainer.Fluid)partAt;
                                iFluidTank = ifluidPart.getTank(0);
                            } else {
                                iFluidTank = null;
                            }
                            IFluidTank tank = iFluidTank;
                            int split = Math.min(maxCapacity, toDistribute.getAmount());
                            copy.setAmount(split);
                            toDistribute.shrink(split);
                            if (tank != null) {
                                tank.fill(copy, IFluidHandler.FluidAction.EXECUTE);
                            }
                        }
                    }
                    if (tryReconnect) {
                        frontier.add(partAt);
                        ((IMultiBlockEntityContainer)partAt).preventConnectivityUpdate();
                    }
                    if (cache == null) continue;
                    cache.put(pos, partAt);
                }
            }
        }
        if (controllerIsMulti) {
            if (controllerTank != null) {
                for (FluidStack distribute : ConnectivityHandler.shrinkFluids(toDistributeList, maxCapacity)) {
                    controllerTank.fill(distribute, IFluidHandler.FluidAction.EXECUTE);
                }
            }
            if (be instanceof IMultiBlockEntityContainer.FluidMulti) {
                IMultiBlockEntityContainer.FluidMulti cr3 = (IMultiBlockEntityContainer.FluidMulti)be;
                cr3.setTankSize(1);
            }
        }
        assert (be.getLevel() != null);
        if (be instanceof IMultiBlockEntityContainer.Inventory && (inv = (IMultiBlockEntityContainer.Inventory)be).hasInventory()) {
            be.getLevel().invalidateCapabilities(be.getBlockPos());
        }
        if (be instanceof IMultiBlockEntityContainer.Fluid && (f = (IMultiBlockEntityContainer.Fluid)be).hasTank() || be instanceof IMultiBlockEntityContainer.FluidMulti && (fm = (IMultiBlockEntityContainer.FluidMulti)be).hasTank()) {
            be.getLevel().invalidateCapabilities(be.getBlockPos());
        }
        if (tryReconnect) {
            ConnectivityHandler.formMulti(be.getType(), (BlockGetter)level, cache == null ? new SearchCache<T>() : cache, frontier);
        }
    }

    public static List<FluidStack> shrinkFluids(List<FluidStack> fluids, int capacity) {
        ArrayList<FluidStack> shrink = new ArrayList<FluidStack>();
        if (capacity <= 0 || fluids == null || fluids.isEmpty()) {
            return shrink;
        }
        int left = capacity;
        int i = 0;
        while (i < fluids.size() && left > 0) {
            FluidStack s = fluids.get(i);
            if (s == null || s.isEmpty()) {
                fluids.remove(i);
                continue;
            }
            int amt = s.getAmount();
            if (amt <= left) {
                shrink.add(s.copy());
                left -= amt;
                fluids.remove(i);
                continue;
            }
            FluidStack part = s.copy();
            part.setAmount(left);
            shrink.add(part);
            s.setAmount(amt - left);
            left = 0;
        }
        return shrink;
    }

    private static <T extends BlockEntity> PriorityQueue<Pair<Integer, T>> makeCreationQueue() {
        return new PriorityQueue<Pair<Integer, T>>((one, two) -> (Integer)two.getKey() - (Integer)one.getKey());
    }

    @Nullable
    public static <T extends BlockEntity> T partAt(BlockEntityType<?> type, BlockGetter level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be != null && be.getType() == type && !be.isRemoved()) {
            return ConnectivityHandler.checked(be);
        }
        return null;
    }

    public static <T extends BlockEntity> boolean isConnected(BlockGetter level, BlockPos pos, BlockPos other) {
        T one = ConnectivityHandler.checked(level.getBlockEntity(pos));
        T two = ConnectivityHandler.checked(level.getBlockEntity(other));
        if (one == null || two == null) {
            return false;
        }
        return ((IMultiBlockEntityContainer)one).getController().equals((Object)((IMultiBlockEntityContainer)two).getController());
    }

    @Nullable
    private static <T extends BlockEntity> T checked(BlockEntity be) {
        if (be instanceof IMultiBlockEntityContainer) {
            return (T)be;
        }
        return null;
    }

    private static class SearchCache<T extends BlockEntity> {
        Map<BlockPos, Optional<T>> controllerMap = new HashMap<BlockPos, Optional<T>>();

        void put(BlockPos pos, T target) {
            this.controllerMap.put(pos, Optional.of(target));
        }

        void putEmpty(BlockPos pos) {
            this.controllerMap.put(pos, Optional.empty());
        }

        boolean hasVisited(BlockPos pos) {
            return this.controllerMap.containsKey(pos);
        }

        Optional<T> getOrCache(BlockEntityType<?> type, BlockGetter level, BlockPos pos) {
            if (this.hasVisited(pos)) {
                return this.controllerMap.get(pos);
            }
            Object partAt = ConnectivityHandler.partAt(type, level, pos);
            if (partAt == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            Object controller = ConnectivityHandler.checked(level.getBlockEntity(((IMultiBlockEntityContainer)partAt).getController()));
            if (controller == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            this.put(pos, controller);
            return Optional.of(controller);
        }
    }
}

