/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.smart;

import dev.lopyluna.slag.content.blocks.smart.BehaviourType;
import dev.lopyluna.slag.content.blocks.smart.BlockEntityBehaviour;
import dev.lopyluna.slag.content.blocks.smart.CachedRenderBBBlockEntity;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.createmod.ponder.api.VirtualBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class SmartBlockEntity
extends CachedRenderBBBlockEntity
implements VirtualBlockEntity {
    private final Map<BehaviourType<?>, BlockEntityBehaviour> behaviours = new Reference2ObjectArrayMap();
    private boolean initialized = false;
    private boolean firstNbtRead = true;
    protected int lazyTickRate;
    protected int lazyTickCounter;
    private boolean chunkUnloaded;
    private boolean virtualMode;

    public SmartBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        ArrayList<BlockEntityBehaviour> list = new ArrayList<BlockEntityBehaviour>();
        this.addBehaviours(list);
        list.forEach(b -> this.behaviours.put(b.getType(), (BlockEntityBehaviour)b));
    }

    public abstract void addBehaviours(List<BlockEntityBehaviour> var1);

    public void addBehavioursDeferred(List<BlockEntityBehaviour> behaviours) {
    }

    public void initialize() {
        if (this.firstNbtRead) {
            this.firstNbtRead = false;
        }
        this.forEachBehaviour(BlockEntityBehaviour::initialize);
        this.lazyTick();
    }

    public void tick() {
        if (!this.initialized && this.hasLevel()) {
            this.initialize();
            this.initialized = true;
        }
        if (this.lazyTickCounter-- <= 0) {
            this.lazyTickCounter = this.lazyTickRate;
            this.lazyTick();
        }
        this.forEachBehaviour(BlockEntityBehaviour::tick);
    }

    public void lazyTick() {
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.saveAdditional(tag, registries);
        this.forEachBehaviour(tb -> tb.write(tag, registries, clientPacket));
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        if (this.firstNbtRead) {
            this.firstNbtRead = false;
            ArrayList<BlockEntityBehaviour> list = new ArrayList<BlockEntityBehaviour>();
            this.addBehavioursDeferred(list);
            list.forEach(b -> this.behaviours.put(b.getType(), (BlockEntityBehaviour)b));
        }
        super.loadAdditional(tag, registries);
        this.forEachBehaviour(tb -> tb.read(tag, registries, clientPacket));
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        this.read(tag, registries, false);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.chunkUnloaded = true;
    }

    public final void setRemoved() {
        super.setRemoved();
        if (!this.chunkUnloaded) {
            this.remove();
        }
        this.invalidate();
    }

    public void invalidate() {
        this.forEachBehaviour(BlockEntityBehaviour::unload);
    }

    public void remove() {
    }

    public void destroy() {
        this.forEachBehaviour(BlockEntityBehaviour::destroy);
    }

    public final void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        this.write(tag, registries, false);
    }

    @Override
    public final void readClient(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        this.read(tag, registries, true);
    }

    @Override
    public final CompoundTag writeClient(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        this.write(tag, registries, true);
        return tag;
    }

    public <T extends BlockEntityBehaviour> T getBehaviour(BehaviourType<T> type) {
        return (T)this.behaviours.get(type);
    }

    public void forEachBehaviour(Consumer<BlockEntityBehaviour> action) {
        this.getAllBehaviours().forEach(action);
    }

    public Collection<BlockEntityBehaviour> getAllBehaviours() {
        return this.behaviours.values();
    }

    public void attachBehaviourLate(BlockEntityBehaviour behaviour) {
        this.behaviours.put(behaviour.getType(), behaviour);
        behaviour.blockEntity = this;
        behaviour.initialize();
    }

    public void removeBehaviour(BehaviourType<?> type) {
        BlockEntityBehaviour remove = this.behaviours.remove(type);
        if (remove != null) {
            remove.unload();
        }
    }

    public void setLazyTickRate(int slowTickRate) {
        this.lazyTickRate = slowTickRate;
        this.lazyTickCounter = slowTickRate;
    }

    public boolean isChunkUnloaded() {
        return this.chunkUnloaded;
    }

    public void markVirtual() {
        this.virtualMode = true;
    }

    public boolean isVirtual() {
        return this.virtualMode;
    }

    public void refreshBlockState() {
        if (this.getLevel() == null) {
            return;
        }
        this.setBlockState(this.getLevel().getBlockState(this.getBlockPos()));
    }
}

