/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.table;

import dev.lopyluna.slag.register.AllRecipes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class TableCastingRecipe
implements Recipe<SingleRecipeFluidInput> {
    protected final RecipeType<?> type;
    protected final String group;
    private final TagKey<Item> castType;
    private final FluidStack input;
    private final ItemStack output;

    public TableCastingRecipe(String group, TagKey<Item> castType, FluidStack inputs, ItemStack output) {
        this((RecipeType)AllRecipes.TABLE_CASTING.get(), group, castType, inputs, output);
    }

    public TableCastingRecipe(RecipeType<?> type, String group, TagKey<Item> castType, FluidStack inputs, ItemStack output) {
        this.type = type;
        this.group = group;
        this.castType = castType;
        this.input = inputs;
        this.output = output;
    }

    public TagKey<Item> getCastType() {
        return this.castType;
    }

    public FluidStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public boolean matches(SingleRecipeFluidInput fluidInput, Level level) {
        return this.input.is(fluidInput.fluid);
    }

    public boolean hasEnoughFluid(FluidStack stack) {
        return this.input.is(stack.getFluid()) && stack.getAmount() >= this.input.getAmount();
    }

    @NotNull
    public ItemStack assemble(SingleRecipeFluidInput singleRecipeFluidInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AllRecipes.TABLE_CASTING_SER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return this.type;
    }

    public record SingleRecipeFluidInput(Fluid fluid) implements RecipeInput
    {
        public boolean isEmpty() {
            return this.fluid == null || this.fluid == Fluids.EMPTY;
        }

        @Override
        public int hashCode() {
            return this.fluid.hashCode();
        }

        @NotNull
        public ItemStack getItem(int i) {
            return ItemStack.EMPTY;
        }

        public int size() {
            return 1;
        }
    }

    public static interface Factory {
        public TableCastingRecipe create(String var1, TagKey<Item> var2, FluidStack var3, ItemStack var4);
    }

    public static class Type
    implements RecipeType<TableCastingRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }

        public String toString() {
            return "table_casting";
        }
    }
}

