/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.table;

import dev.lopyluna.slag.content.blocks.DirtyInventory;
import dev.lopyluna.slag.content.blocks.table.TableBE;
import dev.lopyluna.slag.content.items.dynamic_mold.DynamicMoldItem;
import dev.lopyluna.slag.register.AllDataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class TableInventory
extends DirtyInventory<TableBE> {
    TableBE be;

    public TableInventory(int slots, TableBE be) {
        super(slots, be, 1, false);
        this.be = be;
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!(stack.getItem() instanceof DynamicMoldItem && stack.has(AllDataComponents.CAST_TYPE) && this.getFirstMoldItem().isEmpty())) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Override
    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.getItem() instanceof DynamicMoldItem) {
            return ItemStack.EMPTY;
        }
        return super.extractItem(slot, amount, simulate);
    }

    @Override
    public void setItem(int slot, @NotNull ItemStack stack) {
        int i = slot;
        if (this.getItem(slot).getItem() instanceof DynamicMoldItem) {
            i = 1;
        }
        this.stacks.set(i, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
        this.setChanged();
        this.onContentsChanged(i);
    }

    public ItemStack getFirstMoldItem() {
        for (ItemStack s : this.stacks) {
            if (s.isEmpty() || !(s.getItem() instanceof DynamicMoldItem)) continue;
            return s;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack getFirstItem() {
        for (ItemStack s : this.stacks) {
            if (s.isEmpty() || s.getItem() instanceof DynamicMoldItem) continue;
            return s;
        }
        return ItemStack.EMPTY;
    }

    public void setChanged() {
        this.be.sendDataImmediately();
    }

    @Override
    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.be.sendDataImmediately();
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this.be, (Player)player);
    }
}

