/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.blocks.table;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.lopyluna.slag.client.AlphaBufferSource;
import dev.lopyluna.slag.client.SolidBufferSource;
import dev.lopyluna.slag.content.blocks.melter.MelterBlock;
import dev.lopyluna.slag.content.blocks.multiblock.LerpedFloat;
import dev.lopyluna.slag.content.blocks.multiblock.renderer.SafeBlockEntityRenderer;
import dev.lopyluna.slag.content.blocks.table.TableBE;
import dev.lopyluna.slag.content.blocks.table.TableTank;
import dev.lopyluna.slag.register.AllDataComponents;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.platform.NeoForgeCatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;

public class TableRenderer
extends SafeBlockEntityRenderer<TableBE> {
    Minecraft mc = Minecraft.getInstance();

    public TableRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(TableBE be, float pt, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        this.renderFluid(be, pt, ms, buffer, light);
        ItemRenderer itemRenderer = this.mc.getItemRenderer();
        this.renderResultItem(be, itemRenderer, ms, buffer, light, overlay);
        this.renderMoldItem(be, itemRenderer, ms, buffer, light, overlay);
    }

    public void renderMoldItem(TableBE be, ItemRenderer ir, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        ItemStack stack;
        ItemStack itemStack = stack = be.moldItemStack.isEmpty() ? be.getMold() : be.moldItemStack;
        if (stack.isEmpty()) {
            return;
        }
        ItemStack base = stack.getItem().getDefaultInstance();
        ItemStack cutout = stack.copy();
        base.set(AllDataComponents.CUTOUT, (Object)Unit.INSTANCE);
        cutout.set(AllDataComponents.CUTOUT, (Object)Unit.INSTANCE);
        ms.pushPose();
        ms.translate(0.5f, 0.625f, 0.5f);
        ms.mulPose(Axis.XP.rotationDegrees(90.0f));
        BlockState state = be.getBlockState();
        Direction facing = state.hasProperty((Property)MelterBlock.FACING) ? (Direction)state.getValue((Property)MelterBlock.FACING) : Direction.NORTH;
        ms.mulPose(Axis.ZP.rotationDegrees(AngleHelper.horizontalAngle((Direction)(facing.getAxis() == Direction.Axis.Z ? facing.getOpposite() : facing))));
        ms.scale(0.75625f, 0.75f, 0.75625f);
        ms.pushPose();
        ms.translate(0.0f, 0.0f, 0.1f);
        ir.renderStatic(base, ItemDisplayContext.FIXED, light, overlay, ms, buffer, (Level)this.mc.level, 0);
        ms.popPose();
        ms.pushPose();
        ms.scale(1.0f, 1.0f, 2.6f);
        ms.translate(0.0f, 0.0f, -0.002f);
        ir.renderStatic(cutout, ItemDisplayContext.FIXED, light, overlay, ms, buffer, (Level)this.mc.level, 0);
        ms.popPose();
        ms.popPose();
    }

    public void renderResultItem(TableBE be, ItemRenderer ir, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        boolean preview;
        ItemStack stack = be.resultItemStack.isEmpty() ? be.getStack() : be.resultItemStack;
        boolean bl = preview = !be.resultItemStack.isEmpty() && be.getStack().isEmpty();
        if (stack.isEmpty()) {
            return;
        }
        ms.pushPose();
        ms.translate(0.5f, 0.672f, 0.5f);
        ms.mulPose(Axis.XP.rotationDegrees(90.0f));
        BlockState state = be.getBlockState();
        Direction facing = state.hasProperty((Property)MelterBlock.FACING) ? (Direction)state.getValue((Property)MelterBlock.FACING) : Direction.NORTH;
        ms.mulPose(Axis.ZP.rotationDegrees(AngleHelper.horizontalAngle((Direction)(facing.getAxis() == Direction.Axis.Z ? facing.getOpposite() : facing))));
        ms.scale(0.75625f, 0.75f, 0.75625f);
        float cooling = !preview ? 1.0f : (be.coolingTarget == 0 ? 0.0f : Mth.clamp((float)((float)be.coolingProgress / (float)be.coolingTarget - 0.2f), (float)0.0f, (float)1.0f));
        ir.renderStatic(stack, ItemDisplayContext.FIXED, light, overlay, ms, (MultiBufferSource)new AlphaBufferSource(buffer, cooling), (Level)this.mc.level, 0);
        ms.popPose();
    }

    public void renderFluid(TableBE be, float pt, PoseStack ms, MultiBufferSource buffer, int light) {
        LerpedFloat fluidLevel = be.getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        TableTank tank = be.tankInventory;
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        float capHeight = 0.3125f;
        float tankHullWidth = 0.0140625f;
        float minPuddleHeight = 0.25f;
        float totalHeight = 1.0f - 2.0f * capHeight - minPuddleHeight;
        float level = fluidLevel.getValue(pt) + 0.00140625f;
        if (level < 1.0f / (512.0f * totalHeight)) {
            return;
        }
        float clampedLevel = Mth.clamp((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        float xMax = tankHullWidth + 1.0f - 2.0f * tankHullWidth;
        float yMin = totalHeight + capHeight + minPuddleHeight - clampedLevel;
        float yMax = yMin + clampedLevel;
        float zMax = tankHullWidth + 1.0f - 2.0f * tankHullWidth;
        ms.pushPose();
        ms.translate(0.0f, clampedLevel - totalHeight, 0.0f);
        NeoForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)fluidStack, tankHullWidth, yMin, tankHullWidth, xMax, yMax, zMax, new SolidBufferSource(buffer).getBuffer(RenderType.SOLID), ms, light, false, true);
        ms.popPose();
    }
}

