/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.datagen;

import dev.lopyluna.slag.content.types.MaterialType;
import dev.lopyluna.slag.register.AllItems;
import dev.lopyluna.slag.register.AllRegistries;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import org.jetbrains.annotations.NotNull;

public class MaterialDatagen
extends DatapackBuiltinEntriesProvider {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(AllRegistries.MATERIAL_TYPE_REGISTRY_KEY, b -> {
        for (MaterialType material : AllItems.MATERIAL_TYPES) {
            MaterialDatagen.registerMaterial((BootstrapContext<MaterialType>)b, material);
        }
    });

    private static void registerMaterial(BootstrapContext<MaterialType> bootstrap, MaterialType material) {
        ResourceKey key = ResourceKey.create(AllRegistries.MATERIAL_TYPE_REGISTRY_KEY, (ResourceLocation)material.id);
        bootstrap.register(key, (Object)material);
    }

    public MaterialDatagen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, BUILDER, Set.of("slag"));
    }

    @NotNull
    public String getName() {
        return "Slag Material Datagen";
    }
}

