/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.datagen;

import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.content.blocks.melter.MeltingRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class MeltingRecipeBuilder
implements RecipeBuilder {
    private final List<Fluid> result;
    private final List<FluidStack> stackResult;
    private final List<ItemStack> inputStacks;
    private final Ingredient input;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;
    private final MeltingRecipe.Factory factory;

    private MeltingRecipeBuilder(Fluid result, int count, Ingredient input) {
        this(new FluidStack(result, count), input);
    }

    private MeltingRecipeBuilder(Fluid result, int count, List<ItemStack> inputStacks) {
        this(new FluidStack(result, count), inputStacks);
    }

    private MeltingRecipeBuilder(FluidStack result, Ingredient input) {
        this(new ArrayList<FluidStack>(List.of(result)), input);
    }

    private MeltingRecipeBuilder(FluidStack result, List<ItemStack> inputStacks) {
        this(new ArrayList<FluidStack>(List.of(result)), inputStacks);
    }

    private MeltingRecipeBuilder(List<Fluid> result, List<Integer> resultCount, Ingredient input) {
        this(result.stream().map(fluid -> new FluidStack(fluid, ((Integer)resultCount.get(result.indexOf(fluid))).intValue())).toList(), input);
    }

    private MeltingRecipeBuilder(List<Fluid> result, List<Integer> resultCount, List<ItemStack> inputStacks) {
        this(result.stream().map(fluid -> new FluidStack(fluid, ((Integer)resultCount.get(result.indexOf(fluid))).intValue())).toList(), inputStacks);
    }

    private MeltingRecipeBuilder(List<FluidStack> result, Ingredient input) {
        this.result = result.stream().map(FluidStack::getFluid).toList();
        this.stackResult = result;
        this.inputStacks = new ArrayList<ItemStack>();
        this.input = input;
        this.factory = MeltingRecipe::new;
    }

    private MeltingRecipeBuilder(List<FluidStack> result, List<ItemStack> inputStacks) {
        this.result = result.stream().map(FluidStack::getFluid).toList();
        this.stackResult = result;
        this.inputStacks = inputStacks;
        this.input = Ingredient.EMPTY;
        this.factory = MeltingRecipe::new;
    }

    @NotNull
    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public RecipeBuilder group(@Nullable String name) {
        this.group = name;
        return this;
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation loc) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(loc));
        }
        Advancement.Builder builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)loc)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)loc)).requirements(AdvancementRequirements.Strategy.OR);
        Objects.requireNonNull(builder);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        MeltingRecipe recipe = this.factory.create(Objects.requireNonNullElse(this.group, ""), this.inputStacks, this.input, this.stackResult);
        recipeOutput.accept(loc, (Recipe)recipe, builder.build(loc.withPrefix("recipes/misc/")));
    }

    @NotNull
    public Item getResult() {
        return Items.AIR;
    }

    public List<Fluid> getResultFluid() {
        return this.result;
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, MeltingRecipeBuilder.getDefaultRecipeId(this.getResultFluid().getFirst()));
    }

    public void save(RecipeOutput recipeOutput, String id) {
        ResourceLocation loc = MeltingRecipeBuilder.getDefaultRecipeId(this.getResultFluid().getFirst());
        ResourceLocation parse = ResourceLocation.parse((String)id);
        if (parse.equals((Object)loc)) {
            throw new IllegalStateException("Recipe " + id + " should remove its 'save' argument as it is equal to default one");
        }
        this.save(recipeOutput, parse);
    }

    static ResourceLocation getDefaultRecipeId(Fluid fluid) {
        return BuiltInRegistries.FLUID.getKey((Object)fluid);
    }

    public static MeltingRecipeBuilder create(Fluid result, int mb, Ingredient ingredient) {
        return new MeltingRecipeBuilder(result, mb, ingredient);
    }

    public static MeltingRecipeBuilder create(FluidStack result, Ingredient ingredient) {
        return new MeltingRecipeBuilder(result, ingredient);
    }

    public static MeltingRecipeBuilder create(Fluid result, int mb, ItemStack item) {
        return new MeltingRecipeBuilder(result, mb, new ArrayList<ItemStack>(List.of(item)));
    }

    public static MeltingRecipeBuilder create(FluidStack result, ItemStack item) {
        return new MeltingRecipeBuilder(result, new ArrayList<ItemStack>(List.of(item)));
    }

    public static MeltingRecipeBuilder create(Fluid result, int mb, List<ItemStack> items) {
        return new MeltingRecipeBuilder(result, mb, items);
    }

    public static MeltingRecipeBuilder create(FluidStack result, List<ItemStack> items) {
        return new MeltingRecipeBuilder(result, items);
    }

    public static MeltingRecipeBuilder create(List<Fluid> result, List<Integer> mb, Ingredient ingredient) {
        return new MeltingRecipeBuilder(result, mb, ingredient);
    }

    public static MeltingRecipeBuilder create(List<Fluid> result, List<Integer> mb, List<ItemStack> items) {
        return new MeltingRecipeBuilder(result, mb, items);
    }

    public static MeltingRecipeBuilder create(List<FluidStack> result, Ingredient ingredient) {
        return new MeltingRecipeBuilder(result, ingredient);
    }

    public static MeltingRecipeBuilder create(List<FluidStack> result, TagKey<Item> item) {
        return new MeltingRecipeBuilder(result, Ingredient.of(item));
    }

    public static MeltingRecipeBuilder create(List<FluidStack> result, List<ItemStack> items) {
        return new MeltingRecipeBuilder(result, items);
    }

    public static MeltingRecipeBuilder create(List<FluidStack> result, ItemStack item) {
        return new MeltingRecipeBuilder(result, new ArrayList<ItemStack>(List.of(item)));
    }

    public static MeltingRecipeBuilder create(List<FluidStack> result, ItemLike item) {
        return new MeltingRecipeBuilder(result, new ArrayList<ItemStack>(List.of(item.asItem().getDefaultInstance())));
    }

    public static MeltingRecipeBuilder create(List<FluidStack> result, Item item) {
        return new MeltingRecipeBuilder(result, new ArrayList<ItemStack>(List.of(item.getDefaultInstance())));
    }

    public static MeltingRecipeBuilder create(Fluid result, int mb, ItemStack ... item) {
        return new MeltingRecipeBuilder(result, mb, new ArrayList<ItemStack>(Arrays.asList(item)));
    }

    public static MeltingRecipeBuilder create(FluidStack result, ItemStack ... item) {
        return new MeltingRecipeBuilder(result, new ArrayList<ItemStack>(Arrays.asList(item)));
    }

    public static MeltingRecipeBuilder create(Fluid result, int mb, TagKey<Item> tag) {
        return new MeltingRecipeBuilder(result, mb, Ingredient.of(tag));
    }

    public static MeltingRecipeBuilder create(FluidStack result, TagKey<Item> tag) {
        return new MeltingRecipeBuilder(result, Ingredient.of(tag));
    }

    public static MeltingRecipeBuilder create(Fluid result, int mb, ItemLike item) {
        return new MeltingRecipeBuilder(result, mb, Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public static MeltingRecipeBuilder create(FluidStack result, ItemLike item) {
        return new MeltingRecipeBuilder(result, Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public static void create(RegistrateRecipeProvider p, String name, Fluid fluid, int mb, TagKey<Item> tag) {
        MeltingRecipeBuilder.create(fluid, mb, tag).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(tag)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name));
    }

    public static void create(RegistrateRecipeProvider p, String name, FluidStack fluid, TagKey<Item> tag) {
        MeltingRecipeBuilder.create(fluid, tag).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(tag)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name));
    }

    public static void create(RegistrateRecipeProvider p, String name, Fluid fluid, int mb, ItemLike item) {
        MeltingRecipeBuilder.create(fluid, mb, item).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has((ItemLike)item)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name));
    }

    public static void create(RegistrateRecipeProvider p, String name, FluidStack fluid, ItemLike item) {
        MeltingRecipeBuilder.create(fluid, item).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has((ItemLike)item)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name));
    }

    public static void create(RegistrateRecipeProvider p, Fluid fluid, int mb, Item item) {
        String name = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        MeltingRecipeBuilder.create(fluid, mb, (ItemLike)item).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has((ItemLike)item)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name));
    }

    public static void create(RegistrateRecipeProvider p, FluidStack fluid, Item item) {
        String name = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        MeltingRecipeBuilder.create(fluid, (ItemLike)item).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has((ItemLike)item)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name));
    }

    public static void create(RegistrateRecipeProvider p, List<FluidStack> fluid, TagKey<Item> tag) {
        String name = tag.location().getPath();
        MeltingRecipeBuilder.create(fluid, tag).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(tag)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name));
    }

    public static void create(RegistrateRecipeProvider p, List<FluidStack> fluid, Item item) {
        String name = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        MeltingRecipeBuilder.create(fluid, item).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has((ItemLike)item)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name));
    }

    public static void oreMeltableGem(RegistrateRecipeProvider p, String name, Fluid fluid, @Nullable TagKey<Item> blocks, @Nullable TagKey<Item> material, @Nullable TagKey<Item> nuggets) {
        if (blocks != null) {
            MeltingRecipeBuilder.create(fluid, 792, blocks).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(blocks)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name + "_blocks"));
        }
        if (material != null) {
            MeltingRecipeBuilder.create(fluid, 108, material).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(material)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name + "_materials"));
        }
        if (nuggets != null) {
            MeltingRecipeBuilder.create(fluid, 18, nuggets).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(nuggets)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name + "_nuggets"));
        }
    }

    public static void oreMeltable(RegistrateRecipeProvider p, String name, Fluid fluid, @Nullable TagKey<Item> blocks, @Nullable TagKey<Item> material, @Nullable TagKey<Item> nuggets) {
        if (blocks != null) {
            MeltingRecipeBuilder.create(fluid, 864, blocks).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(blocks)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name + "_blocks"));
        }
        if (material != null) {
            MeltingRecipeBuilder.create(fluid, 96, material).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(material)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name + "_materials"));
        }
        if (nuggets != null) {
            MeltingRecipeBuilder.create(fluid, 8, nuggets).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(nuggets)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name + "_nuggets"));
        }
    }

    public static void ingotMeltable(RegistrateRecipeProvider p, String name, Fluid fluid, @Nullable TagKey<Item> blocks, @Nullable TagKey<Item> ingots, @Nullable TagKey<Item> nuggets) {
        if (blocks != null) {
            MeltingRecipeBuilder.create(fluid, 648, blocks).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(blocks)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name + "_blocks"));
        }
        if (ingots != null) {
            MeltingRecipeBuilder.create(fluid, 72, ingots).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(ingots)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name + "_ingots"));
        }
        if (nuggets != null) {
            MeltingRecipeBuilder.create(fluid, 8, nuggets).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(nuggets)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name + "_nuggets"));
        }
    }

    public static void crystalMeltable(RegistrateRecipeProvider p, String name, Fluid fluid, @Nullable TagKey<Item> blocks, @Nullable TagKey<Item> crystals) {
        if (blocks != null) {
            MeltingRecipeBuilder.create(fluid, 288, blocks).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(blocks)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name + "_blocks"));
        }
        if (crystals != null) {
            MeltingRecipeBuilder.create(fluid, 72, crystals).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(crystals)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name + "_crystals"));
        }
    }

    public static void gemMeltable(RegistrateRecipeProvider p, String name, Fluid fluid, @Nullable TagKey<Item> blocks, @Nullable TagKey<Item> gems, @Nullable TagKey<Item> shards) {
        if (blocks != null) {
            MeltingRecipeBuilder.create(fluid, 648, blocks).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(blocks)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name + "_blocks"));
        }
        if (gems != null) {
            MeltingRecipeBuilder.create(fluid, 72, gems).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(gems)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name + "_gems"));
        }
        if (shards != null) {
            MeltingRecipeBuilder.create(fluid, 18, shards).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(shards)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name + "_shards"));
        }
    }

    public static void dustMeltable(RegistrateRecipeProvider p, String name, Fluid fluid, @Nullable TagKey<Item> blocks, @Nullable TagKey<Item> dusts) {
        if (blocks != null) {
            MeltingRecipeBuilder.create(fluid, 648, blocks).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(blocks)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name + "_blocks"));
        }
        if (dusts != null) {
            MeltingRecipeBuilder.create(fluid, 72, dusts).unlockedBy("has_meltable_" + name, RegistrateRecipeProvider.has(dusts)).save((RecipeOutput)p, SlagEmbers.loc("melting/" + name + "_dusts"));
        }
    }

    public static FluidStack fluid(Fluid fluid, int mb) {
        return new FluidStack(fluid, mb);
    }

    public static List<FluidStack> fluids(FluidStack ... fluids) {
        return new ArrayList<FluidStack>(List.of(fluids));
    }
}

