/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.datagen;

import dev.lopyluna.slag.content.types.ModularType;
import dev.lopyluna.slag.register.AllItems;
import dev.lopyluna.slag.register.AllRegistries;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import org.jetbrains.annotations.NotNull;

public class ModularDatagen
extends DatapackBuiltinEntriesProvider {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(AllRegistries.MODULAR_TYPE_REGISTRY_KEY, b -> {
        for (ModularType modular : AllItems.MODULAR_TYPES) {
            ModularDatagen.registerPart((BootstrapContext<ModularType>)b, modular);
        }
    });

    private static void registerPart(BootstrapContext<ModularType> bootstrap, ModularType part) {
        ResourceKey key = ResourceKey.create(AllRegistries.MODULAR_TYPE_REGISTRY_KEY, (ResourceLocation)part.id);
        bootstrap.register(key, (Object)part);
    }

    public ModularDatagen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, BUILDER, Set.of("slag"));
    }

    @NotNull
    public String getName() {
        return "Slag Modular Datagen";
    }
}

