/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.items.dynamic_mold;

import dev.lopyluna.slag.client.render.SimpleCustomRenderer;
import dev.lopyluna.slag.content.items.dynamic_mold.DynamicMoldRenderer;
import dev.lopyluna.slag.register.AllDataComponents;
import dev.lopyluna.slag.register.AllLangs;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class DynamicMoldItem
extends Item {
    public DynamicMoldItem(Item.Properties properties) {
        super(properties);
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        boolean hasType = stack.has(AllDataComponents.CAST_TYPE);
        boolean empty = other.isEmpty();
        if (action != ClickAction.SECONDARY || !slot.allowModification(player) || other.getItem() instanceof DynamicMoldItem) {
            return false;
        }
        if (!hasType && empty) {
            return false;
        }
        Level level = player.level();
        RandomSource random = level.getRandom();
        boolean b = true;
        if (empty) {
            stack.remove(AllDataComponents.CAST_TYPE);
            player.playSound(SoundEvents.DECORATED_POT_INSERT_FAIL, 0.8f, 0.8f + random.nextFloat() * 0.4f);
            player.playSound(SoundEvents.CRAFTER_CRAFT, 0.8f, 0.8f + random.nextFloat() * 0.4f);
            b = false;
        } else {
            TagKey type = (TagKey)stack.get(AllDataComponents.CAST_TYPE);
            for (TagKey tag : new ArrayList(other.getTags().toList())) {
                if (!tag.location().getPath().split("/")[0].equals("cast") || type != null && type.equals((Object)tag)) continue;
                stack.set(AllDataComponents.CAST_TYPE, (Object)tag);
                player.playSound(SoundEvents.DECORATED_POT_INSERT_FAIL, 0.8f, 0.8f + random.nextFloat() * 0.4f);
                player.playSound(SoundEvents.CRAFTER_CRAFT, 0.8f, 0.8f + random.nextFloat() * 0.4f);
                b = false;
                break;
            }
        }
        if (b) {
            player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), 0.8f, 0.8f + random.nextFloat() * 0.4f);
        }
        return true;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        InteractionResultHolder use = super.use(level, player, usedHand);
        if (!player.isShiftKeyDown()) {
            return use;
        }
        ItemStack stack = player.getItemInHand(usedHand);
        if (!stack.has(AllDataComponents.CAST_TYPE)) {
            return use;
        }
        stack.remove(AllDataComponents.CAST_TYPE);
        RandomSource random = level.getRandom();
        player.playSound(SoundEvents.DECORATED_POT_INSERT_FAIL, 0.8f, 0.8f + random.nextFloat() * 0.4f);
        player.playSound(SoundEvents.CRAFTER_CRAFT, 0.8f, 0.8f + random.nextFloat() * 0.4f);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, ctx, tooltip, flag);
        if (stack.has(AllDataComponents.CAST_TYPE)) {
            tooltip.add((Component)AllLangs.tr("clear_imprint").withStyle(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)AllLangs.tr("imprint").withStyle(ChatFormatting.GRAY));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(SimpleCustomRenderer.create(this, new DynamicMoldRenderer()));
    }
}

