/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.items.dynamic_part;

import com.tterrag.registrate.providers.RegistrateLangProvider;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.client.render.SimpleCustomRenderer;
import dev.lopyluna.slag.content.items.dynamic_part.DynamicPartRenderer;
import dev.lopyluna.slag.content.items.dynamic_part.IDynamicPart;
import dev.lopyluna.slag.content.types.MaterialType;
import dev.lopyluna.slag.content.types.PartType;
import dev.lopyluna.slag.register.AllDataComponents;
import dev.lopyluna.slag.register.AllDynamicTypes;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class DynamicPartItem
extends Item
implements IDynamicPart {
    public DynamicPartItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (this.getMaterialType(stack).isEmpty() || this.getPartType(stack).isEmpty()) {
            stack.setCount(0);
        }
    }

    @Override
    public Optional<MaterialType> getMaterialType(ItemStack stack) {
        return AllDynamicTypes.getMaterial((ResourceLocation)stack.get(AllDataComponents.MATERIAL_TYPE));
    }

    public void setMaterialType(ItemStack stack, MaterialType materialType) {
        stack.set(AllDataComponents.MATERIAL_TYPE, (Object)materialType.id);
    }

    @Override
    public Optional<PartType> getPartType(ItemStack stack) {
        return AllDynamicTypes.getPart((ResourceLocation)stack.get(AllDataComponents.PART_TYPE));
    }

    public void setPartType(ItemStack stack, PartType partType) {
        stack.set(AllDataComponents.PART_TYPE, (Object)partType.id);
    }

    @NotNull
    public String getDescriptionId(ItemStack stack) {
        MaterialType material = this.getMaterialType(stack).orElse(null);
        if (material == null) {
            return super.getDescriptionId(stack);
        }
        PartType part = this.getPartType(stack).orElse(null);
        if (part == null) {
            return super.getDescriptionId(stack);
        }
        ResourceLocation materialLoc = material.id;
        String mod = materialLoc.getNamespace();
        if (mod.isEmpty()) {
            return super.getDescriptionId(stack);
        }
        String matID = materialLoc.getPath();
        if (matID.isEmpty()) {
            return super.getDescriptionId(stack);
        }
        String partID = part.id.getPath();
        if (partID.isEmpty()) {
            return super.getDescriptionId(stack);
        }
        return Util.makeDescriptionId((String)"item", (ResourceLocation)SlagEmbers.loc(mod, matID + "_" + partID));
    }

    @NotNull
    public Component getName(ItemStack stack) {
        String id = this.getDescriptionId(stack);
        String name = id.split("\\.")[2];
        return Component.translatableWithFallback((String)id, (String)RegistrateLangProvider.toEnglishName((String)name));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(SimpleCustomRenderer.create(this, new DynamicPartRenderer()));
    }
}

