/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.items.dynamic_part;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.client.render.CustomRenderedItemModel;
import dev.lopyluna.slag.client.render.CustomRenderedItemModelRenderer;
import dev.lopyluna.slag.client.render.PartialItemModelRenderer;
import dev.lopyluna.slag.content.items.dynamic_part.IDynamicPart;
import dev.lopyluna.slag.content.types.MaterialType;
import dev.lopyluna.slag.content.types.PartType;
import dev.lopyluna.slag.register.AllDataComponents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
public class DynamicPartRenderer
extends CustomRenderedItemModelRenderer {
    @Override
    protected void render(ItemStack stack, ItemRenderer itemRenderer, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, MultiBufferSource buf, int light, int overlay) {
        ItemModelShaper shaper = itemRenderer.getItemModelShaper();
        ModelManager manager = shaper.getModelManager();
        renderer.render(DynamicPartRenderer.renderFallBack(stack, manager), light);
    }

    public static BakedModel renderFallBack(ItemStack stack, ModelManager manager) {
        BakedModel missing = manager.getMissingModel();
        Item item = stack.getItem();
        if (!(item instanceof IDynamicPart)) {
            return missing;
        }
        IDynamicPart dynamicPart = (IDynamicPart)item;
        boolean hasMat = stack.has(AllDataComponents.MATERIAL_TYPE);
        if (!hasMat) {
            return missing;
        }
        boolean hasPart = stack.has(AllDataComponents.PART_TYPE);
        if (!hasPart) {
            return missing;
        }
        MaterialType mat = dynamicPart.getMaterialType(stack).orElse(null);
        if (mat == null) {
            return missing;
        }
        PartType part = dynamicPart.getPartType(stack).orElse(null);
        if (part == null) {
            return missing;
        }
        ResourceLocation matLoc = mat.id;
        String matID = matLoc.getPath();
        String partID = part.id.getPath();
        String targetMod = matLoc.getNamespace();
        String target = "item/dynamic_parts/" + matID + "/" + partID;
        ResourceLocation built = (ResourceLocation)stack.get(AllDataComponents.BUILT);
        if (stack.has(AllDataComponents.BUILT) && built != null) {
            target = "item/modular/" + built.getPath() + "/" + matID + "/" + partID;
        }
        ModelResourceLocation modelLoc = ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc(targetMod, target));
        return manager.getModel(modelLoc);
    }
}

