/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.items.dynamic_part;

import com.mojang.datafixers.util.Pair;
import dev.lopyluna.slag.content.items.dynamic_part.IDynamicPart;
import dev.lopyluna.slag.content.items.modular.DataDynamicParts;
import dev.lopyluna.slag.content.types.MaterialType;
import dev.lopyluna.slag.register.AllDataComponents;
import dev.lopyluna.slag.register.AllLangs;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToDoubleBiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;

public interface IModularItem {
    default public List<Pair<ItemStack, IDynamicPart>> getDynamicParts(ItemStack pStack) {
        ArrayList<Pair<ItemStack, IDynamicPart>> parts = new ArrayList<Pair<ItemStack, IDynamicPart>>();
        DataDynamicParts dataParts = this.getParts(pStack);
        if (dataParts == null || dataParts.isEmpty()) {
            return parts;
        }
        List<ItemStack> copy = dataParts.itemsCopy();
        for (ItemStack stack : copy) {
            Item item = stack.getItem();
            if (!(item instanceof IDynamicPart)) continue;
            IDynamicPart part = (IDynamicPart)item;
            parts.add((Pair<ItemStack, IDynamicPart>)Pair.of((Object)stack, (Object)part));
        }
        return parts;
    }

    default public List<MaterialType> getMaterialTypes(DataDynamicParts parts) {
        ArrayList<MaterialType> types = new ArrayList<MaterialType>();
        for (ItemStack stack : parts.itemsCopy()) {
            IDynamicPart part;
            MaterialType type;
            Item item = stack.getItem();
            if (!(item instanceof IDynamicPart) || (type = (MaterialType)(part = (IDynamicPart)item).getMaterialType(stack).orElse(null)) == null || types.contains(type)) continue;
            types.add(type);
        }
        return types;
    }

    default public List<ItemStack> getNonDynamicParts(ItemStack pStack) {
        ArrayList<ItemStack> parts = new ArrayList<ItemStack>();
        DataDynamicParts dataParts = this.getParts(pStack);
        if (dataParts == null || dataParts.isEmpty()) {
            return parts;
        }
        for (ItemStack stack : dataParts.itemsCopy()) {
            if (stack.getItem() instanceof IDynamicPart) continue;
            parts.add(stack);
        }
        return parts;
    }

    default public DataDynamicParts getParts(ItemStack pStack) {
        return (DataDynamicParts)pStack.get(AllDataComponents.DYNAMIC_PARTS);
    }

    default public void setParts(ItemStack pStack, List<ItemStack> pStacks) {
        pStack.set(AllDataComponents.DYNAMIC_PARTS, (Object)new DataDynamicParts(pStacks));
    }

    default public float averageMod(ItemStack stack, ToDoubleBiFunction<ItemStack, IDynamicPart> getter) {
        List<Pair<ItemStack, IDynamicPart>> parts = this.getDynamicParts(stack);
        if (parts.isEmpty()) {
            return 0.0f;
        }
        ArrayList<Double> newParts = new ArrayList<Double>();
        for (Pair<ItemStack, IDynamicPart> p : parts) {
            double sumAdd = getter.applyAsDouble((ItemStack)p.getFirst(), (IDynamicPart)p.getSecond());
            if (sumAdd == 9.87654336E8 || sumAdd == -9.87654336E8) continue;
            newParts.add(sumAdd);
        }
        if (newParts.isEmpty()) {
            return 0.0f;
        }
        int size = newParts.size();
        double sum = 0.0;
        for (Double p : newParts) {
            sum += p.doubleValue();
        }
        return (float)((int)((float)(sum / (double)size) * 100.0f)) / 100.0f;
    }

    default public float averageModSize(ItemStack stack, ToDoubleBiFunction<ItemStack, IDynamicPart> getter) {
        List<Pair<ItemStack, IDynamicPart>> parts = this.getDynamicParts(stack);
        if (parts.isEmpty()) {
            return 0.0f;
        }
        ArrayList<Double> newParts = new ArrayList<Double>();
        for (Pair<ItemStack, IDynamicPart> p : parts) {
            double sumAdd = getter.applyAsDouble((ItemStack)p.getFirst(), (IDynamicPart)p.getSecond());
            if (sumAdd == 9.87654336E8 || sumAdd == -9.87654336E8) continue;
            newParts.add(sumAdd);
        }
        if (newParts.isEmpty()) {
            return 0.0f;
        }
        int size = newParts.size();
        double sum = 0.0;
        for (Double p : newParts) {
            sum += p * (double)((float)size * 0.25f + 0.75f);
        }
        return (float)((int)((float)(sum / (double)size) * 100.0f)) / 100.0f;
    }

    default public float getSpeed(ItemStack stack) {
        return (this.averageMod(stack, (s, p) -> p.getSpeed((ItemStack)s)) + this.averageMod(stack, (s, p) -> p.getSpeedPart((ItemStack)s))) * this.averageMod(stack, (s, p) -> 1.0);
    }

    default public float getAttackSpeed(ItemStack stack) {
        return this.averageMod(stack, (s, p) -> p.getSpeedMod((ItemStack)s));
    }

    default public float getDura(ItemStack stack) {
        return (this.averageModSize(stack, (s, p) -> p.getDura((ItemStack)s)) + this.averageModSize(stack, (s, p) -> p.getDuraPart((ItemStack)s))) * this.averageModSize(stack, (s, p) -> p.getDuraMod((ItemStack)s));
    }

    default public float getTier(ItemStack stack) {
        return (this.averageMod(stack, (s, p) -> p.getTier((ItemStack)s)) + this.averageMod(stack, (s, p) -> p.getTierPart((ItemStack)s))) * this.averageMod(stack, (s, p) -> p.getTierMod((ItemStack)s));
    }

    default public float getHammerTier(DataDynamicParts parts, ItemStack stack) {
        return this.getTier(stack);
    }

    default public float getSharp(ItemStack stack) {
        return (this.averageMod(stack, (s, p) -> p.getSharp((ItemStack)s)) + this.averageMod(stack, (s, p) -> p.getSharpPart((ItemStack)s))) * this.averageMod(stack, (s, p) -> p.getSharpMod((ItemStack)s));
    }

    default public float getKbRes(ItemStack stack) {
        return (this.averageMod(stack, (s, p) -> p.getKbRes((ItemStack)s)) + this.averageMod(stack, (s, p) -> p.getKbResPart((ItemStack)s))) * this.averageMod(stack, (s, p) -> p.getKbResMod((ItemStack)s));
    }

    default public float getDefense(ItemStack stack) {
        return (this.averageMod(stack, (s, p) -> p.getDefense((ItemStack)s)) + this.averageMod(stack, (s, p) -> p.getDefensePart((ItemStack)s))) * this.averageMod(stack, (s, p) -> p.getDefenseMod((ItemStack)s));
    }

    default public float getTough(ItemStack stack) {
        return (this.averageMod(stack, (s, p) -> p.getTough((ItemStack)s)) + this.averageMod(stack, (s, p) -> p.getToughPart((ItemStack)s))) * this.averageMod(stack, (s, p) -> p.getToughMod((ItemStack)s));
    }

    default public float getEnch(ItemStack stack) {
        return (this.averageMod(stack, (s, p) -> p.getEnch((ItemStack)s)) + this.averageMod(stack, (s, p) -> p.getEnchPart((ItemStack)s))) * this.averageMod(stack, (s, p) -> p.getEnchMod((ItemStack)s));
    }

    default public void appendHoverModularArmor(IModularItem item, ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        Level level = context.level();
        if (level instanceof ClientLevel) {
            ClientLevel level2 = (ClientLevel)level;
            DataDynamicParts parts = item.getParts(stack);
            if (parts != null && !parts.isEmpty()) {
                AllLangs.modularArmorStats(tooltip, parts, stack, item);
                AllLangs.modularParts(tooltip, parts.itemsCopy());
            } else {
                tooltip.add((Component)AllLangs.tr("modular_tool_waiting").withStyle(ChatFormatting.GRAY));
            }
        }
    }

    default public void appendHoverTextModularTool(IModularItem item, ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        Level level = context.level();
        if (level instanceof ClientLevel) {
            ClientLevel level2 = (ClientLevel)level;
            DataDynamicParts parts = item.getParts(stack);
            if (parts != null && !parts.isEmpty()) {
                List<ItemStack> toolParts = parts.itemsCopy();
                if (toolParts.isEmpty()) {
                    tooltip.add((Component)AllLangs.tr("modular_tool_waiting").withStyle(ChatFormatting.GRAY));
                    return;
                }
                AllLangs.modularToolStats(tooltip, parts, stack, item);
                AllLangs.modularParts(tooltip, toolParts);
            } else {
                tooltip.add((Component)AllLangs.tr("modular_tool_waiting").withStyle(ChatFormatting.GRAY));
            }
        }
    }

    default public void appendHoverTextModularBlueprint(IModularItem item, ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        Level level = context.level();
        if (level instanceof ClientLevel) {
            ClientLevel level2 = (ClientLevel)level;
            DataDynamicParts parts = item.getParts(stack);
            if (parts == null || parts.isEmpty()) {
                return;
            }
            LocalPlayer player = Minecraft.getInstance().player;
            float tier = item.getTier(stack);
            boolean f = true;
            if (player != null) {
                BlockState lookState = level2.getBlockState(Item.getPlayerPOVHitResult((Level)level2, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE).getBlockPos());
                int size = parts.size();
                if (size > 4) {
                    if (!lookState.is(BlockTags.ANVIL)) {
                        tooltip.add((Component)AllLangs.tr("modular_tool_anvil").withStyle(ChatFormatting.RED));
                        f = false;
                    }
                } else if (size > 3) {
                    if (!lookState.is(Blocks.SMITHING_TABLE) && !lookState.is(BlockTags.ANVIL)) {
                        tooltip.add((Component)AllLangs.tr("modular_tool_smithing_table").withStyle(ChatFormatting.RED));
                        f = false;
                    }
                } else if (!(lookState.is(Tags.Blocks.PLAYER_WORKSTATIONS_CRAFTING_TABLES) || lookState.is(Blocks.SMITHING_TABLE) || lookState.is(BlockTags.ANVIL))) {
                    tooltip.add((Component)AllLangs.tr("modular_tool_crafting_table").withStyle(ChatFormatting.RED));
                    f = false;
                }
            }
            if (f) {
                if (3.5f >= tier) {
                    tooltip.add((Component)AllLangs.tr("modular_tool_crafting_hammer_weak").withStyle(ChatFormatting.RED));
                } else {
                    tooltip.add((Component)AllLangs.trArgs("modular_tool_crafting_hammer", String.valueOf(tier)).withStyle(ChatFormatting.RED));
                }
            }
        }
    }
}

