/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.items.modular;

import com.mojang.serialization.Codec;
import dev.lopyluna.slag.content.items.dynamic_part.IDynamicPart;
import dev.lopyluna.slag.content.types.ModularType;
import dev.lopyluna.slag.register.AllDynamicTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class DataDynamicParts
implements TooltipComponent {
    public static final DataDynamicParts EMPTY = new DataDynamicParts(new ArrayList<ItemStack>());
    public static final Codec<DataDynamicParts> CODEC = ItemStack.CODEC.listOf().xmap(DataDynamicParts::new, parts -> parts.items);
    public static final StreamCodec<RegistryFriendlyByteBuf, DataDynamicParts> STREAM_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(DataDynamicParts::new, parts -> parts.items);
    public List<ItemStack> items;

    public DataDynamicParts(List<ItemStack> items) {
        this.items = items;
    }

    public ItemStack getItem(Item item) {
        for (ItemStack itemstack : this.items) {
            if (!itemstack.is(item)) continue;
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public boolean contains(Item item) {
        for (ItemStack itemstack : this.items) {
            if (!itemstack.is(item)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ItemStack stack) {
        for (ItemStack itemstack : this.items) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public boolean containsDynamicPartSegment(IDynamicPart part, ItemStack stack) {
        return this.containsDynamicPartSegment(part.getPartSegment(stack));
    }

    public boolean containsDynamicPartSegment(TagKey<Item> part) {
        for (ItemStack itemstack : this.items) {
            IDynamicPart dynamic;
            Item item = itemstack.getItem();
            if (!(item instanceof IDynamicPart) || !(dynamic = (IDynamicPart)item).getPartSegment(itemstack).equals(part)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAllDynamicPartSegments(List<TagKey<Item>> required) {
        if (required == null) {
            return false;
        }
        ArrayList<TagKey<Item>> have = new ArrayList<TagKey<Item>>();
        for (ItemStack s : this.items) {
            Item item = s.getItem();
            if (!(item instanceof IDynamicPart)) continue;
            IDynamicPart p = (IDynamicPart)item;
            TagKey<Item> seg = p.getPartSegment(s);
            if (seg == null) {
                return false;
            }
            have.add(seg);
        }
        return this.containsAll(have, required);
    }

    public boolean containsAll(List<TagKey<Item>> have, List<TagKey<Item>> need) {
        if (have == null || need == null) {
            return false;
        }
        for (TagKey<Item> n : need) {
            if (have.contains(n)) continue;
            return false;
        }
        for (TagKey<Item> h : have) {
            if (need.contains(h)) continue;
            return false;
        }
        return have.size() == need.size();
    }

    public ItemStack getItemUnsafe(int index) {
        return this.items.get(index);
    }

    public Stream<ItemStack> itemCopyStream() {
        return this.items.stream().map(ItemStack::copy);
    }

    public List<ItemStack> items() {
        return this.items;
    }

    public List<ItemStack> itemsCopy() {
        if (this.isEmpty()) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack stack : this.items) {
            items.add(stack.copy());
        }
        return items;
    }

    public List<ItemStack> getAllNonDynamicParts() {
        if (this.isEmpty()) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack stack : this.items) {
            if (stack.getItem() instanceof IDynamicPart) continue;
            items.add(stack.copy());
        }
        return items;
    }

    public List<ItemStack> getAllDynamicParts() {
        if (this.isEmpty()) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack stack : this.items) {
            if (!(stack.getItem() instanceof IDynamicPart)) continue;
            items.add(stack.copy());
        }
        return items;
    }

    public List<ItemStack> itemCopyRandom(Random random) {
        if (this.isEmpty()) {
            return new ArrayList<ItemStack>();
        }
        List<ItemStack> items = this.itemsCopy();
        if (random == null) {
            ItemStack stick = ItemStack.EMPTY;
            int i = 0;
            for (ItemStack stack : items) {
                if (stack.is(Items.STICK)) {
                    stick = stack;
                    items.remove(i);
                    break;
                }
                ++i;
            }
            if (!stick.isEmpty()) {
                items.addFirst(stick);
            }
            return items;
        }
        Collections.shuffle(items, random);
        ItemStack stick = ItemStack.EMPTY;
        int i = 0;
        for (ItemStack stack : items) {
            if (stack.is(Items.STICK)) {
                stick = stack;
                items.remove(i);
                break;
            }
            ++i;
        }
        if (!stick.isEmpty()) {
            items.addFirst(stick);
        }
        return items;
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items == null || this.items.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof DataDynamicParts)) return false;
        DataDynamicParts parts = (DataDynamicParts)other;
        if (!DataDynamicParts.itemMatches(this.items, parts.items)) return false;
        return true;
    }

    public static boolean itemMatches(List<ItemStack> list, List<ItemStack> other) {
        if (list.size() != other.size()) {
            return false;
        }
        for (ItemStack stack : list) {
            if (DataDynamicParts.containsSaidStack(other, stack)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsSaidStack(List<ItemStack> list, ItemStack stack) {
        for (ItemStack s : list) {
            if (!DataDynamicParts.matches(s, stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(ItemStack stack, ItemStack other) {
        if (stack.getItem() != other.getItem()) {
            return false;
        }
        return stack.getCount() == other.getCount() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)other);
    }

    public int hashCode() {
        return ItemStack.hashStackList(this.items);
    }

    public String toString() {
        return "ToolParts" + String.valueOf(this.items);
    }

    public List<ItemStack> getPossibleStacks() {
        return this.getPossibleParts().stream().filter(o -> o instanceof ItemStack).map(o -> (ItemStack)o).toList();
    }

    public List<TagKey<Item>> getPossibleTags() {
        return this.getPossibleParts().stream().filter(o -> o instanceof TagKey).map(o -> (TagKey)o).toList();
    }

    public List<ItemStack> getPossibleStacks(List<Object> list) {
        return list.stream().filter(o -> o instanceof ItemStack).map(o -> (ItemStack)o).toList();
    }

    public List<TagKey<Item>> getPossibleTags(List<Object> list) {
        return list.stream().filter(o -> o instanceof TagKey).map(o -> (TagKey)o).toList();
    }

    public List<Object> getPossibleParts() {
        ArrayList<Object> result = new ArrayList<Object>();
        Collection<ModularType> modulars = AllDynamicTypes.getAllModulars();
        if (this.isEmpty()) {
            for (ModularType modular : modulars) {
                for (ItemStack itemStack : modular.finalSegmentStacks) {
                    if (this.containsStack(result, itemStack)) continue;
                    result.add(itemStack);
                }
                for (TagKey tagKey : modular.segments) {
                    if (this.containsTag(result, (TagKey<Item>)tagKey)) continue;
                    result.add(tagKey);
                }
            }
            return result;
        }
        for (ModularType modular : modulars) {
            List<Object> missingParts = this.getMissingParts(modular);
            if (missingParts == null) continue;
            for (Object part : missingParts) {
                if (this.contains(result, part)) continue;
                result.add(part);
            }
        }
        return result;
    }

    public List<Object> getPossiblePartCombinations(ModularType modular) {
        return this.getMissingParts(modular);
    }

    private List<Object> getMissingParts(ModularType modular) {
        ArrayList<Object> missing = new ArrayList<Object>();
        ArrayList<Object> matched = new ArrayList<Object>();
        for (ItemStack itemStack : this.items) {
            if (modular.contains(itemStack)) continue;
            return null;
        }
        for (ItemStack itemStack : modular.finalSegmentStacks) {
            if (this.containsInItems(itemStack)) {
                matched.add(itemStack);
                continue;
            }
            missing.add(itemStack);
        }
        for (TagKey tagKey : modular.segments) {
            if (this.containsTagInItems((TagKey<Item>)tagKey)) {
                matched.add(tagKey);
                continue;
            }
            missing.add(tagKey);
        }
        if (matched.isEmpty()) {
            return null;
        }
        return missing;
    }

    private boolean containsInItems(ItemStack stack) {
        for (ItemStack item : this.items) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)stack) || item.getCount() != stack.getCount()) continue;
            return true;
        }
        return false;
    }

    private boolean containsTagInItems(TagKey<Item> tag) {
        for (ItemStack item : this.items) {
            IDynamicPart part;
            Item item2 = item.getItem();
            if (!(item2 instanceof IDynamicPart) || !(part = (IDynamicPart)item2).getPartSegment(item).equals(tag)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(List<Object> stacks, Object o) {
        if (o instanceof ItemStack) {
            ItemStack stack = (ItemStack)o;
            return this.containsStack(stacks, stack);
        }
        if (o instanceof TagKey) {
            TagKey tag = (TagKey)o;
            return this.containsTag(stacks, (TagKey<Item>)tag);
        }
        return false;
    }

    private boolean contains(List<Object> stacks, ItemStack stack) {
        if (this.containsTag(stacks, stack)) {
            return true;
        }
        return !(stack.getItem() instanceof IDynamicPart) && this.containsStack(stacks, stack);
    }

    private boolean containsStack(List<Object> stacks, ItemStack stack) {
        for (Object o : stacks) {
            ItemStack part;
            if (!(o instanceof ItemStack) || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)(part = (ItemStack)o)) || stack.getCount() != part.getCount()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean containsTag(List<Object> stacks, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof IDynamicPart) {
            IDynamicPart part = (IDynamicPart)item;
            TagKey<Item> tag = part.getPartSegment(stack);
            for (Object o : stacks) {
                ResourceKey registry;
                ResourceKey resourceKey;
                if (!(o instanceof TagKey)) continue;
                TagKey tagKey = (TagKey)o;
                try {
                    registry = resourceKey = tagKey.registry();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                resourceKey = tagKey.location();
                ResourceKey location = resourceKey;
                if (location != tag.location() || registry.location() != tag.registry().location()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean containsTag(List<Object> stacks, TagKey<Item> tag) {
        Iterator<Object> iterator = stacks.iterator();
        while (true) {
            ResourceKey registry;
            ResourceKey resourceKey;
            if (!iterator.hasNext()) {
                return false;
            }
            Object o = iterator.next();
            if (!(o instanceof TagKey)) continue;
            TagKey tagKey = (TagKey)o;
            try {
                registry = resourceKey = tagKey.registry();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            resourceKey = tagKey.location();
            ResourceKey location = resourceKey;
            if (location == tag.location() && registry.location() == tag.registry().location()) break;
        }
        return true;
    }
}

