/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.items.modular;

import com.mojang.datafixers.util.Pair;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.content.items.dynamic_part.IDynamicPart;
import dev.lopyluna.slag.content.items.modular.ModularToolsItem;
import dev.lopyluna.slag.content.types.MaterialType;
import dev.lopyluna.slag.content.types.ModularType;
import dev.lopyluna.slag.content.types.PartType;
import dev.lopyluna.slag.register.AllDataComponents;
import dev.lopyluna.slag.register.AllDynamicTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularEquipablesItem
extends ModularToolsItem {
    ResourceLocation HELMET_LOC = ResourceLocation.withDefaultNamespace((String)"armor.helmet");
    ResourceLocation CHESTPLATE_LOC = ResourceLocation.withDefaultNamespace((String)"armor.chestplate");
    ResourceLocation LEGGINGS_LOC = ResourceLocation.withDefaultNamespace((String)"armor.leggings");
    ResourceLocation BOOTS_LOC = ResourceLocation.withDefaultNamespace((String)"armor.boots");
    public static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){

        public ModularType getModularType(ItemStack stack) {
            ResourceLocation loc = (ResourceLocation)stack.get(AllDataComponents.MODULAR_TYPE);
            if (loc == null) {
                return null;
            }
            return AllDynamicTypes.getModular(loc).orElse(null);
        }

        public boolean hasModularType(ItemStack stack) {
            return stack.has(AllDataComponents.MODULAR_TYPE);
        }

        @NotNull
        protected ItemStack execute(@NotNull BlockSource source, @NotNull ItemStack stack) {
            if (!this.hasModularType(stack)) {
                return super.execute(source, stack);
            }
            ModularType modularType = this.getModularType(stack);
            if (modularType == null) {
                return super.execute(source, stack);
            }
            List<String> act = modularType.actions;
            if (act.isEmpty()) {
                return super.execute(source, stack);
            }
            if (!(act.contains("dispense") || act.contains("helmet") || act.contains("chestplate") || act.contains("leggings") || act.contains("boots"))) {
                return super.execute(source, stack);
            }
            return ArmorItem.dispenseArmor((BlockSource)source, (ItemStack)stack) ? stack : super.execute(source, stack);
        }
    };

    public ModularEquipablesItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)DISPENSE_ITEM_BEHAVIOR);
    }

    @Override
    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers(@NotNull ItemStack stack) {
        EquipmentSlotGroup slot;
        ResourceLocation loc;
        if (!this.hasModularType(stack) || !this.isArmor(stack)) {
            return super.getDefaultAttributeModifiers(stack);
        }
        ModularType modularType = this.getModularType(stack);
        if (modularType == null) {
            return super.getDefaultAttributeModifiers(stack);
        }
        List<String> act = modularType.actions;
        if (act.isEmpty()) {
            return super.getDefaultAttributeModifiers(stack);
        }
        Object object = act.contains("helmet") ? this.HELMET_LOC : (act.contains("chestplate") ? this.CHESTPLATE_LOC : (act.contains("leggings") ? this.LEGGINGS_LOC : (loc = act.contains("boots") ? this.BOOTS_LOC : null)));
        Object object2 = act.contains("helmet") ? EquipmentSlotGroup.HEAD : (act.contains("chestplate") ? EquipmentSlotGroup.CHEST : (act.contains("leggings") ? EquipmentSlotGroup.LEGS : (slot = act.contains("boots") ? EquipmentSlotGroup.FEET : null)));
        if (loc == null || slot == null) {
            return super.getDefaultAttributeModifiers(stack);
        }
        return super.getDefaultAttributeModifiers(stack).withModifierAdded(Attributes.ARMOR, new AttributeModifier(loc, (double)Math.round(this.getDefense(stack)), AttributeModifier.Operation.ADD_VALUE), slot).withModifierAdded(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(loc, (double)Math.round(this.getTough(stack)), AttributeModifier.Operation.ADD_VALUE), slot).withModifierAdded(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(loc, (double)this.getKbRes(stack), AttributeModifier.Operation.ADD_VALUE), slot);
    }

    public Holder<SoundEvent> getEquipSound(ItemStack stack) {
        List parts = this.getDynamicParts(stack);
        if (parts.isEmpty()) {
            return SoundEvents.ARMOR_EQUIP_DIAMOND;
        }
        Pair pair = (Pair)parts.getFirst();
        IDynamicPart part = (IDynamicPart)pair.getSecond();
        Optional<MaterialType> material = part.getMaterialType((ItemStack)pair.getFirst());
        if (material.isEmpty()) {
            return SoundEvents.ARMOR_EQUIP_DIAMOND;
        }
        MaterialType mat = material.get();
        return switch (mat.texture) {
            case "soft" -> SoundEvents.ARMOR_EQUIP_WOLF;
            case "leather" -> SoundEvents.ARMOR_EQUIP_LEATHER;
            case "base" -> SoundEvents.ARMOR_EQUIP_IRON;
            case "shiny" -> SoundEvents.ARMOR_EQUIP_DIAMOND;
            case "metal" -> SoundEvents.ARMOR_EQUIP_NETHERITE;
            default -> SoundEvents.ARMOR_EQUIP_GENERIC;
        };
    }

    public Holder<ArmorMaterial> getPotentialArmorMaterials() {
        return ArmorMaterials.LEATHER;
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(@NotNull ItemStack stack) {
        if (!this.hasModularType(stack)) {
            return super.getEquipmentSlot(stack);
        }
        ModularType modularType = this.getModularType(stack);
        if (modularType != null) {
            for (String action : modularType.actions) {
                Object onAction = ModularType.doAction(action, "getEquipmentSlot", stack);
                if (onAction == null || !(onAction instanceof EquipmentSlot)) continue;
                EquipmentSlot result = (EquipmentSlot)onAction;
                return result;
            }
        }
        return super.getEquipmentSlot(stack);
    }

    public List<ResourceLocation> getArmorTextures(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        int num = innerModel ? 2 : 1;
        List parts = this.getDynamicParts(stack);
        if (parts.isEmpty()) {
            return list;
        }
        for (Pair pair : parts) {
            ItemStack partStack = (ItemStack)pair.getFirst();
            IDynamicPart partDynamic = (IDynamicPart)pair.getSecond();
            Optional<MaterialType> material = partDynamic.getMaterialType(partStack);
            if (material.isEmpty()) {
                return list;
            }
            Optional<PartType> part = partDynamic.getPartType(partStack);
            if (part.isEmpty()) {
                return list;
            }
            PartType p = part.get();
            MaterialType m = material.get();
            String pPath = p.id.getPath();
            boolean bool = pPath.contains("helmet") || pPath.contains("chestplate") || pPath.contains("leggings") || pPath.contains("boots");
            Object prefix = bool ? "" : pPath + "/";
            String path = "armors/" + (String)prefix + m.texture + "_layer_" + num + "_" + m.id.getPath();
            if (bool) {
                list.addFirst(SlagEmbers.loc(m.id.getNamespace(), path));
                continue;
            }
            list.add(SlagEmbers.loc(m.id.getNamespace(), path));
        }
        if (list.isEmpty()) {
            list.add(SlagEmbers.loc("textures/armors/metal_layer_" + num + ".png"));
        }
        return list;
    }
}

