/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.items.modular;

import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.util.RegistrateDistExecutor;
import dev.lopyluna.slag.client.ClientTooltips;
import dev.lopyluna.slag.client.render.SimpleCustomRenderer;
import dev.lopyluna.slag.content.items.dynamic_part.IDynamicPart;
import dev.lopyluna.slag.content.items.dynamic_part.IModularItem;
import dev.lopyluna.slag.content.items.modular.DataDynamicParts;
import dev.lopyluna.slag.content.items.modular.ModularItemRenderer;
import dev.lopyluna.slag.content.types.MaterialType;
import dev.lopyluna.slag.content.types.ModularType;
import dev.lopyluna.slag.register.AllDataComponents;
import dev.lopyluna.slag.register.AllDynamicTypes;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class ModularItem
extends Item
implements IModularItem {
    public ModularItem(Item.Properties properties) {
        super(properties.durability(924).stacksTo(1).component(AllDataComponents.DYNAMIC_PARTS, (Object)DataDynamicParts.EMPTY));
    }

    public boolean hasModularType(ItemStack stack) {
        return stack.has(AllDataComponents.MODULAR_TYPE);
    }

    public ModularType getModularType(ItemStack stack) {
        ResourceLocation loc = (ResourceLocation)stack.get(AllDataComponents.MODULAR_TYPE);
        if (loc == null) {
            return null;
        }
        return AllDynamicTypes.getModular(loc).orElse(null);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        InteractionResultHolder pass = super.use(level, player, usedHand);
        ItemStack stack = player.getItemInHand(usedHand);
        if (stack.getCount() != 1 || stack.has(AllDataComponents.BAKED)) {
            return pass;
        }
        if (player.isShiftKeyDown()) {
            DataDynamicParts parts = this.getParts(stack);
            if (parts == null) {
                return pass;
            }
            ModularType modularType = this.getModularTypeFromParts(parts);
            if (modularType == null || !modularType.equalFinalSegmentStacks(parts.getAllNonDynamicParts())) {
                return pass;
            }
            ItemStack result = modularType.getResultStack();
            if (!result.isEmpty()) {
                this.playBuildSound((Entity)player, null);
                return InteractionResultHolder.success((Object)result);
            }
            ResourceLocation typeID = modularType.id;
            List<ItemStack> toolParts = parts.itemsCopy();
            boolean fireImmune = false;
            for (ItemStack part : toolParts) {
                Item item;
                if (!fireImmune && (item = part.getItem()) instanceof IDynamicPart) {
                    IDynamicPart p = (IDynamicPart)item;
                    fireImmune = p.isFireImmune(part);
                }
                part.set(AllDataComponents.BUILT, (Object)typeID);
            }
            stack.set(AllDataComponents.BAKED, (Object)typeID);
            stack.set(AllDataComponents.MODULAR_TYPE, (Object)modularType.id);
            if (fireImmune) {
                stack.set(DataComponents.FIRE_RESISTANT, (Object)Unit.INSTANCE);
            }
            this.setParts(stack, toolParts);
            this.playBuildSound((Entity)player, null);
            return InteractionResultHolder.success((Object)stack);
        }
        return pass;
    }

    public boolean containsStack(List<ItemStack> stacks, ItemStack stack) {
        for (ItemStack part : stacks) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)part)) continue;
            return true;
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack print, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (print.getCount() != 1 || print.has(AllDataComponents.BAKED)) {
            return false;
        }
        if (slot.allowModification(player)) {
            DataDynamicParts parts = this.getParts(print);
            if (parts == null) {
                return false;
            }
            if (other.isEmpty() && parts.isEmpty()) {
                return false;
            }
            List<ItemStack> copyParts = parts.itemsCopy();
            if (copyParts == null) {
                return false;
            }
            boolean bool = false;
            List<Object> possibleParts = parts.getPossibleParts();
            Item item = other.getItem();
            if (item instanceof IDynamicPart) {
                IDynamicPart part = (IDynamicPart)item;
                possible = parts.getPossibleTags(possibleParts);
                if (!possible.contains(part.getPartSegment(other))) {
                    return false;
                }
                this.playInsertSound((Entity)player);
                if (action == ClickAction.PRIMARY) {
                    copyParts.add(other.copy());
                    other.setCount(0);
                } else {
                    copyParts.add(other.copyWithCount(1));
                    other.shrink(1);
                }
                bool = true;
            } else if (!other.isEmpty()) {
                possible = parts.getPossibleStacks(possibleParts);
                if (!this.containsStack(possible, other)) {
                    return false;
                }
                this.playInsertSound((Entity)player);
                if (action == ClickAction.PRIMARY) {
                    copyParts.add(other.copy());
                    other.setCount(0);
                } else {
                    copyParts.add(other.copyWithCount(1));
                    other.shrink(1);
                }
                bool = true;
            } else if (action == ClickAction.PRIMARY) {
                ItemStack stack = copyParts.getFirst();
                this.playRemoveOneSound((Entity)player);
                access.set(stack);
                copyParts.removeFirst();
                bool = true;
            }
            if (bool) {
                this.setParts(print, copyParts);
                return true;
            }
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        Level level;
        super.appendHoverText(stack, ctx, tooltip, flag);
        if (!this.hasModularType(stack)) {
            List<ItemStack> copyParts;
            DataDynamicParts parts = this.getParts(stack);
            if (parts == null) {
                return;
            }
            ModularType modularType = this.getModularTypeFromParts(parts);
            if (modularType != null) {
                int count = modularType.getResultStack().getCount();
                tooltip.add((Component)Component.literal((String)RegistrateLangProvider.toEnglishName((String)modularType.id.getPath())).append((String)(count > 1 ? " x" + count : "")).withStyle(ChatFormatting.YELLOW));
            }
            if ((copyParts = parts.itemsCopy()) == null || copyParts.isEmpty()) {
                return;
            }
            List<Object> possibleParts = parts.getPossibleParts();
            if (!possibleParts.isEmpty()) {
                tooltip.add((Component)Component.literal((String)"Possible Parts:").withStyle(ChatFormatting.GRAY));
            }
            for (Object part : possibleParts) {
                if (part instanceof ItemStack) {
                    ItemStack partStack = (ItemStack)part;
                    tooltip.add((Component)Component.literal((String)" ").append(partStack.getHoverName()).append(" x" + partStack.getCount()).withStyle(ChatFormatting.GRAY));
                }
                if (!(part instanceof TagKey)) continue;
                TagKey partTag = (TagKey)part;
                tooltip.add((Component)Component.literal((String)(" " + RegistrateLangProvider.toEnglishName((String)Arrays.stream(partTag.location().toString().split("/")).toList().getLast()))).withStyle(ChatFormatting.GRAY));
            }
        }
        if ((level = ctx.level()) == null) {
            return;
        }
        if (level.isClientSide()) {
            RegistrateDistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientTooltips.appendHoverTextModularTool(this, stack, ctx, tooltip, flag));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(SimpleCustomRenderer.create(this, new ModularItemRenderer()));
    }

    private void playFailSound(Entity entity) {
        entity.playSound(SoundEvents.CRAFTER_FAIL, 1.25f, 0.5f + entity.level().getRandom().nextFloat() * 0.4f);
        entity.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), 0.5f, 0.5f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.DECORATED_POT_INSERT, 0.8f, 0.5f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.DECORATED_POT_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playBuildSound(Entity entity, @Nullable SoundEvent event) {
        entity.playSound(event != null ? event : SoundEvents.ANVIL_USE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public ModularType getModularTypeFromParts(DataDynamicParts parts) {
        for (ModularType modular : AllDynamicTypes.getAllModulars()) {
            if (!parts.hasAllDynamicPartSegments(modular.segments) || !modular.equalFinalSegmentStacks(parts.getAllNonDynamicParts())) continue;
            return modular;
        }
        return null;
    }

    public ModularType getModularTypeFromStack(ItemStack stack) {
        DataDynamicParts parts = this.getParts(stack);
        if (parts == null) {
            return null;
        }
        return this.getModularTypeFromParts(parts);
    }

    @NotNull
    public String getDescriptionId(ItemStack stack) {
        String id = super.getDescriptionId(stack);
        if (!stack.has(AllDataComponents.BAKED)) {
            return id;
        }
        DataDynamicParts parts = this.getParts(stack);
        if (parts == null) {
            return id;
        }
        ModularType modularType = this.getModularTypeFromParts(parts);
        if (modularType == null) {
            return id;
        }
        List materialTypes = this.getMaterialTypes(parts);
        if (materialTypes.isEmpty()) {
            return "item." + modularType.id.toString().replace(":", ".");
        }
        StringBuilder materials = new StringBuilder();
        for (MaterialType material : materialTypes) {
            materials.append(material.id.getPath()).append("_");
        }
        return "item." + modularType.id.getNamespace() + "." + String.valueOf(materials) + modularType.id.getPath();
    }

    @NotNull
    public Component getName(ItemStack stack) {
        String id = this.getDescriptionId(stack);
        String name = id.split("\\.")[2];
        return Component.translatableWithFallback((String)id, (String)RegistrateLangProvider.toEnglishName((String)name));
    }

    public boolean isTool(ItemStack stack) {
        ModularType modularType = this.getModularType(stack);
        return modularType != null && modularType.actions.contains("isTool");
    }

    public boolean isArmor(ItemStack stack) {
        ModularType modularType = this.getModularType(stack);
        return modularType != null && modularType.actions.contains("isArmor");
    }
}

