/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.items.modular;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.client.render.CustomRenderedItemModel;
import dev.lopyluna.slag.client.render.CustomRenderedItemModelRenderer;
import dev.lopyluna.slag.client.render.PartialItemModelRenderer;
import dev.lopyluna.slag.content.items.dynamic_part.DynamicPartRenderer;
import dev.lopyluna.slag.content.items.dynamic_part.IDynamicPart;
import dev.lopyluna.slag.content.items.dynamic_part.IModularItem;
import dev.lopyluna.slag.content.items.modular.DataDynamicParts;
import dev.lopyluna.slag.content.types.ModularType;
import dev.lopyluna.slag.register.AllDataComponents;
import dev.lopyluna.slag.register.AllDynamicTypes;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;

@EventBusSubscriber(modid="slag", value={Dist.CLIENT})
@ParametersAreNonnullByDefault
public class ModularItemRenderer
extends CustomRenderedItemModelRenderer {
    @Override
    protected void render(ItemStack stack, ItemRenderer itemRenderer, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext ctx, PoseStack ms, MultiBufferSource buf, int light, int overlay) {
        float randomRot;
        ClientLevel level = this.mc.level;
        LocalPlayer player = this.mc.player;
        if (level == null || player == null) {
            return;
        }
        Item item = stack.getItem();
        if (!(item instanceof IModularItem)) {
            renderer.render(model.getOriginalModel(), light);
            return;
        }
        IModularItem tool = (IModularItem)item;
        ItemModelShaper shaper = itemRenderer.getItemModelShaper();
        ModelManager manager = shaper.getModelManager();
        boolean baked = stack.has(AllDataComponents.BAKED);
        ResourceLocation bakedLoc = (ResourceLocation)stack.get(AllDataComponents.MODULAR_TYPE);
        ModularType modularType = AllDynamicTypes.getModular(bakedLoc).orElse(null);
        String bakedPath = bakedLoc != null ? bakedLoc.getPath() : "";
        String suffix = modularType != null && !modularType.modelType.isEmpty() ? "_" + modularType.modelType : "";
        BakedModel baseModel = ModularItemRenderer.getModel(stack, level, (Player)player, SlagEmbers.loc((String)(baked ? "item/modular_item_baked" + suffix : "item/modular_item_blueprint")), manager);
        float nudge = ctx == ItemDisplayContext.GROUND || ctx == ItemDisplayContext.FIXED ? 0.01f : 0.001f;
        int i = 1;
        DataDynamicParts dynamicParts = tool.getParts(stack);
        int totalItems = !baked ? (dynamicParts == null || dynamicParts.isEmpty() ? 0 : dynamicParts.size()) : -1;
        int currentIndex = 0;
        Random random = !baked ? new Random((long)totalItems * 100L + (long)(0 >= totalItems ? 0 : dynamicParts.hashCode())) : null;
        float f = randomRot = !baked ? random.nextFloat() * 360.0f : -1.0f;
        float randomSpeedMod = !baked ? (3.25f + random.nextFloat() * 1.25f) * (float)(random.nextBoolean() ? 1 : -1) : -1.0f;
        boolean fireImmune = stack.has(DataComponents.FIRE_RESISTANT);
        boolean left = player.getMainArm() == HumanoidArm.LEFT && (ctx == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || ctx == ItemDisplayContext.THIRD_PERSON_LEFT_HAND);
        ms.pushPose();
        baseModel.applyTransform(ctx, ms, left);
        if (!baked) {
            renderer.render(baseModel, light);
        }
        if (dynamicParts != null && !dynamicParts.isEmpty()) {
            for (ItemStack part : dynamicParts.itemCopyRandom(random)) {
                if (part.isEmpty()) continue;
                ms.pushPose();
                ms.scale(1.0f + (float)i * nudge, 1.0f + (float)i * nudge, 1.0f + (float)i * (nudge * 2.0f));
                if (baked) {
                    ModularItemRenderer.renderBakedPart(level, (Player)player, part, light, (fireImmune ? "_fire_proof_" : "_") + bakedPath, itemRenderer, renderer, manager);
                } else {
                    ModularItemRenderer.renderNonBakedPart((Level)level, (Player)player, part, light, totalItems, currentIndex, randomRot, randomSpeedMod, ms, itemRenderer, renderer, manager);
                }
                ms.popPose();
                ++i;
                ++currentIndex;
            }
        }
        if (ctx != ItemDisplayContext.HEAD && stack.has(DataComponents.TRIM) && suffix.equals("_equipable")) {
            ms.pushPose();
            BakedModel bakedModel = ModularItemRenderer.getModel(stack, level, (Player)player, SlagEmbers.loc("item/modular_item_baked_trim"), manager);
            renderer.render(bakedModel, light);
            ms.scale(1.0f + (float)i * nudge, 1.0f + (float)i * nudge, 1.0f + (float)i * (nudge * 2.0f));
            renderer.render(bakedModel, light);
            ms.popPose();
        }
        ms.popPose();
    }

    public static void renderBakedPart(ClientLevel level, Player player, ItemStack stack, int light, String suffix, ItemRenderer itemRenderer, PartialItemModelRenderer renderer, ModelManager manager) {
        if (stack.getItem() instanceof IDynamicPart) {
            renderer.render(DynamicPartRenderer.renderFallBack(stack, manager), light);
        } else {
            renderer.render(ModularItemRenderer.remapItemToCustomModel(stack, "", "", suffix, itemRenderer, manager, level, player), light);
        }
    }

    public static void renderNonBakedPart(Level level, Player player, ItemStack stack, int light, int totalItems, int currentIndex, float randomRot, float randomSpeedMod, PoseStack ms, ItemRenderer itemRenderer, PartialItemModelRenderer renderer, ModelManager manager) {
        float angleStep = 360.0f / (float)totalItems;
        float angle = angleStep * (float)currentIndex;
        float rotAngle = AnimationTickHolder.getRenderTime() * randomSpeedMod + randomRot % 360.0f;
        float angleRad = (float)Math.toRadians(angle + rotAngle);
        float radius = totalItems != 1 ? 0.0625f : 0.03125f;
        float offsetX = (float)Math.cos(angleRad) * radius;
        float offsetY = (float)Math.sin(angleRad) * radius;
        ms.translate(offsetX, offsetY, 0.0f);
        if (stack.getItem() instanceof IDynamicPart) {
            renderer.render(DynamicPartRenderer.renderFallBack(stack, manager), light);
        } else {
            renderer.render(itemRenderer.getModel(stack, level, (LivingEntity)player, 0), light);
        }
    }

    public static BakedModel remapItemToCustomModel(ItemStack stack, String prefix, @Nullable String name, String suffix, ItemRenderer itemRenderer, ModelManager manager, ClientLevel level, Player player) {
        if (stack.is(Items.STICK)) {
            String targetName = name == null || name.isEmpty() ? "handle" : name;
            String path = "item/" + prefix + targetName + suffix;
            return ModularItemRenderer.getModel(stack, level, player, SlagEmbers.loc(path), manager);
        }
        return itemRenderer.getModel(stack, (Level)level, (LivingEntity)player, 0);
    }

    @SubscribeEvent
    public static void registerAdditionalModels(ModelEvent.RegisterAdditional e) {
        e.register(ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc("item/modular_item_blueprint")));
        e.register(ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc("item/modular_item_baked")));
        e.register(ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc("item/modular_item_baked_handheld")));
        e.register(ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc("item/modular_item_baked_equipable")));
        e.register(ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc("item/modular_item_baked_trim")));
        for (String mixture : List.of("pickaxe", "axe", "shovel", "hoe", "sword", "mattock", "prybar", "graip", "mallet", "hammer", "scythe", "maul", "paxel")) {
            e.register(ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc("item/handle_fire_proof_" + mixture)));
            e.register(ModelResourceLocation.standalone((ResourceLocation)SlagEmbers.loc("item/handle_" + mixture)));
        }
    }
}

