/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.items.modular;

import dev.lopyluna.slag.content.items.dynamic_part.DynamicPartItem;
import dev.lopyluna.slag.content.items.modular.DataDynamicParts;
import dev.lopyluna.slag.content.items.modular.ModularItem;
import dev.lopyluna.slag.content.types.MaterialType;
import dev.lopyluna.slag.content.types.ModularType;
import dev.lopyluna.slag.register.AllTags;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class ModularToolsItem
extends ModularItem {
    public ModularToolsItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        if (!this.hasModularType(stack) || !this.isTool(stack)) {
            return super.getDefaultAttributeModifiers(stack);
        }
        return super.getDefaultAttributeModifiers(stack).withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)this.getSharp(stack), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)(-this.getAttackSpeed(stack)), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return this.hasModularType(stack) && this.isTool(stack);
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.hasModularType(stack) && this.isTool(stack)) {
            stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        }
    }

    @Override
    public boolean overrideOtherStackedOnMe(ItemStack print, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (this.hasModularType(other) && (this.isTool(other) || this.isArmor(other))) {
            return false;
        }
        return super.overrideOtherStackedOnMe(print, other, slot, action, player, access);
    }

    public boolean isDamageable(ItemStack stack) {
        return this.hasModularType(stack) && (this.isTool(stack) || this.isArmor(stack));
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        boolean has;
        boolean bl = has = this.hasModularType(stack) && this.isTool(stack);
        if (!level.isClientSide && has && state.getDestroySpeed((BlockGetter)level, pos) != 0.0f) {
            stack.hurtAndBreak(2, miningEntity, EquipmentSlot.MAINHAND);
        }
        return has;
    }

    public int getMaxDamage(ItemStack stack) {
        if (!this.hasModularType(stack) || !this.isTool(stack) && !this.isArmor(stack)) {
            return super.getMaxDamage(stack);
        }
        return Math.round(this.getDura(stack));
    }

    public int getEnchantmentValue(ItemStack stack) {
        if (!this.hasModularType(stack) || !this.isTool(stack) && !this.isArmor(stack)) {
            return super.getEnchantmentValue(stack);
        }
        return Math.round(this.getEnch(stack));
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (!this.hasModularType(stack) || !this.isTool(stack)) {
            return super.getDestroySpeed(stack, state);
        }
        return this.isCorrectToolForDrops(stack, state) ? this.getSpeed(stack) * (state.is(Blocks.COBWEB) ? 2.0f : 1.0f) : super.getDestroySpeed(stack, state);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        if (!this.hasModularType(stack) || !this.isTool(stack) && !this.isArmor(stack)) {
            return super.isValidRepairItem(stack, repairCandidate);
        }
        DataDynamicParts parts = this.getParts(stack);
        if (parts != null) {
            for (ItemStack part : parts.getAllDynamicParts()) {
                DynamicPartItem item;
                Optional<MaterialType> material;
                Item item2 = part.getItem();
                if (!(item2 instanceof DynamicPartItem) || (material = (item = (DynamicPartItem)item2).getMaterialType(part)).isEmpty() || !material.get().repairMaterials.get().test(repairCandidate)) continue;
                return true;
            }
        }
        return super.isValidRepairItem(stack, repairCandidate);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (!this.hasModularType(stack) || !this.isTool(stack)) {
            return super.isCorrectToolForDrops(stack, state);
        }
        ModularType modularType = this.getModularType(stack);
        if (modularType == null) {
            return super.isCorrectToolForDrops(stack, state);
        }
        boolean flag = false;
        for (String action : modularType.actions) {
            if (flag) break;
            switch (action) {
                case "pickaxe": 
                case "pickaxe_mineable": {
                    flag = state.is(BlockTags.MINEABLE_WITH_PICKAXE);
                    break;
                }
                case "axe": 
                case "axe_mineable": {
                    flag = state.is(BlockTags.MINEABLE_WITH_AXE);
                    break;
                }
                case "shovel": 
                case "shovel_mineable": {
                    flag = state.is(BlockTags.MINEABLE_WITH_SHOVEL);
                    break;
                }
                case "hoe": 
                case "hoe_mineable": {
                    flag = state.is(BlockTags.MINEABLE_WITH_HOE);
                    break;
                }
                case "sword": 
                case "sword_mineable": {
                    boolean bl = flag = state.is(Blocks.COBWEB) || state.is(BlockTags.SWORD_EFFICIENT);
                }
            }
            if (flag || !action.contains("_mineable")) continue;
            flag = state.is(AllTags.blockC(action.replace("_mineable", "")));
        }
        float i = 0.0f;
        if (state.is(BlockTags.INCORRECT_FOR_WOODEN_TOOL)) {
            i = 1.0f;
        }
        if (state.is(BlockTags.INCORRECT_FOR_GOLD_TOOL)) {
            i = 2.0f;
        }
        if (state.is(BlockTags.INCORRECT_FOR_STONE_TOOL)) {
            i = 3.0f;
        }
        if (state.is(BlockTags.INCORRECT_FOR_IRON_TOOL)) {
            i = 4.0f;
        }
        if (state.is(BlockTags.INCORRECT_FOR_DIAMOND_TOOL)) {
            i = 5.0f;
        }
        if (state.is(BlockTags.INCORRECT_FOR_NETHERITE_TOOL)) {
            i = 6.0f;
        }
        return this.getTier(stack) > i + 0.5f && flag;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        ModularType modularType = this.getModularType(stack);
        if (modularType != null) {
            for (String action : modularType.actions) {
                Boolean b;
                Object onAction = ModularType.doAction(action, "canDisableShield", stack, shield, entity, attacker);
                if (onAction == null || !(onAction instanceof Boolean) || !(b = (Boolean)onAction).booleanValue()) continue;
                return true;
            }
        }
        return super.canDisableShield(stack, shield, entity, attacker);
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        ModularType modularType = this.getModularType(stack);
        if (modularType != null) {
            for (String action : modularType.actions) {
                InteractionResultHolder result;
                Object onAction = ModularType.doAction(action, "use", stack, level, player, usedHand);
                if (onAction == null || !(onAction instanceof InteractionResultHolder) || !(result = (InteractionResultHolder)onAction).getResult().consumesAction()) continue;
                return result;
            }
        }
        return super.use(level, player, usedHand);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        ModularType modularType = this.getModularType(stack);
        if (modularType != null) {
            for (String action : modularType.actions) {
                InteractionResult result;
                Object onAction = ModularType.doAction(action, "useOn", context);
                if (onAction == null || !(onAction instanceof InteractionResult) || !(result = (InteractionResult)onAction).consumesAction()) continue;
                return result;
            }
        }
        return super.useOn(context);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        ModularType modularType = this.getModularType(stack);
        if (modularType != null) {
            for (String action : modularType.actions) {
                Boolean b;
                Object onAction = ModularType.doAction(action, "canPerformAction", stack, itemAbility);
                if (onAction == null || !(onAction instanceof Boolean) || !(b = (Boolean)onAction).booleanValue()) continue;
                return true;
            }
        }
        return super.canPerformAction(stack, itemAbility);
    }

    public boolean isEnchantable(ItemStack stack) {
        if (!this.hasModularType(stack)) {
            return super.isEnchantable(stack);
        }
        return true;
    }
}

