/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.items.modular.actions;

import dev.lopyluna.slag.register.AllTags;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class HarvestActions {
    public static final HarvestActions INSTANCE = new HarvestActions();

    public Object doAction(String action, List<Object> args) {
        if (action.equals("useOn")) {
            return this.useOn((UseOnContext)args.getFirst());
        }
        return null;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Player player = context.getPlayer();
        BlockState state = level.getBlockState(blockpos);
        if (state.is(AllTags.HARVESTABLE)) {
            ArrayList<IntegerProperty> properties = new ArrayList<IntegerProperty>(List.of(BlockStateProperties.AGE_1, BlockStateProperties.AGE_2, BlockStateProperties.AGE_3, BlockStateProperties.AGE_4, BlockStateProperties.AGE_5, BlockStateProperties.AGE_7, BlockStateProperties.AGE_15, BlockStateProperties.AGE_25));
            InteractionResult result = InteractionResult.PASS;
            boolean hasProperty = false;
            for (IntegerProperty property : properties) {
                if (!state.hasProperty((Property)property)) continue;
                if ((Integer)state.getValue((Property)property) == property.getPossibleValues().size() - 1) {
                    state = (BlockState)state.setValue((Property)property, (Comparable)Integer.valueOf(0));
                    level.destroyBlock(blockpos, true, (Entity)player);
                    level.setBlockAndUpdate(blockpos, state);
                    result = InteractionResult.SUCCESS;
                }
                hasProperty = true;
                break;
            }
            if (!hasProperty) {
                level.destroyBlock(blockpos, true, (Entity)player);
                result = InteractionResult.SUCCESS;
            }
            if (result == InteractionResult.SUCCESS && player != null) {
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
            }
            return result;
        }
        return InteractionResult.PASS;
    }
}

