/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.items.modular.actions;

import dev.lopyluna.slag.content.items.modular.actions.AxeActions;
import dev.lopyluna.slag.mixin.AxeItemAccessor;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class StripBlockAction {
    public static final StripBlockAction INSTANCE = new StripBlockAction();

    public Object doAction(String action, List<Object> args) {
        return switch (action) {
            case "canPerformAction" -> Boolean.valueOf(this.canPerformAction((ItemStack)args.getFirst(), (ItemAbility)args.getLast()));
            case "useOn" -> this.useOn((UseOnContext)args.getFirst());
            default -> null;
        };
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Player player = context.getPlayer();
        if (AxeItemAccessor.playerHasShieldUseIntent(context)) {
            return InteractionResult.PASS;
        }
        Optional<BlockState> optional = AxeActions.evaluateNewBlockState(level, blockpos, player, level.getBlockState(blockpos), context);
        if (optional.isEmpty()) {
            return InteractionResult.PASS;
        }
        ItemStack itemstack = context.getItemInHand();
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockpos, itemstack);
        }
        level.setBlock(blockpos, optional.get(), 11);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)optional.get()));
        if (player != null) {
            itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return itemAbility == ItemAbilities.AXE_STRIP || itemAbility == ItemAbilities.AXE_SCRAPE || itemAbility == ItemAbilities.AXE_WAX_OFF;
    }
}

