/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.jei;

import dev.lopyluna.slag.content.items.modular.DataDynamicParts;
import dev.lopyluna.slag.register.AllDataComponents;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EmbersSubtypeInterpreters {
    public static final DynamicPartSubtype PART_INSTANCE = new DynamicPartSubtype();
    public static final ModularItemSubtype MODULAR_INSTANCE = new ModularItemSubtype();

    public static class DynamicPartSubtype
    extends SimpleInterpreterAdapter<ItemStack> {
        private DynamicPartSubtype() {
            super((stack, ctx) -> {
                ResourceLocation materialId = (ResourceLocation)stack.get(AllDataComponents.MATERIAL_TYPE);
                ResourceLocation partId = (ResourceLocation)stack.get(AllDataComponents.PART_TYPE);
                ResourceLocation builtId = (ResourceLocation)stack.get(AllDataComponents.BUILT);
                if (materialId == null || partId == null) {
                    return "";
                }
                StringBuilder sb = new StringBuilder();
                sb.append("material:").append(materialId).append(';');
                sb.append("part:").append(partId).append(';');
                if (builtId != null) {
                    sb.append("built:").append(builtId).append(';');
                }
                return sb.toString();
            });
        }
    }

    public static class ModularItemSubtype
    extends SimpleInterpreterAdapter<ItemStack> {
        private ModularItemSubtype() {
            super((stack, ctx) -> {
                DataDynamicParts data = (DataDynamicParts)stack.get(AllDataComponents.DYNAMIC_PARTS);
                ResourceLocation bakedId = (ResourceLocation)stack.get(AllDataComponents.BAKED);
                if (data == null || data.isEmpty()) {
                    return "";
                }
                StringBuilder sb = new StringBuilder();
                if (bakedId != null) {
                    sb.append("baked:").append(bakedId).append(';');
                }
                for (ItemStack s : data.itemsCopy()) {
                    if (s.isEmpty()) continue;
                    ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)s.getItem());
                    sb.append(id);
                    ResourceLocation modularId = (ResourceLocation)s.get(AllDataComponents.BUILT);
                    ResourceLocation materialId = (ResourceLocation)s.get(AllDataComponents.MATERIAL_TYPE);
                    ResourceLocation partId = (ResourceLocation)s.get(AllDataComponents.PART_TYPE);
                    if (modularId != null) {
                        sb.append("[modular:").append(modularId).append("]");
                    }
                    if (materialId != null) {
                        sb.append("[mat:").append(materialId).append("]");
                    }
                    if (partId != null) {
                        sb.append("[part:").append(partId).append("]");
                    }
                    sb.append('#').append(s.getCount()).append(';');
                }
                return sb.toString();
            });
        }
    }

    public static interface IInterpreter<T> {
        public String apply(T var1, UidContext var2);
    }

    @ParametersAreNonnullByDefault
    private static class SimpleInterpreterAdapter<T>
    implements ISubtypeInterpreter<T> {
        private final IInterpreter<T> interpreter;

        public SimpleInterpreterAdapter(IInterpreter<T> interpreter) {
            this.interpreter = interpreter;
        }

        public Object getSubtypeData(T stack, UidContext ctx) {
            String result = this.interpreter.apply(stack, ctx);
            if (result.isEmpty()) {
                return null;
            }
            return result;
        }

        @NotNull
        public String getLegacyStringSubtypeInfo(T stack, UidContext ctx) {
            return this.interpreter.apply(stack, ctx);
        }
    }
}

