/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.jei.category;

import com.mojang.serialization.Codec;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.content.AllUtils;
import dev.lopyluna.slag.content.blocks.crucible_interface.client.InterfaceScreen;
import dev.lopyluna.slag.content.blocks.melter.MeltingRecipe;
import dev.lopyluna.slag.content.jei.EmbersRecipesJEI;
import dev.lopyluna.slag.register.AllBlocks;
import dev.lopyluna.slag.register.AllTags;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.common.Internal;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class MeltingCategory
extends AbstractRecipeCategory<RecipeHolder<MeltingRecipe>> {
    private final IDrawable tankBackground;
    private final IDrawable tankOverlay;
    private final IDrawable validHeaterSlot;

    public MeltingCategory(IGuiHelper guiHelper) {
        super(EmbersRecipesJEI.MELTING.get(), (Component)Component.translatableWithFallback((String)"gui.slag.category.melting", (String)"Melting"), guiHelper.createDrawableItemLike(AllBlocks.MELTER), 123, 54);
        ResourceLocation backgroundTexture = SlagEmbers.loc("textures/gui/jei.png");
        this.tankBackground = guiHelper.createDrawable(backgroundTexture, 0, 0, 32, 56);
        this.tankOverlay = guiHelper.createDrawable(backgroundTexture, 32, 0, 32, 56);
        this.validHeaterSlot = guiHelper.createDrawable(backgroundTexture, 64, 0, 20, 20);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<MeltingRecipe> holder, IFocusGroup focuses) {
        int yBase;
        MeltingRecipe recipe = (MeltingRecipe)holder.value();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(List.of(recipe.getInput().getItems()));
        inputs.addAll(recipe.getInputs());
        inputs.removeIf(s -> s.is(Items.BARRIER));
        builder.addInputSlot(20, 1).setStandardSlotBackground().addItemStacks(inputs);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 20, 38).setBackground(this.validHeaterSlot, -2, -2).addItemStacks(AllUtils.getStacksFromTag(AllTags.MELTER_HEATER));
        List<FluidStack> fluids = MeltingCategory.getResultFluids(recipe);
        TooltipFlag.Default tooltipFlag = Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
        boolean advance = tooltipFlag.advanced();
        int totalMb = MeltingCategory.getTotalAmount(fluids);
        if (totalMb == 0) {
            return;
        }
        int tankHeight = 48;
        int filledHeight = MeltingCategory.getFilledHeight(totalMb, tankHeight);
        float unit = (float)filledHeight / (float)totalMb;
        int yCur = yBase = 3 + (tankHeight - filledHeight);
        for (int i = 0; i < fluids.size(); ++i) {
            FluidStack fluid = fluids.get(i);
            int fluidHeight = Math.max(2, (int)((float)fluid.getAmount() * unit));
            if (i == fluids.size() - 1) {
                fluidHeight = Math.max(2, yBase + filledHeight - yCur);
            }
            if (fluidHeight < 2) continue;
            IRecipeSlotBuilder fluidSlot = builder.addOutputSlot(83, yCur).setFluidRenderer((long)fluid.getAmount(), false, 24, fluidHeight).addFluidStack(fluid.getFluid(), (long)fluid.getAmount());
            if (i == 0) {
                fluidSlot.setOverlay(this.tankOverlay, -4, -4 - (yCur - 3)).setBackground(this.tankBackground, -4, -4 - (yCur - 3));
            }
            fluidSlot.addRichTooltipCallback((s, t) -> {
                t.clear();
                ArrayList<Component> tooltips = new ArrayList<Component>();
                tooltips.add(fluid.getDisplayName());
                InterfaceScreen.createLang(fluid, tooltips).run();
                if (advance) {
                    ResourceLocation loc = BuiltInRegistries.FLUID.getKey((Object)fluid.getFluid());
                    tooltips.add((Component)Component.literal((String)loc.toString()).withStyle(ChatFormatting.DARK_GRAY));
                    IModIdHelper helper = Internal.getJeiRuntime().getJeiHelpers().getModIdHelper();
                    tooltips.add((Component)Component.literal((String)this.getFormattedModNameForModIdWithoutDisplay(helper, loc.getNamespace())).withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC));
                    ResourceLocation name = this.getRegistryName(holder);
                    if (name != null) {
                        String mod;
                        tooltips.add((Component)Component.translatable((String)"jei.tooltip.recipe.id", (Object[])new Object[]{Component.literal((String)name.toString())}).withStyle(ChatFormatting.DARK_GRAY));
                        String modID = name.getNamespace();
                        if (!modID.equals(this.getRecipeType().getUid().getNamespace()) && !(mod = this.getFormattedModNameForModId(helper, name.getNamespace())).isEmpty()) {
                            tooltips.add((Component)Component.translatable((String)"jei.tooltip.recipe.by", (Object[])new Object[]{mod}).withStyle(ChatFormatting.GRAY));
                        }
                    }
                }
                t.addAll(tooltips);
            });
            yCur += fluidHeight;
        }
    }

    private static int getFilledHeight(int totalMb, int tankHeight) {
        int tankCapacity;
        int maxCapacity = 2500;
        if (totalMb >= maxCapacity) {
            tankCapacity = maxCapacity;
        } else {
            float t = Math.min(1.0f, (float)totalMb / (float)maxCapacity);
            float adjustedT = (float)Math.pow(t, 1.5);
            float easedFill = 1.0f - (float)Math.cos((double)adjustedT * Math.PI / 2.0);
            if (easedFill < 0.01f) {
                easedFill = 0.01f;
            }
            tankCapacity = (int)((float)totalMb / easedFill);
            tankCapacity = Math.min(tankCapacity, maxCapacity);
        }
        float fillRatio = Math.min(1.0f, (float)totalMb / (float)tankCapacity);
        return Math.max(2, (int)((float)tankHeight * fillRatio));
    }

    public String getFormattedModNameForModIdWithoutDisplay(IModIdHelper helper, String modId) {
        return helper.getFormattedModNameForModId(modId);
    }

    public String getFormattedModNameForModId(IModIdHelper helper, String modId) {
        if (!helper.isDisplayingModNameEnabled()) {
            return "";
        }
        return helper.getFormattedModNameForModId(modId);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<MeltingRecipe> holder, IFocusGroup focuses) {
        builder.addAnimatedRecipeArrow(200).setPosition(49, 17);
        builder.addAnimatedRecipeFlame(999999).setPosition(21, 20);
    }

    public boolean isHandled(RecipeHolder<MeltingRecipe> holder) {
        MeltingRecipe recipe = (MeltingRecipe)holder.value();
        if (recipe.isSpecial()) {
            return false;
        }
        return !recipe.getInput().hasNoItems() || !recipe.getInputs().isEmpty();
    }

    public ResourceLocation getRegistryName(RecipeHolder<MeltingRecipe> recipe) {
        return recipe.id();
    }

    @NotNull
    public Codec<RecipeHolder<MeltingRecipe>> getCodec(ICodecHelper helper, @NotNull IRecipeManager manager) {
        return helper.getRecipeHolderCodec();
    }

    public static int getTotalAmount(List<FluidStack> fluids) {
        int i = 0;
        for (FluidStack fluid : fluids) {
            i += fluid.getAmount();
        }
        return i;
    }

    public static List<FluidStack> getResultFluids(MeltingRecipe recipe) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.registryAccess();
        return recipe.getResultFluids((HolderLookup.Provider)registryAccess);
    }
}

