/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lopyluna.slag.SlagEmbers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import org.joml.Math;

public class MaterialType {
    public final ResourceLocation id;
    public int sortOrder;
    public final float speed;
    public final float dura;
    public final float tier;
    public final float sharp;
    public final float kbRes;
    public final float defense;
    public final float tough;
    public final float ench;
    public final String texture;
    public final boolean fireProof;
    public final Supplier<Ingredient> repairMaterials;
    public final Supplier<Fluid> moltenFluid;
    public final List<Integer> palette;
    public boolean dontRegister;
    private static final Codec<Integer> COLOR_CODEC = Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
        try {
            String hexStr = str.startsWith("0x") || str.startsWith("0X") ? str.substring(2) : str;
            int color = Integer.parseUnsignedInt(hexStr, 16);
            return DataResult.success((Object)color);
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> "Invalid hex color: " + str);
        }
    }, color -> String.format("0x%06X", color)), (Codec)Codec.INT).xmap(either -> (Integer)either.map(i -> i, i -> i), Either::right);
    public static final Codec<MaterialType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(m -> m.id), (App)Codec.INT.optionalFieldOf("sort_order", (Object)0).forGetter(m -> m.sortOrder), (App)Codec.FLOAT.optionalFieldOf("knockback_resistance", (Object)Float.valueOf(0.0f)).forGetter(m -> Float.valueOf(m.kbRes)), (App)Codec.FLOAT.optionalFieldOf("defense", (Object)Float.valueOf(0.0f)).forGetter(m -> Float.valueOf(m.defense)), (App)Codec.FLOAT.optionalFieldOf("toughness", (Object)Float.valueOf(0.0f)).forGetter(m -> Float.valueOf(m.tough)), (App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(0.0f)).forGetter(m -> Float.valueOf(m.speed)), (App)Codec.FLOAT.optionalFieldOf("durability", (Object)Float.valueOf(0.0f)).forGetter(m -> Float.valueOf(m.dura)), (App)Codec.FLOAT.optionalFieldOf("tier", (Object)Float.valueOf(0.0f)).forGetter(m -> Float.valueOf(m.tier)), (App)Codec.FLOAT.optionalFieldOf("sharpness", (Object)Float.valueOf(0.0f)).forGetter(m -> Float.valueOf(m.sharp)), (App)Codec.FLOAT.optionalFieldOf("enchantability", (Object)Float.valueOf(0.0f)).forGetter(m -> Float.valueOf(m.ench)), (App)Codec.BOOL.optionalFieldOf("fireproof", (Object)false).forGetter(m -> m.fireProof), (App)Codec.STRING.optionalFieldOf("texture", (Object)"base").forGetter(m -> m.texture), (App)Ingredient.CODEC.optionalFieldOf("repair_ingredient", (Object)Ingredient.EMPTY).forGetter(m -> m.repairMaterials.get()), (App)ResourceLocation.CODEC.optionalFieldOf("molten_fluid").forGetter(m -> {
        Fluid fluid = m.moltenFluid.get();
        if (fluid == null) {
            return Optional.empty();
        }
        return Optional.of(BuiltInRegistries.FLUID.getKey((Object)fluid));
    }), (App)COLOR_CODEC.listOf().optionalFieldOf("palette", List.of()).forGetter(m -> m.palette)).apply((Applicative)instance, MaterialType::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MaterialType> STREAM_CODEC = StreamCodec.of(MaterialType::toNetwork, MaterialType::fromNetwork);

    public int hashCode() {
        int fluidHash = 0;
        if (this.moltenFluid != null && this.moltenFluid.get() != null) {
            fluidHash = this.moltenFluid.get().hashCode();
        }
        int repairHash = 0;
        if (this.repairMaterials != null && !this.repairMaterials.get().isEmpty() && this.repairMaterials.get() != null) {
            repairHash = this.repairMaterials.get().hashCode();
        }
        return this.id.hashCode() + this.texture.hashCode() + repairHash + fluidHash + this.palette.hashCode() + Objects.hash(Float.valueOf(this.kbRes), Float.valueOf(this.defense), Float.valueOf(this.tough), Float.valueOf(this.speed), Float.valueOf(this.dura), Float.valueOf(this.tier), Float.valueOf(this.sharp), Float.valueOf(this.ench), this.fireProof, this.sortOrder);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MaterialType)) {
            return false;
        }
        MaterialType other = (MaterialType)obj;
        if (other.fireProof != this.fireProof) {
            return false;
        }
        if (!Objects.equals(other.texture, this.texture)) {
            return false;
        }
        if (!other.repairMaterials.get().test(this.repairMaterials.get().getItems()[0])) {
            return false;
        }
        if (other.moltenFluid.get() != this.moltenFluid.get()) {
            return false;
        }
        if (other.kbRes != this.kbRes) {
            return false;
        }
        if (other.defense != this.defense) {
            return false;
        }
        if (other.tough != this.tough) {
            return false;
        }
        if (other.speed != this.speed) {
            return false;
        }
        if (other.dura != this.dura) {
            return false;
        }
        if (other.tier != this.tier) {
            return false;
        }
        if (other.sharp != this.sharp) {
            return false;
        }
        if (other.ench != this.ench) {
            return false;
        }
        if (!other.palette.equals(this.palette)) {
            return false;
        }
        if (other.sortOrder != this.sortOrder) {
            return false;
        }
        return other.id.equals((Object)this.id);
    }

    private static MaterialType fromNetwork(RegistryFriendlyByteBuf buf) {
        ResourceLocation id = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf);
        int sortOrder = buf.readInt();
        float kbRes = buf.readFloat();
        float defense = buf.readFloat();
        float tough = buf.readFloat();
        float speed = buf.readFloat();
        float dura = buf.readFloat();
        float tier = buf.readFloat();
        float sharp = buf.readFloat();
        float ench = buf.readFloat();
        boolean fireProof = buf.readBoolean();
        String texture = buf.readUtf();
        Ingredient repairIngredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
        boolean hasFluid = buf.readBoolean();
        Fluid fluid = hasFluid ? (Fluid)BuiltInRegistries.FLUID.get((ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf)) : null;
        ArrayList<Integer> palette = new ArrayList<Integer>();
        int paletteSize = buf.readVarInt();
        for (int i = 0; i < paletteSize; ++i) {
            palette.add(buf.readInt());
        }
        System.out.println("Material from network: " + String.valueOf(id));
        System.out.println("  Speed: " + speed);
        System.out.println("  Dura: " + dura);
        System.out.println("  Tier: " + tier);
        System.out.println("  Sharp: " + sharp);
        return new MaterialType(id, sortOrder, kbRes, defense, tough, speed, dura, tier, sharp, ench, fireProof, texture, () -> repairIngredient, () -> fluid, palette);
    }

    private static void toNetwork(RegistryFriendlyByteBuf buf, MaterialType type) {
        ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)type.id);
        buf.writeInt(type.sortOrder);
        buf.writeFloat(type.kbRes);
        buf.writeFloat(type.defense);
        buf.writeFloat(type.tough);
        buf.writeFloat(type.speed);
        buf.writeFloat(type.dura);
        buf.writeFloat(type.tier);
        buf.writeFloat(type.sharp);
        buf.writeFloat(type.ench);
        buf.writeBoolean(type.fireProof);
        buf.writeUtf(type.texture);
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)type.repairMaterials.get());
        Fluid fluid = type.moltenFluid.get();
        buf.writeBoolean(fluid != null);
        if (fluid != null) {
            ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)BuiltInRegistries.FLUID.getKey((Object)fluid));
        }
        buf.writeVarInt(type.palette.size());
        for (int color : type.palette) {
            buf.writeInt(color);
        }
    }

    public MaterialType(ResourceLocation id, int sortOrder, float kbRes, float defense, float tough, float speed, float dura, float tier, float sharp, float ench, boolean fireProof, String texture, Ingredient repairIngredient, Optional<ResourceLocation> moltenFluidId, List<Integer> palette) {
        this.dontRegister = id == null || id.getNamespace().isEmpty() || id.getPath().isEmpty() || id.getPath().equals("null") || id.getPath().equals("empty");
        this.id = id;
        this.sortOrder = sortOrder;
        this.kbRes = kbRes;
        this.defense = defense;
        this.tough = tough;
        this.speed = speed;
        this.dura = dura;
        this.tier = tier;
        this.sharp = sharp;
        this.ench = ench;
        this.texture = texture;
        this.fireProof = fireProof;
        this.repairMaterials = () -> repairIngredient;
        this.moltenFluid = () -> moltenFluidId.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).get(arg_0)).orElse(null);
        this.palette = palette;
    }

    public MaterialType(ResourceLocation id, int sortOrder, float kbRes, float defense, float tough, float speed, float dura, float tier, float sharp, float ench, boolean fireProof, String texture, Supplier<Ingredient> repairIngredient, Supplier<Fluid> moltenFluid, List<Integer> palette) {
        this.dontRegister = id == null || id.getNamespace().isEmpty() || id.getPath().isEmpty() || id.getPath().equals("null") || id.getPath().equals("empty");
        this.id = id;
        this.sortOrder = sortOrder;
        this.kbRes = kbRes;
        this.defense = defense;
        this.tough = tough;
        this.speed = speed;
        this.dura = dura;
        this.tier = tier;
        this.sharp = sharp;
        this.ench = ench;
        this.texture = texture;
        this.fireProof = fireProof;
        this.repairMaterials = repairIngredient;
        this.moltenFluid = moltenFluid;
        this.palette = palette;
    }

    public static class Builder {
        private float kbRes = 0.0f;
        private float defense = 0.0f;
        private float tough = 0.0f;
        private float speed = 0.0f;
        private float dura = 0.0f;
        private float tier = 0.0f;
        private float sharp = 0.0f;
        private float ench = 0.0f;
        private boolean fireProof = false;
        private final Supplier<Ingredient> repair;
        private Supplier<Fluid> moltenFluid = () -> null;
        private List<Integer> palette = new ArrayList<Integer>();
        private String texture = "base";
        private final ResourceLocation id;
        private int sortOrder = 0;

        public Builder(ResourceLocation id, Supplier<Ingredient> repairMaterial) {
            this.id = id;
            this.repair = repairMaterial;
        }

        public Builder(String id, Supplier<Ingredient> repairMaterial) {
            this.id = SlagEmbers.loc(id);
            this.repair = repairMaterial;
        }

        public Builder setSortOrder(int value) {
            this.sortOrder = value;
            return this;
        }

        public Builder setKBRes(float value) {
            this.kbRes = Math.max((float)value, (float)0.0f);
            return this;
        }

        public Builder setDefense(float value) {
            this.defense = Math.max((float)value, (float)0.0f);
            return this;
        }

        public Builder setTough(float value) {
            this.tough = Math.max((float)value, (float)0.0f);
            return this;
        }

        public Builder setSpeed(int value) {
            this.speed = Math.max((float)value, (float)0.0f);
            return this;
        }

        public Builder setDura(int value) {
            this.dura = Math.max((float)value, (float)0.0f);
            return this;
        }

        public Builder setTier(int value) {
            this.tier = Math.max((float)value, (float)0.0f);
            return this;
        }

        public Builder setSharp(float value) {
            this.sharp = Math.max((float)value, (float)0.0f);
            return this;
        }

        public Builder setEnch(int value) {
            this.ench = Math.max((float)value, (float)0.0f);
            return this;
        }

        public Builder setTexture(String texture) {
            this.texture = texture;
            return this;
        }

        public Builder moltenFluid(Supplier<Fluid> moltenFluid) {
            this.moltenFluid = moltenFluid;
            return this;
        }

        public Builder fireProof() {
            this.fireProof = true;
            return this;
        }

        public Builder palette(List<Integer> palette) {
            this.palette = palette;
            return this;
        }

        public Builder apply(Function<Builder, Builder> func) {
            return func.apply(this);
        }

        public MaterialType register() {
            return new MaterialType(this.id, this.sortOrder, this.kbRes, this.defense, this.tough, this.speed, this.dura, this.tier, this.sharp, this.ench, this.fireProof, this.texture, this.repair, this.moltenFluid, this.palette);
        }
    }
}

