/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.content.AllUtils;
import dev.lopyluna.slag.content.items.dynamic_part.IDynamicPart;
import dev.lopyluna.slag.content.items.modular.actions.ArmorActions;
import dev.lopyluna.slag.content.items.modular.actions.AxeActions;
import dev.lopyluna.slag.content.items.modular.actions.DisableShieldAction;
import dev.lopyluna.slag.content.items.modular.actions.HarvestActions;
import dev.lopyluna.slag.content.items.modular.actions.HoeActions;
import dev.lopyluna.slag.content.items.modular.actions.PickaxeActions;
import dev.lopyluna.slag.content.items.modular.actions.PlowBlockAction;
import dev.lopyluna.slag.content.items.modular.actions.ShovelActions;
import dev.lopyluna.slag.content.items.modular.actions.StripBlockAction;
import dev.lopyluna.slag.content.items.modular.actions.SwordActions;
import dev.lopyluna.slag.content.items.modular.actions.TillBlockAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ModularType {
    public final ResourceLocation id;
    public final String modelType;
    public final int sortOrder;
    public final TagKey<Item> stations;
    public final List<TagKey<Item>> segments;
    public final List<ItemStack> finalSegmentStacks;
    private final ItemStack resultStack;
    public final List<String> actions;
    public final List<TagKey<Item>> itemTags;
    public boolean dontRegister;
    public static final Codec<ModularType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(m -> m.id), (App)Codec.STRING.optionalFieldOf("model_type", (Object)"").forGetter(m -> m.modelType), (App)Codec.INT.fieldOf("sort_order").forGetter(m -> m.sortOrder), (App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("stations").forGetter(m -> m.stations), (App)TagKey.codec((ResourceKey)Registries.ITEM).listOf().optionalFieldOf("segments", new ArrayList()).forGetter(m -> m.segments), (App)ItemStack.CODEC.listOf().optionalFieldOf("final_segment_stacks", new ArrayList()).forGetter(m -> m.finalSegmentStacks), (App)ItemStack.CODEC.optionalFieldOf("result_stack", (Object)ItemStack.EMPTY).forGetter(m -> m.resultStack), (App)Codec.STRING.listOf().optionalFieldOf("actions", new ArrayList()).forGetter(m -> m.actions), (App)TagKey.codec((ResourceKey)Registries.ITEM).listOf().optionalFieldOf("item_tags", new ArrayList()).forGetter(m -> m.itemTags)).apply((Applicative)instance, ModularType::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ModularType> STREAM_CODEC = StreamCodec.of(ModularType::toNetwork, ModularType::fromNetwork);

    public int hashCode() {
        int actionHash = 0;
        if (this.actions != null && !this.actions.isEmpty()) {
            actionHash = this.actions.hashCode();
        }
        int stationHash = 0;
        if (this.stations != null) {
            stationHash = this.stations.hashCode();
        }
        int resultStackHash = 0;
        if (this.resultStack != null) {
            resultStackHash = this.resultStack.copy().hashCode();
        }
        return 31 * this.id.hashCode() + 31 * actionHash + 31 * stationHash + 31 * this.segmentHash() + 31 * this.finalSegmentStacksHash() + 31 * this.itemTagsHash() + 31 * resultStackHash + Objects.hash(this.modelType, this.sortOrder);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ModularType that = (ModularType)obj;
        return this.id.equals((Object)that.id) && this.modelType.equals(that.modelType) && this.sortOrder == that.sortOrder && this.stations.equals(that.stations) && this.equalSegment(that.segments) && this.equalFinalSegmentStacks(that.finalSegmentStacks) && this.equalItemTags(that.itemTags) && ItemStack.isSameItemSameComponents((ItemStack)this.resultStack, (ItemStack)that.resultStack) && this.actions.equals(that.actions);
    }

    public ItemStack getResultStack() {
        return this.resultStack.copy();
    }

    public static ModularType fromNetwork(RegistryFriendlyByteBuf buf) {
        int itemTagsSize;
        boolean hasResultStack;
        int finalSegmentStacksSize;
        int actionsSize;
        int segmentsSize;
        ResourceLocation id = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf);
        String modelType = buf.readUtf();
        int sorting = buf.readInt();
        TagKey stations = (TagKey)AllUtils.tagKeyStreamCodec(Registries.ITEM).decode((Object)buf);
        boolean hasSegments = buf.readBoolean();
        ArrayList<TagKey<Item>> segments = new ArrayList<TagKey<Item>>();
        if (hasSegments && (segmentsSize = buf.readVarInt()) > 0) {
            for (int i = 0; i < segmentsSize; ++i) {
                segments.add((TagKey)AllUtils.tagKeyStreamCodec(Registries.ITEM).decode((Object)buf));
            }
        }
        boolean hasActions = buf.readBoolean();
        ArrayList<String> actions = new ArrayList<String>();
        if (hasActions && (actionsSize = buf.readVarInt()) > 0) {
            for (int i = 0; i < actionsSize; ++i) {
                actions.add(buf.readUtf());
            }
        }
        boolean hasFinalSegmentStacks = buf.readBoolean();
        ArrayList<ItemStack> finalSegmentStacks = new ArrayList<ItemStack>();
        if (hasFinalSegmentStacks && (finalSegmentStacksSize = buf.readVarInt()) > 0) {
            for (int i = 0; i < finalSegmentStacksSize; ++i) {
                finalSegmentStacks.add((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf));
            }
        }
        ItemStack resultStack = (hasResultStack = buf.readBoolean()) ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf) : ItemStack.EMPTY;
        boolean hasItemTags = buf.readBoolean();
        ArrayList<TagKey<Item>> itemTags = new ArrayList<TagKey<Item>>();
        if (hasItemTags && (itemTagsSize = buf.readVarInt()) > 0) {
            for (int i = 0; i < itemTagsSize; ++i) {
                itemTags.add((TagKey<Item>)((TagKey)AllUtils.tagKeyStreamCodec(Registries.ITEM).decode((Object)buf)));
            }
        }
        return new ModularType(id, modelType, sorting, (TagKey<Item>)stations, segments, finalSegmentStacks, resultStack, actions, itemTags);
    }

    public static void toNetwork(RegistryFriendlyByteBuf buf, ModularType type) {
        ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)type.id);
        buf.writeUtf(type.modelType);
        buf.writeInt(type.sortOrder);
        AllUtils.tagKeyStreamCodec(Registries.ITEM).encode((Object)buf, type.stations);
        buf.writeBoolean(type.segments != null && !type.segments.isEmpty());
        if (type.segments != null && !type.segments.isEmpty()) {
            buf.writeVarInt(type.segments.size());
            for (TagKey<Item> tagKey : type.segments) {
                AllUtils.tagKeyStreamCodec(Registries.ITEM).encode((Object)buf, tagKey);
            }
        }
        buf.writeBoolean(type.actions != null && !type.actions.isEmpty());
        if (type.actions != null && !type.actions.isEmpty()) {
            buf.writeVarInt(type.actions.size());
            for (String string : type.actions) {
                buf.writeUtf(string);
            }
        }
        buf.writeBoolean(type.finalSegmentStacks != null && !type.finalSegmentStacks.isEmpty());
        if (type.finalSegmentStacks != null && !type.finalSegmentStacks.isEmpty()) {
            buf.writeVarInt(type.finalSegmentStacks.size());
            for (ItemStack itemStack : type.finalSegmentStacks) {
                ItemStack.STREAM_CODEC.encode((Object)buf, (Object)itemStack);
            }
        }
        buf.writeBoolean(type.resultStack != null && !type.resultStack.isEmpty());
        if (type.resultStack != null && !type.resultStack.isEmpty()) {
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)type.resultStack);
        }
        buf.writeBoolean(type.itemTags != null && !type.itemTags.isEmpty());
        if (type.itemTags != null && !type.itemTags.isEmpty()) {
            buf.writeVarInt(type.itemTags.size());
            for (TagKey tagKey : type.itemTags) {
                AllUtils.tagKeyStreamCodec(Registries.ITEM).encode((Object)buf, (Object)tagKey);
            }
        }
    }

    private ModularType(ResourceLocation id, String modelType, int sortOrder, TagKey<Item> stations, List<TagKey<Item>> segments, List<ItemStack> finalSegmentStacks, ItemStack resultStack, List<String> actions, List<TagKey<Item>> itemTags) {
        this.dontRegister = id == null || id.getNamespace().isEmpty() || id.getPath().isEmpty() || id.getPath().equals("null") || id.getPath().equals("empty");
        this.id = id;
        this.modelType = modelType;
        this.sortOrder = sortOrder;
        this.stations = stations;
        this.segments = segments;
        this.finalSegmentStacks = finalSegmentStacks;
        this.resultStack = resultStack;
        this.actions = actions;
        this.itemTags = itemTags;
    }

    public static Object doAction(String action, String type, Object ... args) {
        List<Object> argList = Arrays.stream(args).toList();
        return switch (action) {
            case "pickaxe" -> PickaxeActions.INSTANCE.doAction(type, argList);
            case "axe" -> AxeActions.INSTANCE.doAction(type, argList);
            case "shovel" -> ShovelActions.INSTANCE.doAction(type, argList);
            case "hoe" -> HoeActions.INSTANCE.doAction(type, argList);
            case "disableShield" -> DisableShieldAction.INSTANCE.doAction(type, argList);
            case "strip" -> StripBlockAction.INSTANCE.doAction(type, argList);
            case "plow" -> PlowBlockAction.INSTANCE.doAction(type, argList);
            case "till" -> TillBlockAction.INSTANCE.doAction(type, argList);
            case "harvest" -> HarvestActions.INSTANCE.doAction(type, argList);
            case "scythe" -> "scythe";
            case "hammer" -> "hammer";
            case "cutting" -> "cutting";
            case "vein" -> "vein";
            case "sword" -> SwordActions.INSTANCE.doAction(type, argList);
            case "mace" -> "mace";
            case "shield" -> "shield";
            case "bow" -> "bow";
            case "crossbow" -> "crossbow";
            case "throwing" -> "throwing";
            case "arrow" -> "arrow";
            case "trident" -> "trident";
            case "spear" -> "spear";
            case "fishing_rod" -> "fishing_rod";
            case "shears" -> "shears";
            case "flint_and_steel" -> "flint_and_steel";
            case "bucket" -> "bucket";
            case "wrench" -> "wrench";
            case "glide" -> "glide";
            case "helmet" -> ArmorActions.INSTANCE.doAction(type, EquipmentSlot.HEAD, argList);
            case "chestplate" -> ArmorActions.INSTANCE.doAction(type, EquipmentSlot.CHEST, argList);
            case "leggings" -> ArmorActions.INSTANCE.doAction(type, EquipmentSlot.LEGS, argList);
            case "boots" -> ArmorActions.INSTANCE.doAction(type, EquipmentSlot.FEET, argList);
            case "head" -> "head";
            case "body" -> "body";
            case "gloves" -> "gloves";
            case "belt" -> "belt";
            case "foot" -> "foot";
            case "ring" -> "ring";
            case "bracelet" -> "bracelet";
            case "necklace" -> "necklace";
            case "charm" -> "charm";
            default -> null;
        };
    }

    public int segmentHash() {
        int hash = 0;
        if (this.segments != null && !this.segments.isEmpty()) {
            hash = this.segments.hashCode();
            for (TagKey<Item> segment : this.segments) {
                hash += segment.hashCode();
            }
        }
        return hash;
    }

    public int finalSegmentStacksHash() {
        int hash = 0;
        if (this.finalSegmentStacks != null && !this.finalSegmentStacks.isEmpty()) {
            hash = this.finalSegmentStacks.hashCode();
            for (ItemStack stack : this.finalSegmentStacks) {
                hash += stack.hashCode();
            }
        }
        return hash;
    }

    public int itemTagsHash() {
        int hash = 0;
        if (this.itemTags != null && !this.itemTags.isEmpty()) {
            hash = this.itemTags.hashCode();
            for (TagKey<Item> tag : this.itemTags) {
                hash += tag.hashCode();
            }
        }
        return hash;
    }

    public boolean equalSegment(List<TagKey<Item>> other) {
        if (this.segments == null || other == null || this.segments.isEmpty() != other.isEmpty()) {
            return false;
        }
        for (TagKey<Item> segment : other) {
            if (this.segments.contains(segment)) continue;
            return false;
        }
        return this.segments.size() == other.size();
    }

    public boolean equalFinalSegmentStacks(List<ItemStack> other) {
        if (this.finalSegmentStacks == null || other == null || this.finalSegmentStacks.isEmpty() != other.isEmpty()) {
            return false;
        }
        for (ItemStack stack : other) {
            if (this.containsStack(stack)) continue;
            return false;
        }
        return this.finalSegmentStacks.size() == other.size();
    }

    public boolean equalItemTags(List<TagKey<Item>> other) {
        if (this.itemTags == null || other == null || this.itemTags.isEmpty() != other.isEmpty()) {
            return false;
        }
        for (TagKey<Item> tag : other) {
            if (this.itemTags.contains(tag)) continue;
            return false;
        }
        return this.itemTags.size() == other.size();
    }

    public boolean containsStack(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        for (ItemStack finalStack : this.finalSegmentStacks) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)finalStack, (ItemStack)stack) || stack.getCount() != finalStack.getCount()) continue;
            return true;
        }
        return false;
    }

    public boolean containsTag(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof IDynamicPart)) {
            return false;
        }
        IDynamicPart part = (IDynamicPart)item;
        TagKey<Item> partSegment = part.getPartSegment(stack);
        for (TagKey<Item> segment : this.segments) {
            if (!partSegment.equals(segment)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ItemStack stack) {
        if (this.containsTag(stack)) {
            return true;
        }
        return !(stack.getItem() instanceof IDynamicPart) && this.containsStack(stack);
    }

    public boolean containsItemTag(TagKey<Item> tag) {
        for (TagKey<Item> itemTag : this.itemTags) {
            if (!itemTag.equals(tag) && !itemTag.location().equals((Object)tag.location())) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        private final ResourceLocation id;
        private String modelType = "";
        private int sortOrder;
        private TagKey<Item> stations;
        private List<TagKey<Item>> segments = new ArrayList<TagKey<Item>>();
        private List<ItemStack> finalSegmentStacks = new ArrayList<ItemStack>();
        private ItemStack resultStack;
        private List<String> actions = new ArrayList<String>();
        private List<TagKey<Item>> itemTags = new ArrayList<TagKey<Item>>();

        public Builder(ResourceLocation id) {
            this.id = id;
        }

        public Builder(String id) {
            this.id = SlagEmbers.loc(id);
        }

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        public Builder sortOrder(int sorting) {
            this.sortOrder = sorting;
            return this;
        }

        public Builder stations(TagKey<Item> stations) {
            this.stations = stations;
            return this;
        }

        public Builder segments(List<TagKey<Item>> segments) {
            this.segments = segments;
            return this;
        }

        @SafeVarargs
        public final Builder segments(TagKey<Item> ... segments) {
            this.segments = List.of(segments);
            return this;
        }

        public Builder addSegment(TagKey<Item> segment) {
            this.segments.add(segment);
            return this;
        }

        public Builder addSegments(List<TagKey<Item>> segments) {
            this.segments.addAll(segments);
            return this;
        }

        @SafeVarargs
        public final Builder addSegments(TagKey<Item> ... segments) {
            this.segments.addAll(List.of(segments));
            return this;
        }

        public Builder rodCount(int rodCount) {
            return this.addSegmentStack(Items.STICK, rodCount);
        }

        public Builder segmentStacks(List<ItemStack> finalSegmentStacks) {
            this.finalSegmentStacks = finalSegmentStacks;
            return this;
        }

        public Builder segmentStacksFromItems(List<Item> finalSegmentStacks) {
            this.finalSegmentStacks = finalSegmentStacks.stream().map(ItemStack::new).toList();
            return this;
        }

        public Builder segmentStacksFromItems(int count, List<Item> finalSegmentStacks) {
            this.finalSegmentStacks = finalSegmentStacks.stream().map(item -> new ItemStack((ItemLike)item, count)).toList();
            return this;
        }

        public final Builder segmentStacks(ItemStack ... finalSegmentStacks) {
            this.finalSegmentStacks = List.of(finalSegmentStacks);
            return this;
        }

        public final Builder segmentStacksFromItems(Item ... finalSegmentStacks) {
            this.finalSegmentStacks = Stream.of(finalSegmentStacks).map(ItemStack::new).toList();
            return this;
        }

        public final Builder segmentStacksFromItems(int count, Item ... finalSegmentStacks) {
            this.finalSegmentStacks = Stream.of(finalSegmentStacks).map(item -> new ItemStack((ItemLike)item, count)).toList();
            return this;
        }

        public Builder addSegmentStack(ItemStack finalSegmentStack) {
            this.finalSegmentStacks.add(finalSegmentStack);
            return this;
        }

        public Builder addSegmentStack(Item finalSegmentStack) {
            this.finalSegmentStacks.add(new ItemStack((ItemLike)finalSegmentStack));
            return this;
        }

        public Builder addSegmentStack(Item finalSegmentStack, int count) {
            this.finalSegmentStacks.add(new ItemStack((ItemLike)finalSegmentStack, count));
            return this;
        }

        public Builder addSegmentStacks(List<ItemStack> finalSegmentStacks) {
            this.finalSegmentStacks.addAll(finalSegmentStacks);
            return this;
        }

        public Builder addSegmentStacksFromItems(List<Item> finalSegmentStacks) {
            this.finalSegmentStacks.addAll(finalSegmentStacks.stream().map(ItemStack::new).toList());
            return this;
        }

        public Builder addSegmentStacksFromItems(int count, List<Item> finalSegmentStacks) {
            this.finalSegmentStacks.addAll(finalSegmentStacks.stream().map(item -> new ItemStack((ItemLike)item, count)).toList());
            return this;
        }

        public final Builder addSegmentStacks(ItemStack ... finalSegmentStacks) {
            this.finalSegmentStacks.addAll(List.of(finalSegmentStacks));
            return this;
        }

        public final Builder addSegmentStacksFromItems(Item ... finalSegmentStacks) {
            this.finalSegmentStacks.addAll(Stream.of(finalSegmentStacks).map(ItemStack::new).toList());
            return this;
        }

        public final Builder addSegmentStacksFromItems(int count, Item ... finalSegmentStacks) {
            this.finalSegmentStacks.addAll(Stream.of(finalSegmentStacks).map(item -> new ItemStack((ItemLike)item, count)).toList());
            return this;
        }

        public Builder resultStack(ItemStack resultStack) {
            this.resultStack = resultStack;
            return this;
        }

        public Builder resultStack(Item resultStack) {
            this.resultStack = new ItemStack((ItemLike)resultStack);
            return this;
        }

        public Builder resultStack(Item resultStack, int count) {
            this.resultStack = new ItemStack((ItemLike)resultStack, count);
            return this;
        }

        public Builder actions(List<String> actions) {
            this.actions = actions;
            return this;
        }

        public Builder actions(String ... actions) {
            this.actions = List.of(actions);
            return this;
        }

        public Builder addAction(String action) {
            this.actions.add(action);
            return this;
        }

        public Builder addActions(List<String> actions) {
            this.actions.addAll(actions);
            return this;
        }

        public Builder addActions(String ... actions) {
            this.actions.addAll(List.of(actions));
            return this;
        }

        public Builder itemTags(List<TagKey<Item>> itemTags) {
            this.itemTags = itemTags;
            return this;
        }

        @SafeVarargs
        public final Builder itemTags(TagKey<Item> ... itemTags) {
            this.itemTags = List.of(itemTags);
            return this;
        }

        public Builder addItemTag(TagKey<Item> itemTag) {
            this.itemTags.add(itemTag);
            return this;
        }

        public Builder addItemTags(List<TagKey<Item>> itemTags) {
            this.itemTags.addAll(itemTags);
            return this;
        }

        @SafeVarargs
        public final Builder addItemTags(TagKey<Item> ... itemTags) {
            this.itemTags.addAll(List.of(itemTags));
            return this;
        }

        public ModularType register() {
            return new ModularType(this.id, this.modelType, this.sortOrder, this.stations, this.segments, this.finalSegmentStacks, this.resultStack == null ? ItemStack.EMPTY : this.resultStack, this.actions, this.itemTags);
        }
    }
}

