/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.content.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import org.joml.Vector3d;
import org.joml.Vector4d;
import org.lwjgl.opengl.GL14;

public class ColorUtils {
    public static Color toBlend(Color valueA, Color valueB, ColorBlendType type) {
        return valueA.toBlend(valueB, type);
    }

    public static abstract class Color {
        public abstract int toHex();

        public abstract String toHexString();

        public abstract Vector3d toVec3();

        public abstract Vector4d toVec4();

        public abstract RYB toRYB();

        public abstract RYBA toRYBA();

        public abstract RGB toRGB();

        public abstract RGBA toRGBA();

        public abstract HSV toHSV();

        public abstract HSVA toHSVA();

        public abstract HSL toHSL();

        public abstract HSLA toHSLA();

        public abstract HWB toHWB();

        public abstract HWBA toHWBA();

        public abstract CMYK toCMYK();

        public abstract CMYKA toCMYKA();

        public abstract String toShortString();

        public abstract String toShortString255();

        public abstract String toString();

        public abstract String toString255();

        public abstract boolean equal(Color var1);

        public Color toBlend(Color value, ColorBlendType type) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.toAverage(value);
                case 1 -> this.toMerge(value);
                case 2 -> this.toAdd(value);
                case 3 -> this.toSubtract(value);
                case 4 -> this.toMultiply(value);
                case 5 -> this.toDivide(value);
                case 6 -> this.toScreen(value);
                case 7 -> this.toOverlay(value);
                case 8 -> this.toDarken(value);
                case 9 -> this.toLighten(value);
                case 10 -> this.toDifference(value);
                case 11 -> this.toNegation(value);
                case 12 -> this.toInvert();
                case 13 -> this.toInvertColor();
                case 14 -> this.toInvertShade();
                case 15 -> this.toInvertHue();
                case 16 -> this.toExclusion(value);
                case 17 -> this.toHardLight(value);
                case 18 -> this.toSoftLight(value);
                case 19 -> this.toColorBurn(value);
                case 20 -> this.toColorDodge(value);
                case 21 -> this.toGlow(value);
                case 22 -> this.toReflect(value);
                case 23 -> this.toXor(value);
                case 24 -> this.toVividLight(value);
                case 25 -> this.toLinearLight(value);
                case 26 -> this.toPinLight(value);
            };
        }

        private Color toAverage(Color value) {
            if (value == null) {
                return this;
            }
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            double rN = (aC.r + bC.r) / 2.0;
            double gN = (aC.g + bC.g) / 2.0;
            double bN = (aC.b + bC.b) / 2.0;
            double aN = (aC.a + bC.a) / 2.0;
            return new RGBA(rN, gN, bN, aN);
        }

        private Color toMerge(Color value) {
            if (value == null) {
                return this;
            }
            RGBA src = value.toRGBA();
            RGBA dst = this.toRGBA();
            double outA = src.a + dst.a * (1.0 - src.a);
            if (outA < 1.0E-6) {
                return new RGBA(0.0, 0.0, 0.0, 0.0);
            }
            double outR = (src.r * src.a + dst.r * dst.a * (1.0 - src.a)) / outA;
            double outG = (src.g * src.a + dst.g * dst.a * (1.0 - src.a)) / outA;
            double outB = (src.b * src.a + dst.b * dst.a * (1.0 - src.a)) / outA;
            return new RGBA(outR, outG, outB, outA);
        }

        private Color toAdd(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            double rN = Math.min(1.0, aC.r + bC.r);
            double gN = Math.min(1.0, aC.g + bC.g);
            double bN = Math.min(1.0, aC.b + bC.b);
            double aN = Math.min(1.0, aC.a + bC.a);
            return new RGBA(rN, gN, bN, aN);
        }

        private Color toSubtract(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            double rN = Math.max(0.0, aC.r - bC.r);
            double gN = Math.max(0.0, aC.g - bC.g);
            double bN = Math.max(0.0, aC.b - bC.b);
            double aN = Math.max(0.0, aC.a - bC.a);
            return new RGBA(rN, gN, bN, aN);
        }

        private Color toMultiply(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            double rN = aC.r * bC.r;
            double gN = aC.g * bC.g;
            double bN = aC.b * bC.b;
            double aN = aC.a * bC.a;
            return new RGBA(rN, gN, bN, aN);
        }

        private Color toDivide(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            double rN = bC.r == 0.0 ? 1.0 : aC.r / bC.r;
            double gN = bC.g == 0.0 ? 1.0 : aC.g / bC.g;
            double bN = bC.b == 0.0 ? 1.0 : aC.b / bC.b;
            double aN = bC.a == 0.0 ? 1.0 : aC.a / bC.a;
            rN = Math.max(0.0, Math.min(1.0, rN));
            gN = Math.max(0.0, Math.min(1.0, gN));
            bN = Math.max(0.0, Math.min(1.0, bN));
            aN = Math.max(0.0, Math.min(1.0, aN));
            return new RGBA(rN, gN, bN, aN);
        }

        private Color toScreen(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            double rN = 1.0 - (1.0 - aC.r) * (1.0 - bC.r);
            double gN = 1.0 - (1.0 - aC.g) * (1.0 - bC.g);
            double bN = 1.0 - (1.0 - aC.b) * (1.0 - bC.b);
            double aN = 1.0 - (1.0 - aC.a) * (1.0 - bC.a);
            return new RGBA(rN, gN, bN, aN);
        }

        private Color toOverlay(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            double rN = aC.r < 0.5 ? 2.0 * aC.r * bC.r : 1.0 - 2.0 * (1.0 - aC.r) * (1.0 - bC.r);
            double gN = aC.g < 0.5 ? 2.0 * aC.g * bC.g : 1.0 - 2.0 * (1.0 - aC.g) * (1.0 - bC.g);
            double bN = aC.b < 0.5 ? 2.0 * aC.b * bC.b : 1.0 - 2.0 * (1.0 - aC.b) * (1.0 - bC.b);
            double aN = aC.a < 0.5 ? 2.0 * aC.a * bC.a : 1.0 - 2.0 * (1.0 - aC.a) * (1.0 - bC.a);
            return new RGBA(rN, gN, bN, aN);
        }

        private Color toDarken(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            return new RGBA(Math.min(aC.r, bC.r), Math.min(aC.g, bC.g), Math.min(aC.b, bC.b), Math.min(aC.a, bC.a));
        }

        private Color toLighten(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            return new RGBA(Math.max(aC.r, bC.r), Math.max(aC.g, bC.g), Math.max(aC.b, bC.b), Math.max(aC.a, bC.a));
        }

        private Color toDifference(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            return new RGBA(Math.abs(aC.r - bC.r), Math.abs(aC.g - bC.g), Math.abs(aC.b - bC.b), Math.abs(aC.a - bC.a));
        }

        private Color toNegation(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            return new RGBA(1.0 - Math.abs(1.0 - aC.r - bC.r), 1.0 - Math.abs(1.0 - aC.g - bC.g), 1.0 - Math.abs(1.0 - aC.b - bC.b), 1.0 - Math.abs(1.0 - aC.a - bC.a));
        }

        private Color toInvert() {
            RGBA aC = this.toRGBA();
            return new RGBA(1.0 - aC.r, 1.0 - aC.g, 1.0 - aC.b, aC.a);
        }

        private Color toInvertColor() {
            RGBA aC = this.toRGBA();
            return new RGBA(1.0 - aC.r, 1.0 - aC.g, 1.0 - aC.b, 1.0 - aC.a);
        }

        private Color toInvertShade() {
            RGB rgb = this.toRGB();
            double gray = (rgb.r + rgb.g + rgb.b) / 3.0;
            double inv = 1.0 - gray;
            double factor = gray == 0.0 ? 0.0 : inv / gray;
            return new RGBA(Math.max(0.0, Math.min(1.0, rgb.r * factor)), Math.max(0.0, Math.min(1.0, rgb.g * factor)), Math.max(0.0, Math.min(1.0, rgb.b * factor)), this.toRGBA().a);
        }

        private Color toInvertHue() {
            HSV hsv = this.toHSV();
            double newHue = (hsv.h + 180.0) % 360.0;
            HSV inverted = new HSV(newHue, hsv.s, hsv.v);
            RGBA out = inverted.toRGBA();
            out.a = this.toRGBA().a;
            return out;
        }

        private Color toExclusion(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            return new RGBA(aC.r + bC.r - 2.0 * aC.r * bC.r, aC.g + bC.g - 2.0 * aC.g * bC.g, aC.b + bC.b - 2.0 * aC.b * bC.b, aC.a + bC.a - 2.0 * aC.a * bC.a);
        }

        private Color toHardLight(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            double r = bC.r < 0.5 ? 2.0 * aC.r * bC.r : 1.0 - 2.0 * (1.0 - aC.r) * (1.0 - bC.r);
            double g = bC.g < 0.5 ? 2.0 * aC.g * bC.g : 1.0 - 2.0 * (1.0 - aC.g) * (1.0 - bC.g);
            double b = bC.b < 0.5 ? 2.0 * aC.b * bC.b : 1.0 - 2.0 * (1.0 - aC.b) * (1.0 - bC.b);
            double a = bC.a < 0.5 ? 2.0 * aC.a * bC.a : 1.0 - 2.0 * (1.0 - aC.a) * (1.0 - bC.a);
            return new RGBA(r, g, b, a);
        }

        private Color toSoftLight(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            double r = bC.r < 0.5 ? aC.r - (1.0 - 2.0 * bC.r) * aC.r * (1.0 - aC.r) : aC.r + (2.0 * bC.r - 1.0) * (Math.sqrt(aC.r) - aC.r);
            double g = bC.g < 0.5 ? aC.g - (1.0 - 2.0 * bC.g) * aC.g * (1.0 - aC.g) : aC.g + (2.0 * bC.g - 1.0) * (Math.sqrt(aC.g) - aC.g);
            double b = bC.b < 0.5 ? aC.b - (1.0 - 2.0 * bC.b) * aC.b * (1.0 - aC.b) : aC.b + (2.0 * bC.b - 1.0) * (Math.sqrt(aC.b) - aC.b);
            double a = bC.a < 0.5 ? aC.a - (1.0 - 2.0 * bC.a) * aC.a * (1.0 - aC.a) : aC.a + (2.0 * bC.a - 1.0) * (Math.sqrt(aC.a) - aC.a);
            return new RGBA(r, g, b, a);
        }

        private Color toColorBurn(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            double r = bC.r == 0.0 ? 0.0 : 1.0 - Math.min(1.0, (1.0 - aC.r) / bC.r);
            double g = bC.g == 0.0 ? 0.0 : 1.0 - Math.min(1.0, (1.0 - aC.g) / bC.g);
            double b = bC.b == 0.0 ? 0.0 : 1.0 - Math.min(1.0, (1.0 - aC.b) / bC.b);
            double a = bC.a == 0.0 ? 0.0 : 1.0 - Math.min(1.0, (1.0 - aC.a) / bC.a);
            return new RGBA(r, g, b, a);
        }

        private Color toColorDodge(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            double r = bC.r == 1.0 ? 1.0 : Math.min(1.0, aC.r / (1.0 - bC.r));
            double g = bC.g == 1.0 ? 1.0 : Math.min(1.0, aC.g / (1.0 - bC.g));
            double b = bC.b == 1.0 ? 1.0 : Math.min(1.0, aC.b / (1.0 - bC.b));
            double a = bC.a == 1.0 ? 1.0 : Math.min(1.0, aC.a / (1.0 - bC.a));
            return new RGBA(r, g, b, a);
        }

        private Color toGlow(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            double r = aC.r == 1.0 ? 1.0 : Math.min(1.0, bC.r / (1.0 - aC.r));
            double g = aC.g == 1.0 ? 1.0 : Math.min(1.0, bC.g / (1.0 - aC.g));
            double b = aC.b == 1.0 ? 1.0 : Math.min(1.0, bC.b / (1.0 - aC.b));
            double a = aC.a == 1.0 ? 1.0 : Math.min(1.0, bC.a / (1.0 - aC.a));
            return new RGBA(r, g, b, a);
        }

        private Color toReflect(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            double r = bC.r == 0.0 ? 0.0 : Math.min(1.0, aC.r * aC.r / (1.0 - bC.r));
            double g = bC.g == 0.0 ? 0.0 : Math.min(1.0, aC.g * aC.g / (1.0 - bC.g));
            double b = bC.b == 0.0 ? 0.0 : Math.min(1.0, aC.b * aC.b / (1.0 - bC.b));
            double a = bC.a == 0.0 ? 0.0 : Math.min(1.0, aC.a * aC.a / (1.0 - bC.a));
            return new RGBA(r, g, b, a);
        }

        private Color toXor(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            double r = (aC.r + bC.r) % 1.0;
            double g = (aC.g + bC.g) % 1.0;
            double b = (aC.b + bC.b) % 1.0;
            double a = (aC.a + bC.a) % 1.0;
            return new RGBA(r, g, b, a);
        }

        private Color toVividLight(Color value) {
            double b;
            double g;
            double r;
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            double d = bC.r < 0.5 ? (bC.r == 0.0 ? 0.0 : 1.0 - Math.min(1.0, (1.0 - aC.r) / (2.0 * bC.r))) : (r = bC.r == 1.0 ? 1.0 : Math.min(1.0, aC.r / (2.0 * (1.0 - bC.r))));
            double d2 = bC.g < 0.5 ? (bC.g == 0.0 ? 0.0 : 1.0 - Math.min(1.0, (1.0 - aC.g) / (2.0 * bC.g))) : (g = bC.g == 1.0 ? 1.0 : Math.min(1.0, aC.g / (2.0 * (1.0 - bC.g))));
            double d3 = bC.b < 0.5 ? (bC.b == 0.0 ? 0.0 : 1.0 - Math.min(1.0, (1.0 - aC.b) / (2.0 * bC.b))) : (b = bC.b == 1.0 ? 1.0 : Math.min(1.0, aC.b / (2.0 * (1.0 - bC.b))));
            double a = bC.a < 0.5 ? (bC.a == 0.0 ? 0.0 : 1.0 - Math.min(1.0, (1.0 - aC.a) / (2.0 * bC.a))) : (bC.a == 1.0 ? 1.0 : Math.min(1.0, aC.a / (2.0 * (1.0 - bC.a))));
            return new RGBA(r, g, b, a);
        }

        private Color toLinearLight(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            double r = aC.r + 2.0 * bC.r - 1.0;
            double g = aC.g + 2.0 * bC.g - 1.0;
            double b = aC.b + 2.0 * bC.b - 1.0;
            double a = aC.a + 2.0 * bC.a - 1.0;
            r = Math.max(0.0, Math.min(1.0, r));
            g = Math.max(0.0, Math.min(1.0, g));
            b = Math.max(0.0, Math.min(1.0, b));
            a = Math.max(0.0, Math.min(1.0, a));
            return new RGBA(r, g, b, a);
        }

        private Color toPinLight(Color value) {
            RGBA aC = this.toRGBA();
            RGBA bC = value.toRGBA();
            double r = bC.r < 0.5 ? Math.min(aC.r, 2.0 * bC.r) : Math.max(aC.r, 2.0 * bC.r - 1.0);
            double g = bC.g < 0.5 ? Math.min(aC.g, 2.0 * bC.g) : Math.max(aC.g, 2.0 * bC.g - 1.0);
            double b = bC.b < 0.5 ? Math.min(aC.b, 2.0 * bC.b) : Math.max(aC.b, 2.0 * bC.b - 1.0);
            double a = bC.a < 0.5 ? Math.min(aC.a, 2.0 * bC.a) : Math.max(aC.a, 2.0 * bC.a - 1.0);
            r = Math.max(0.0, Math.min(1.0, r));
            g = Math.max(0.0, Math.min(1.0, g));
            b = Math.max(0.0, Math.min(1.0, b));
            a = Math.max(0.0, Math.min(1.0, a));
            return new RGBA(r, g, b, a);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Color) {
                Color color = (Color)obj;
                return this.equal(color);
            }
            return false;
        }
    }

    public static enum ColorBlendType {
        AVERAGE,
        BLEND,
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        SCREEN,
        OVERLAY,
        DARKEN,
        LIGHTEN,
        DIFFERENCE,
        NEGATION,
        INVERT,
        INVERT_COLOR,
        INVERT_SHADE,
        INVERT_HUE,
        EXCLUSION,
        HARD_LIGHT,
        SOFT_LIGHT,
        COLOR_BURN,
        COLOR_DODGE,
        GLOW,
        REFLECT,
        XOR,
        VIVID_LIGHT,
        LINEAR_LIGHT,
        PIN_LIGHT;

    }

    public static final class ColorRenderTypes {
        private static final Map<ColorBlendType, RenderType> TYPES = new EnumMap<ColorBlendType, RenderType>(ColorBlendType.class);

        public static void init() {
            TYPES.put(ColorBlendType.BLEND, ColorRenderTypes.rt("blend", RenderStateShard.TRANSLUCENT_TRANSPARENCY));
            ColorRenderTypes.putCustom(ColorBlendType.ADD, () -> RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE));
            ColorRenderTypes.putCustom(ColorBlendType.MULTIPLY, () -> RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA));
            ColorRenderTypes.putCustom(ColorBlendType.SCREEN, () -> RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA));
            ColorRenderTypes.putCustom(ColorBlendType.GLOW, () -> {
                RenderSystem.blendEquation((int)32774);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }, () -> RenderSystem.blendEquation((int)32774));
            ColorRenderTypes.putCustom(ColorBlendType.SUBTRACT, () -> {
                RenderSystem.blendEquation((int)32779);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }, () -> RenderSystem.blendEquation((int)32774));
            ColorRenderTypes.putCustom(ColorBlendType.DARKEN, () -> {
                RenderSystem.blendEquation((int)32775);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }, () -> RenderSystem.blendEquation((int)32774));
            ColorRenderTypes.putCustom(ColorBlendType.LIGHTEN, () -> {
                RenderSystem.blendEquation((int)32776);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }, () -> RenderSystem.blendEquation((int)32774));
            ColorRenderTypes.putCustom(ColorBlendType.AVERAGE, () -> {
                RenderSystem.blendEquation((int)32774);
                GL14.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.CONSTANT_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_CONSTANT_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }, () -> {
                GL14.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                RenderSystem.blendEquation((int)32774);
            });
            ColorRenderTypes.putCustom(ColorBlendType.XOR, () -> {
                RenderSystem.blendEquation((int)32774);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            });
            ColorRenderTypes.putCustom(ColorBlendType.INVERT, () -> {
                RenderSystem.blendEquation((int)32774);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            });
        }

        public static RenderType get(ColorBlendType type) {
            return TYPES.getOrDefault((Object)type, TYPES.get((Object)ColorBlendType.BLEND));
        }

        private static void putCustom(ColorBlendType t, Runnable blendFunc) {
            TYPES.put(t, ColorRenderTypes.rt("cm_" + t.name().toLowerCase(), ColorRenderTypes.rt(t.name().toLowerCase() + "_transparency", blendFunc)));
        }

        private static void putCustom(ColorBlendType t, Runnable blendFuncPre, Runnable blendFuncPost) {
            TYPES.put(t, ColorRenderTypes.rt("cm_" + t.name().toLowerCase(), ColorRenderTypes.rt(t.name().toLowerCase() + "_transparency", blendFuncPre, blendFuncPost)));
        }

        private static RenderStateShard.TransparencyStateShard rt(String name, Runnable blendFuncPre, Runnable blendFuncPost) {
            return new RenderStateShard.TransparencyStateShard(name, () -> {
                RenderSystem.enableBlend();
                blendFuncPre.run();
            }, () -> {
                blendFuncPost.run();
                RenderSystem.disableBlend();
                RenderSystem.defaultBlendFunc();
            });
        }

        private static RenderStateShard.TransparencyStateShard rt(String name, Runnable blendFunc) {
            return new RenderStateShard.TransparencyStateShard(name, () -> {
                RenderSystem.enableBlend();
                blendFunc.run();
            }, () -> {
                RenderSystem.disableBlend();
                RenderSystem.defaultBlendFunc();
            });
        }

        private static RenderType rt(String name, RenderStateShard.TransparencyStateShard transparency) {
            return RenderType.create((String)("color_" + name), (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x400000, (boolean)true, (boolean)true, (RenderType.CompositeState)ColorRenderTypes.translucentState(transparency));
        }

        private static RenderType.CompositeState translucentState(RenderStateShard.TransparencyStateShard transparency) {
            return RenderType.CompositeState.builder().setLightmapState(RenderStateShard.LIGHTMAP).setShaderState(RenderStateShard.RENDERTYPE_TRANSLUCENT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.BLOCK_SHEET_MIPPED).setTransparencyState(transparency).setOutputState(RenderStateShard.TRANSLUCENT_TARGET).setCullState(RenderStateShard.NO_CULL).createCompositeState(true);
        }
    }

    public static class RGBA
    extends RGB {
        public double a;

        public RGBA(double r, double g, double b, double a) {
            super(r, g, b);
            this.a = a;
        }

        @Override
        public int toHex() {
            int rI = (int)Math.round(this.r * 255.0);
            int gI = (int)Math.round(this.g * 255.0);
            int bI = (int)Math.round(this.b * 255.0);
            int aI = (int)Math.round(this.a * 255.0);
            return aI << 24 | rI << 16 | gI << 8 | bI;
        }

        @Override
        public String toHexString() {
            return String.format("#%02X%02X%02X%02X", (int)(this.a * 255.0), (int)(this.r * 255.0), (int)(this.g * 255.0), (int)(this.b * 255.0));
        }

        @Override
        public Vector4d toVec4() {
            return new Vector4d(this.r, this.g, this.b, this.a);
        }

        @Override
        public RGB toRGB() {
            return new RGB(this.r, this.g, this.b);
        }

        @Override
        public RGBA toRGBA() {
            return this;
        }

        @Override
        public RYBA toRYBA() {
            RYB ryb = super.toRYB();
            return new RYBA(ryb.r, ryb.y, ryb.b, this.a);
        }

        @Override
        public HSVA toHSVA() {
            HSV hsv = super.toHSV();
            return new HSVA(hsv.h, hsv.s, hsv.v, this.a);
        }

        @Override
        public HSLA toHSLA() {
            HSL hsl = super.toHSL();
            return new HSLA(hsl.h, hsl.s, hsl.l, this.a);
        }

        @Override
        public HWBA toHWBA() {
            HWB hwb = super.toHWB();
            return new HWBA(hwb.h, hwb.w, hwb.b, this.a);
        }

        @Override
        public CMYKA toCMYKA() {
            CMYK cmyk = super.toCMYK();
            return new CMYKA(cmyk.c, cmyk.m, cmyk.y, cmyk.k, this.a);
        }

        @Override
        public String toShortString() {
            return String.format("r%.2f, g%.2f, b%.2f, a%.2f", this.r, this.g, this.b, this.a);
        }

        @Override
        public String toShortString255() {
            return String.format("r%d, g%d, b%d, a%d", (int)(this.r * 255.0), (int)(this.g * 255.0), (int)(this.b * 255.0), (int)(this.a * 255.0));
        }

        @Override
        public String toString() {
            return String.format("Red %.3f, Green %.3f, Blue %.3f, Alpha %.3f", this.r, this.g, this.b, this.a);
        }

        @Override
        public String toString255() {
            return String.format("Red %d, Green %d, Blue %d, Alpha %d", (int)(this.r * 255.0), (int)(this.g * 255.0), (int)(this.b * 255.0), (int)(this.a * 255.0));
        }

        @Override
        public boolean equal(Color other) {
            if (other == null) {
                return false;
            }
            RGBA aC = this.toRGBA();
            RGBA bC = other.toRGBA();
            return Math.abs(aC.r - bC.r) < 1.0E-6 && Math.abs(aC.g - bC.g) < 1.0E-6 && Math.abs(aC.b - bC.b) < 1.0E-6 && Math.abs(aC.a - bC.a) < 1.0E-6;
        }
    }

    public static class RGB
    extends Color {
        public double r;
        public double g;
        public double b;

        public RGB(double r, double g, double b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        @Override
        public int toHex() {
            int r = (int)Math.round(this.r * 255.0);
            int g = (int)Math.round(this.g * 255.0);
            int b = (int)Math.round(this.b * 255.0);
            return r << 16 | g << 8 | b;
        }

        @Override
        public String toHexString() {
            return String.format("#%02X%02X%02X", (int)(this.r * 255.0), (int)(this.g * 255.0), (int)(this.b * 255.0));
        }

        @Override
        public Vector3d toVec3() {
            return new Vector3d(this.r, this.g, this.b);
        }

        @Override
        public Vector4d toVec4() {
            return new Vector4d(this.r, this.g, this.b, 1.0);
        }

        @Override
        public RGB toRGB() {
            return this;
        }

        @Override
        public RGBA toRGBA() {
            return new RGBA(this.r, this.g, this.b, 1.0);
        }

        @Override
        public String toShortString() {
            return String.format("r%.2f, g%.2f, b%.2f", this.r, this.g, this.b);
        }

        @Override
        public String toShortString255() {
            return String.format("r%d, g%d, b%d", (int)(this.r * 255.0), (int)(this.g * 255.0), (int)(this.b * 255.0));
        }

        @Override
        public String toString() {
            return String.format("Red %.3f, Green %.3f, Blue %.3f", this.r, this.g, this.b);
        }

        @Override
        public String toString255() {
            return String.format("Red %d, Green %d, Blue %d", (int)(this.r * 255.0), (int)(this.g * 255.0), (int)(this.b * 255.0));
        }

        @Override
        public boolean equal(Color other) {
            if (other == null) {
                return false;
            }
            RGBA a = this.toRGBA();
            RGBA b = other.toRGBA();
            return Math.abs(a.r - b.r) < 1.0E-6 && Math.abs(a.g - b.g) < 1.0E-6 && Math.abs(a.b - b.b) < 1.0E-6 && Math.abs(a.a - b.a) < 1.0E-6;
        }

        @Override
        public RYB toRYB() {
            double Y = Math.min(this.r, this.g);
            this.r -= Y;
            this.g -= Y;
            double B = Math.min(this.g, this.b);
            this.g -= B;
            this.b -= B;
            double R = this.r;
            return new RYB(R, Y += this.g, B += this.b);
        }

        @Override
        public RYBA toRYBA() {
            RYB c = this.toRYB();
            return new RYBA(c.r, c.y, c.b, 1.0);
        }

        @Override
        public HSV toHSV() {
            double min;
            double max = Math.max(this.r, Math.max(this.g, this.b));
            double delta = max - (min = Math.min(this.r, Math.min(this.g, this.b)));
            double h = delta == 0.0 ? 0.0 : (max == this.r ? 60.0 * ((this.g - this.b) / delta % 6.0) : (max == this.g ? 60.0 * ((this.b - this.r) / delta + 2.0) : 60.0 * ((this.r - this.g) / delta + 4.0)));
            if (h < 0.0) {
                h += 360.0;
            }
            double s = max == 0.0 ? 0.0 : delta / max;
            return new HSV(h, s, max);
        }

        @Override
        public HSVA toHSVA() {
            HSV c = this.toHSV();
            return new HSVA(c.h, c.s, c.v, 1.0);
        }

        @Override
        public HSL toHSL() {
            double min;
            double max = Math.max(this.r, Math.max(this.g, this.b));
            double delta = max - (min = Math.min(this.r, Math.min(this.g, this.b)));
            double h = delta == 0.0 ? 0.0 : (max == this.r ? 60.0 * ((this.g - this.b) / delta % 6.0) : (max == this.g ? 60.0 * ((this.b - this.r) / delta + 2.0) : 60.0 * ((this.r - this.g) / delta + 4.0)));
            if (h < 0.0) {
                h += 360.0;
            }
            double l = (max + min) / 2.0;
            double s = delta == 0.0 ? 0.0 : delta / (1.0 - Math.abs(2.0 * l - 1.0));
            return new HSL(h, s, l);
        }

        @Override
        public HSLA toHSLA() {
            HSL c = this.toHSL();
            return new HSLA(c.h, c.s, c.l, 1.0);
        }

        @Override
        public HWB toHWB() {
            HSV hsv = this.toHSV();
            double w = Math.min(this.r, Math.min(this.g, this.b));
            double bl = 1.0 - Math.max(this.r, Math.max(this.g, this.b));
            return new HWB(hsv.h, w, bl);
        }

        @Override
        public HWBA toHWBA() {
            HWB c = this.toHWB();
            return new HWBA(c.h, c.w, c.b, 1.0);
        }

        @Override
        public CMYK toCMYK() {
            double k = 1.0 - Math.max(this.r, Math.max(this.g, this.b));
            if (k >= 1.0) {
                return new CMYK(0.0, 0.0, 0.0, 1.0);
            }
            double c = (1.0 - this.r - k) / (1.0 - k);
            double m = (1.0 - this.g - k) / (1.0 - k);
            double y = (1.0 - this.b - k) / (1.0 - k);
            return new CMYK(c, m, y, k);
        }

        @Override
        public CMYKA toCMYKA() {
            CMYK c = this.toCMYK();
            return new CMYKA(c.c, c.m, c.y, c.k, 1.0);
        }
    }

    public static class RYBA
    extends RYB {
        public double a;

        public RYBA(double r, double y, double b, double a) {
            super(r, y, b);
            this.a = a;
        }
    }

    public static class RYB
    extends Color {
        public double r;
        public double y;
        public double b;

        public RYB(double r, double y, double b) {
            this.r = r;
            this.y = y;
            this.b = b;
        }

        @Override
        public RGB toRGB() {
            double R = this.r + this.y * (1.0 - this.r) - this.b * this.r * 0.5;
            double G = this.y * (1.0 - this.b) + this.b * (1.0 - this.y) * 0.5;
            double B = this.b + this.r * (1.0 - this.b) - this.y * this.b * 0.5;
            return new RGB(R, G, B);
        }

        @Override
        public RGBA toRGBA() {
            RGB rgb = this.toRGB();
            return new RGBA(rgb.r, rgb.g, rgb.b, 1.0);
        }

        @Override
        public String toShortString() {
            return String.format("r%.2f, y%.2f, b%.2f", this.r, this.y, this.b);
        }

        @Override
        public String toShortString255() {
            return String.format("r%d, y%d, b%d", (int)(this.r * 255.0), (int)(this.y * 255.0), (int)(this.b * 255.0));
        }

        @Override
        public String toString() {
            return String.format("Red %.3f, Yellow %.3f, Blue %.3f", this.r, this.y, this.b);
        }

        @Override
        public String toString255() {
            return String.format("Red %d, Yellow %d, Blue %d", (int)(this.r * 255.0), (int)(this.y * 255.0), (int)(this.b * 255.0));
        }

        @Override
        public int toHex() {
            return this.toRGB().toHex();
        }

        @Override
        public String toHexString() {
            return this.toRGB().toHexString();
        }

        @Override
        public Vector3d toVec3() {
            return this.toRGB().toVec3();
        }

        @Override
        public Vector4d toVec4() {
            return this.toRGBA().toVec4();
        }

        @Override
        public RYB toRYB() {
            return this;
        }

        @Override
        public RYBA toRYBA() {
            return new RYBA(this.r, this.y, this.b, 1.0);
        }

        @Override
        public HSV toHSV() {
            return this.toRGB().toHSV();
        }

        @Override
        public HSVA toHSVA() {
            return this.toRGB().toHSVA();
        }

        @Override
        public HSL toHSL() {
            return this.toRGB().toHSL();
        }

        @Override
        public HSLA toHSLA() {
            return this.toRGB().toHSLA();
        }

        @Override
        public HWB toHWB() {
            return this.toRGB().toHWB();
        }

        @Override
        public HWBA toHWBA() {
            return this.toRGB().toHWBA();
        }

        @Override
        public CMYK toCMYK() {
            return this.toRGB().toCMYK();
        }

        @Override
        public CMYKA toCMYKA() {
            return this.toRGB().toCMYKA();
        }

        @Override
        public boolean equal(Color other) {
            if (other == null) {
                return false;
            }
            RGBA a = this.toRGBA();
            RGBA b = other.toRGBA();
            return Math.abs(a.r - b.r) < 1.0E-6 && Math.abs(a.g - b.g) < 1.0E-6 && Math.abs(a.b - b.b) < 1.0E-6 && Math.abs(a.a - b.a) < 1.0E-6;
        }
    }

    public static class HSVA
    extends HSV {
        public double a;

        public HSVA(double h, double s, double v, double a) {
            super(h, s, v);
            this.a = a;
        }
    }

    public static class HSV
    extends Color {
        public double h;
        public double s;
        public double v;

        public HSV(double h, double s, double v) {
            this.h = h;
            this.s = s;
            this.v = v;
        }

        @Override
        public RGB toRGB() {
            double c = this.v * this.s;
            double x = c * (1.0 - Math.abs(this.h / 60.0 % 2.0 - 1.0));
            double m = this.v - c;
            double r1 = 0.0;
            double g1 = 0.0;
            double b1 = 0.0;
            if (0.0 <= this.h && this.h < 60.0) {
                r1 = c;
                g1 = x;
                b1 = 0.0;
            } else if (60.0 <= this.h && this.h < 120.0) {
                r1 = x;
                g1 = c;
                b1 = 0.0;
            } else if (120.0 <= this.h && this.h < 180.0) {
                r1 = 0.0;
                g1 = c;
                b1 = x;
            } else if (180.0 <= this.h && this.h < 240.0) {
                r1 = 0.0;
                g1 = x;
                b1 = c;
            } else if (240.0 <= this.h && this.h < 300.0) {
                r1 = x;
                g1 = 0.0;
                b1 = c;
            } else if (300.0 <= this.h && this.h < 360.0) {
                r1 = c;
                g1 = 0.0;
                b1 = x;
            }
            return new RGB(r1 + m, g1 + m, b1 + m);
        }

        @Override
        public RGBA toRGBA() {
            RGB rgb = this.toRGB();
            return new RGBA(rgb.r, rgb.g, rgb.b, 1.0);
        }

        @Override
        public String toShortString() {
            return String.format("h%.1f, s%.2f, v%.2f", this.h, this.s, this.v);
        }

        @Override
        public String toShortString255() {
            return String.format("h%.1f\u00b0, s%d%%, v%d%%", this.h, (int)(this.s * 100.0), (int)(this.v * 100.0));
        }

        @Override
        public String toString() {
            return String.format("Hue %.1f\u00b0, Saturation %.3f, Value %.3f", this.h, this.s, this.v);
        }

        @Override
        public String toString255() {
            return String.format("Hue %.1f\u00b0, Saturation %d%%, Value %d%%", this.h, (int)(this.s * 100.0), (int)(this.v * 100.0));
        }

        @Override
        public int toHex() {
            return this.toRGB().toHex();
        }

        @Override
        public String toHexString() {
            return this.toRGB().toHexString();
        }

        @Override
        public Vector3d toVec3() {
            return this.toRGB().toVec3();
        }

        @Override
        public Vector4d toVec4() {
            return this.toRGBA().toVec4();
        }

        @Override
        public RYB toRYB() {
            return this.toRGB().toRYB();
        }

        @Override
        public RYBA toRYBA() {
            return this.toRGB().toRYBA();
        }

        @Override
        public HSV toHSV() {
            return this;
        }

        @Override
        public HSVA toHSVA() {
            return new HSVA(this.h, this.s, this.v, 1.0);
        }

        @Override
        public HSL toHSL() {
            return this.toRGB().toHSL();
        }

        @Override
        public HSLA toHSLA() {
            return this.toRGB().toHSLA();
        }

        @Override
        public HWB toHWB() {
            return this.toRGB().toHWB();
        }

        @Override
        public HWBA toHWBA() {
            return this.toRGB().toHWBA();
        }

        @Override
        public CMYK toCMYK() {
            return this.toRGB().toCMYK();
        }

        @Override
        public CMYKA toCMYKA() {
            return this.toRGB().toCMYKA();
        }

        @Override
        public boolean equal(Color other) {
            if (other == null) {
                return false;
            }
            RGBA a = this.toRGBA();
            RGBA b = other.toRGBA();
            return Math.abs(a.r - b.r) < 1.0E-6 && Math.abs(a.g - b.g) < 1.0E-6 && Math.abs(a.b - b.b) < 1.0E-6 && Math.abs(a.a - b.a) < 1.0E-6;
        }
    }

    public static class HSLA
    extends HSL {
        public double a;

        public HSLA(double h, double s, double l, double a) {
            super(h, s, l);
            this.a = a;
        }
    }

    public static class HSL
    extends Color {
        public double h;
        public double s;
        public double l;

        public HSL(double h, double s, double l) {
            this.h = h;
            this.s = s;
            this.l = l;
        }

        @Override
        public RGB toRGB() {
            double c = (1.0 - Math.abs(2.0 * this.l - 1.0)) * this.s;
            double x = c * (1.0 - Math.abs(this.h / 60.0 % 2.0 - 1.0));
            double m = this.l - c / 2.0;
            double r1 = 0.0;
            double g1 = 0.0;
            double b1 = 0.0;
            if (0.0 <= this.h && this.h < 60.0) {
                r1 = c;
                g1 = x;
                b1 = 0.0;
            } else if (60.0 <= this.h && this.h < 120.0) {
                r1 = x;
                g1 = c;
                b1 = 0.0;
            } else if (120.0 <= this.h && this.h < 180.0) {
                r1 = 0.0;
                g1 = c;
                b1 = x;
            } else if (180.0 <= this.h && this.h < 240.0) {
                r1 = 0.0;
                g1 = x;
                b1 = c;
            } else if (240.0 <= this.h && this.h < 300.0) {
                r1 = x;
                g1 = 0.0;
                b1 = c;
            } else if (300.0 <= this.h && this.h < 360.0) {
                r1 = c;
                g1 = 0.0;
                b1 = x;
            }
            return new RGB(r1 + m, g1 + m, b1 + m);
        }

        @Override
        public RGBA toRGBA() {
            RGB rgb = this.toRGB();
            return new RGBA(rgb.r, rgb.g, rgb.b, 1.0);
        }

        @Override
        public String toShortString() {
            return String.format("h%.1f, s%.2f, l%.2f", this.h, this.s, this.l);
        }

        @Override
        public String toShortString255() {
            return String.format("h%.1f\u00b0, s%d%%, l%d%%", this.h, (int)(this.s * 100.0), (int)(this.l * 100.0));
        }

        @Override
        public String toString() {
            return String.format("Hue %.1f\u00b0, Saturation %.3f, Lightness %.3f", this.h, this.s, this.l);
        }

        @Override
        public String toString255() {
            return String.format("Hue %.1f\u00b0, Saturation %d%%, Lightness %d%%", this.h, (int)(this.s * 100.0), (int)(this.l * 100.0));
        }

        @Override
        public int toHex() {
            return this.toRGB().toHex();
        }

        @Override
        public String toHexString() {
            return this.toRGB().toHexString();
        }

        @Override
        public Vector3d toVec3() {
            return this.toRGB().toVec3();
        }

        @Override
        public Vector4d toVec4() {
            return this.toRGBA().toVec4();
        }

        @Override
        public RYB toRYB() {
            return this.toRGB().toRYB();
        }

        @Override
        public RYBA toRYBA() {
            return this.toRGB().toRYBA();
        }

        @Override
        public HSV toHSV() {
            return this.toRGB().toHSV();
        }

        @Override
        public HSVA toHSVA() {
            return this.toRGB().toHSVA();
        }

        @Override
        public HSL toHSL() {
            return this;
        }

        @Override
        public HSLA toHSLA() {
            return new HSLA(this.h, this.s, this.l, 1.0);
        }

        @Override
        public HWB toHWB() {
            return this.toRGB().toHWB();
        }

        @Override
        public HWBA toHWBA() {
            return this.toRGB().toHWBA();
        }

        @Override
        public CMYK toCMYK() {
            return this.toRGB().toCMYK();
        }

        @Override
        public CMYKA toCMYKA() {
            return this.toRGB().toCMYKA();
        }

        @Override
        public boolean equal(Color other) {
            if (other == null) {
                return false;
            }
            RGBA a = this.toRGBA();
            RGBA b = other.toRGBA();
            return Math.abs(a.r - b.r) < 1.0E-6 && Math.abs(a.g - b.g) < 1.0E-6 && Math.abs(a.b - b.b) < 1.0E-6 && Math.abs(a.a - b.a) < 1.0E-6;
        }
    }

    public static class HWBA
    extends HWB {
        public double a;

        public HWBA(double h, double w, double b, double a) {
            super(h, w, b);
            this.a = a;
        }
    }

    public static class HWB
    extends Color {
        public double h;
        public double w;
        public double b;

        public HWB(double h, double w, double b) {
            this.h = h;
            this.w = w;
            this.b = b;
        }

        @Override
        public RGB toRGB() {
            HSV base = new HSV(this.h, 1.0, 1.0);
            RGB rgb = base.toRGB();
            double sum = this.w + this.b;
            if (sum > 1.0) {
                this.w /= sum;
                this.b /= sum;
            }
            double R = rgb.r * (1.0 - this.w - this.b) + this.w;
            double G = rgb.g * (1.0 - this.w - this.b) + this.w;
            double B = rgb.b * (1.0 - this.w - this.b) + this.w;
            return new RGB(R, G, B);
        }

        @Override
        public RGBA toRGBA() {
            RGB rgb = this.toRGB();
            return new RGBA(rgb.r, rgb.g, rgb.b, 1.0);
        }

        @Override
        public String toShortString() {
            return String.format("h%.1f, w%.2f, b%.2f", this.h, this.w, this.b);
        }

        @Override
        public String toShortString255() {
            return String.format("h%.1f\u00b0, w%d%%, b%d%%", this.h, (int)(this.w * 100.0), (int)(this.b * 100.0));
        }

        @Override
        public String toString() {
            return String.format("Hue %.1f\u00b0, Whiteness %.3f, Blackness %.3f", this.h, this.w, this.b);
        }

        @Override
        public String toString255() {
            return String.format("Hue %.1f\u00b0, Whiteness %d%%, Blackness %d%%", this.h, (int)(this.w * 100.0), (int)(this.b * 100.0));
        }

        @Override
        public int toHex() {
            return this.toRGB().toHex();
        }

        @Override
        public String toHexString() {
            return this.toRGB().toHexString();
        }

        @Override
        public Vector3d toVec3() {
            return this.toRGB().toVec3();
        }

        @Override
        public Vector4d toVec4() {
            return this.toRGBA().toVec4();
        }

        @Override
        public RYB toRYB() {
            return this.toRGB().toRYB();
        }

        @Override
        public RYBA toRYBA() {
            return this.toRGB().toRYBA();
        }

        @Override
        public HSV toHSV() {
            return this.toRGB().toHSV();
        }

        @Override
        public HSVA toHSVA() {
            return this.toRGB().toHSVA();
        }

        @Override
        public HSL toHSL() {
            return this.toRGB().toHSL();
        }

        @Override
        public HSLA toHSLA() {
            return this.toRGB().toHSLA();
        }

        @Override
        public HWB toHWB() {
            return this;
        }

        @Override
        public HWBA toHWBA() {
            return new HWBA(this.h, this.w, this.b, 1.0);
        }

        @Override
        public CMYK toCMYK() {
            return this.toRGB().toCMYK();
        }

        @Override
        public CMYKA toCMYKA() {
            return this.toRGB().toCMYKA();
        }

        @Override
        public boolean equal(Color other) {
            if (other == null) {
                return false;
            }
            RGBA a = this.toRGBA();
            RGBA b = other.toRGBA();
            return Math.abs(a.r - b.r) < 1.0E-6 && Math.abs(a.g - b.g) < 1.0E-6 && Math.abs(a.b - b.b) < 1.0E-6 && Math.abs(a.a - b.a) < 1.0E-6;
        }
    }

    public static class CMYKA
    extends CMYK {
        public double a;

        public CMYKA(double c, double m, double y, double k, double a) {
            super(c, m, y, k);
            this.a = a;
        }
    }

    public static class CMYK
    extends Color {
        public double c;
        public double m;
        public double y;
        public double k;

        public CMYK(double c, double m, double y, double k) {
            this.c = c;
            this.m = m;
            this.y = y;
            this.k = k;
        }

        @Override
        public RGB toRGB() {
            double R = 1.0 - Math.min(1.0, this.c * (1.0 - this.k) + this.k);
            double G = 1.0 - Math.min(1.0, this.m * (1.0 - this.k) + this.k);
            double B = 1.0 - Math.min(1.0, this.y * (1.0 - this.k) + this.k);
            return new RGB(R, G, B);
        }

        @Override
        public RGBA toRGBA() {
            RGB rgb = this.toRGB();
            return new RGBA(rgb.r, rgb.g, rgb.b, 1.0);
        }

        @Override
        public String toShortString() {
            return String.format("c%.2f, m%.2f, y%.2f, k%.2f", this.c, this.m, this.y, this.k);
        }

        @Override
        public String toShortString255() {
            return String.format("c%d%%, m%d%%, y%d%%, k%d%%", (int)(this.c * 100.0), (int)(this.m * 100.0), (int)(this.y * 100.0), (int)(this.k * 100.0));
        }

        @Override
        public String toString() {
            return String.format("Cyan %.3f, Magenta %.3f, Yellow %.3f, Black %.3f", this.c, this.m, this.y, this.k);
        }

        @Override
        public String toString255() {
            return String.format("Cyan %d%%, Magenta %d%%, Yellow %d%%, Black %d%%", (int)(this.c * 100.0), (int)(this.m * 100.0), (int)(this.y * 100.0), (int)(this.k * 100.0));
        }

        @Override
        public int toHex() {
            return this.toRGB().toHex();
        }

        @Override
        public String toHexString() {
            return this.toRGB().toHexString();
        }

        @Override
        public Vector3d toVec3() {
            return this.toRGB().toVec3();
        }

        @Override
        public Vector4d toVec4() {
            return this.toRGBA().toVec4();
        }

        @Override
        public RYB toRYB() {
            return this.toRGB().toRYB();
        }

        @Override
        public RYBA toRYBA() {
            return this.toRGB().toRYBA();
        }

        @Override
        public HSV toHSV() {
            return this.toRGB().toHSV();
        }

        @Override
        public HSVA toHSVA() {
            return this.toRGB().toHSVA();
        }

        @Override
        public HSL toHSL() {
            return this.toRGB().toHSL();
        }

        @Override
        public HSLA toHSLA() {
            return this.toRGB().toHSLA();
        }

        @Override
        public HWB toHWB() {
            return this.toRGB().toHWB();
        }

        @Override
        public HWBA toHWBA() {
            return this.toRGB().toHWBA();
        }

        @Override
        public CMYK toCMYK() {
            return this;
        }

        @Override
        public CMYKA toCMYKA() {
            return new CMYKA(this.c, this.m, this.y, this.k, 1.0);
        }

        @Override
        public boolean equal(Color other) {
            if (other == null) {
                return false;
            }
            RGBA a = this.toRGBA();
            RGBA b = other.toRGBA();
            return Math.abs(a.r - b.r) < 1.0E-6 && Math.abs(a.g - b.g) < 1.0E-6 && Math.abs(a.b - b.b) < 1.0E-6 && Math.abs(a.a - b.a) < 1.0E-6;
        }
    }
}

