/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.events;

import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.register.AllDynamicTypes;
import dev.lopyluna.slag.register.AllRegistries;
import net.minecraft.core.Registry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="slag")
public class MaterialRegistryEvents {
    public static int tick = 0;

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        if (tick > 1) {
            --tick;
        }
        if (tick == 1) {
            MinecraftServer server = event.getLevel().getServer();
            if (server == null) {
                return;
            }
            server.getPlayerList().getPlayers().forEach(AllDynamicTypes::syncToPlayer);
            SlagEmbers.LOGGER.info("Synced material registry to all players");
            --tick;
        }
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        MinecraftServer server = event.getPlayerList().getServer();
        Registry materialRegistry = server.registryAccess().registryOrThrow(AllRegistries.MATERIAL_TYPE_REGISTRY_KEY);
        Registry partRegistry = server.registryAccess().registryOrThrow(AllRegistries.PART_TYPE_REGISTRY_KEY);
        Registry modularRegistry = server.registryAccess().registryOrThrow(AllRegistries.MODULAR_TYPE_REGISTRY_KEY);
        AllDynamicTypes.clear();
        materialRegistry.stream().filter(m -> !m.dontRegister).forEach(AllDynamicTypes::registerMaterial);
        partRegistry.stream().filter(p -> !p.dontRegister).forEach(AllDynamicTypes::registerPart);
        modularRegistry.stream().filter(m -> !m.dontRegister).forEach(AllDynamicTypes::registerModular);
        SlagEmbers.LOGGER.info("Loaded {} materials from datapack registry", (Object)AllDynamicTypes.getAllMaterialsList().size());
        SlagEmbers.LOGGER.info("Loaded {} parts from datapack registry", (Object)AllDynamicTypes.getAllPartsList().size());
        tick = 20;
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AllDynamicTypes.syncToPlayer(player2);
        }
    }
}

