/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.mixin;

import dev.lopyluna.slag.content.items.modular.ModularItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Ingredient.class})
public class IngredientMixin {
    @Shadow
    @Final
    private Ingredient.Value[] values;
    @Unique
    private List<TagKey<Item>> slag$tags;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Unique
    public List<TagKey<Item>> slag$getTags() {
        if (this.slag$tags == null) {
            ArrayList<TagKey<Item>> tags = new ArrayList<TagKey<Item>>();
            for (Ingredient.Value value : this.values) {
                if (!(value instanceof Ingredient.TagValue)) continue;
                Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                try {
                    TagKey tagKey;
                    TagKey tag = tagKey = tagValue.tag();
                    tags.add((TagKey<Item>)tag);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            this.slag$tags = tags;
        }
        return this.slag$tags;
    }

    @Inject(method={"test(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void test(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (stack != null && stack.getItem() instanceof ModularItem) {
            for (TagKey<Item> tag : this.slag$getTags()) {
                if (!stack.is(tag)) continue;
                cir.setReturnValue((Object)true);
                return;
            }
        }
    }
}

