/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.mixin;

import dev.lopyluna.slag.content.AllUtils;
import dev.lopyluna.slag.content.items.dynamic_part.IDynamicPart;
import dev.lopyluna.slag.content.items.modular.ModularItem;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Shadow
    public abstract Item getItem();

    @Inject(method={"is(Lnet/minecraft/tags/TagKey;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isTag(TagKey<Item> tag, CallbackInfoReturnable<Boolean> cir) {
        IDynamicPart part;
        ModularItem tool;
        boolean value;
        ItemStack self = (ItemStack)this;
        Item item = self.getItem();
        if (item instanceof ModularItem && (value = AllUtils.matchesAnyTag(tool = (ModularItem)item, self, tag))) {
            cir.setReturnValue((Object)value);
        }
        if (item instanceof IDynamicPart && (value = AllUtils.matchesAnyTag(part = (IDynamicPart)item, self, tag))) {
            cir.setReturnValue((Object)value);
        }
    }

    @Inject(method={"is(Lnet/minecraft/core/HolderSet;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isHolderSet(HolderSet<Item> set, CallbackInfoReturnable<Boolean> cir) {
        HolderSet.Named named;
        boolean value;
        ItemStack self = (ItemStack)this;
        Item item = self.getItem();
        if (item instanceof ModularItem) {
            ModularItem tool = (ModularItem)item;
            if (set instanceof HolderSet.Named && (value = AllUtils.matchesAnyTag(tool, self, (TagKey<Item>)(named = (HolderSet.Named)set).key()))) {
                cir.setReturnValue((Object)value);
            }
        }
        if (item instanceof IDynamicPart) {
            IDynamicPart part = (IDynamicPart)item;
            if (set instanceof HolderSet.Named && (value = AllUtils.matchesAnyTag(part, self, (TagKey<Item>)(named = (HolderSet.Named)set).key()))) {
                cir.setReturnValue((Object)value);
            }
        }
    }

    @Inject(method={"getTags()Ljava/util/stream/Stream;"}, at={@At(value="RETURN")}, cancellable=true)
    public void getTags(CallbackInfoReturnable<Stream<TagKey<Item>>> cir) {
        ArrayList tags = new ArrayList(((Stream)cir.getReturnValue()).toList());
        ItemStack self = (ItemStack)this;
        Item item = self.getItem();
        if (item instanceof ModularItem) {
            ModularItem tool = (ModularItem)item;
            tags.addAll(AllUtils.getTags(tool, self));
        }
        if (item instanceof IDynamicPart) {
            IDynamicPart part = (IDynamicPart)item;
            tags.addAll(AllUtils.getTags(part, self));
        }
        cir.setReturnValue(tags.stream());
    }
}

