/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.network.packets;

import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.content.blocks.crucible.CrucibleBE;
import dev.lopyluna.slag.content.blocks.crucible.CrucibleTank;
import dev.lopyluna.slag.content.blocks.multiblock.FluidMultiBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SelectFluidIndexC2S(BlockPos pos, int index) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SelectFluidIndexC2S> TYPE = new CustomPacketPayload.Type(SlagEmbers.loc("select_fluid_index"));
    public static final StreamCodec<FriendlyByteBuf, SelectFluidIndexC2S> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SelectFluidIndexC2S::pos, (StreamCodec)ByteBufCodecs.INT, SelectFluidIndexC2S::index, SelectFluidIndexC2S::new);

    public static void handle(SelectFluidIndexC2S msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            CrucibleBE cr;
            FluidMultiBlockEntity patt2$temp;
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            int i = msg.index;
            if (i < 0) {
                return;
            }
            Level level = player.level();
            BlockEntity patt1$temp = level.getBlockEntity(msg.pos);
            if (!(patt1$temp instanceof CrucibleBE) || !((patt2$temp = (cr = (CrucibleBE)patt1$temp).getControllerBE()) instanceof CrucibleBE)) {
                return;
            }
            CrucibleBE be = (CrucibleBE)patt2$temp;
            CrucibleTank inv = be.getTankInventory();
            if (inv == null || !inv.moveFluidToFront(i)) {
                return;
            }
            be.setChanged();
            level.sendBlockUpdated(msg.pos, be.getBlockState(), be.getBlockState(), 3);
        });
    }

    @Nonnull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

