/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.register;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.FluidEntry;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.content.blocks.basin.BasinBlock;
import dev.lopyluna.slag.content.blocks.crucible.CrucibleBE;
import dev.lopyluna.slag.content.blocks.crucible.CrucibleBlock;
import dev.lopyluna.slag.content.blocks.crucible.CrucibleItem;
import dev.lopyluna.slag.content.blocks.crucible_interface.InterfaceBlock;
import dev.lopyluna.slag.content.blocks.drain.DrainBlock;
import dev.lopyluna.slag.content.blocks.forge.ForgeBlock;
import dev.lopyluna.slag.content.blocks.melter.MelterBlock;
import dev.lopyluna.slag.content.blocks.table.TableBlock;
import dev.lopyluna.slag.content.datagen.AlloyingRecipeBuilder;
import dev.lopyluna.slag.content.datagen.BasinCastingRecipeBuilder;
import dev.lopyluna.slag.content.datagen.DualCookingRecipeBuilder;
import dev.lopyluna.slag.content.datagen.MeltingRecipeBuilder;
import dev.lopyluna.slag.content.datagen.TableCastingRecipeBuilder;
import dev.lopyluna.slag.content.utils.BlockHelper;
import dev.lopyluna.slag.register.AllFluids;
import dev.lopyluna.slag.register.AllItems;
import dev.lopyluna.slag.register.AllSoundTypes;
import dev.lopyluna.slag.register.AllTags;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.Tags;

public class AllBlocks {
    public static final BlockEntry<Block> ROSE_GOLD_BLOCK = ((BlockBuilder)SlagEmbers.REG.block("rose_gold_block", Block::new).lang("Block of Rose Gold").initialProperties(() -> Blocks.GOLD_BLOCK).properties(p -> p.mapColor(MapColor.COLOR_PINK).requiresCorrectToolForDrops()).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE, BlockTags.NEEDS_IRON_TOOL, BlockTags.BEACON_BASE_BLOCKS, AllTags.blockC("storage_blocks"), AllTags.blockC("storage_blocks/rose_gold")}).item().tag(new TagKey[]{AllTags.itemC("storage_blocks"), AllTags.itemC("storage_blocks/rose_gold")}).build()).register();
    public static final BlockEntry<Block> DEEP_ALLOY_BLOCK = ((BlockBuilder)SlagEmbers.REG.block("deep_alloy_block", Block::new).lang("Block of Deep Alloy").initialProperties(() -> Blocks.GOLD_BLOCK).properties(p -> p.sound((SoundType)AllSoundTypes.CRUCIBLE).noOcclusion().mapColor(MapColor.COLOR_GRAY).requiresCorrectToolForDrops()).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE, BlockTags.NEEDS_IRON_TOOL, BlockTags.BEACON_BASE_BLOCKS, AllTags.blockC("storage_blocks"), AllTags.blockC("storage_blocks/deep_alloy")}).item().tag(new TagKey[]{AllTags.itemC("storage_blocks"), AllTags.itemC("storage_blocks/deep_alloy")}).build()).register();
    public static final BlockEntry<CrucibleBlock> CRUCIBLE = ((BlockBuilder)SlagEmbers.REG.block("crucible", CrucibleBlock::new).initialProperties(() -> Blocks.CAULDRON).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> {
        Function<BlockState, ModelFile> modelFunc = s -> {
            String[] stringArray = new String[3];
            stringArray[0] = switch ((CrucibleBE.Shape)((Object)((Object)((Object)((Object)s.getValue(CrucibleBE.SHAPE)))))) {
                default -> throw new MatchException(null, null);
                case CrucibleBE.Shape.PLAIN -> "";
                case CrucibleBE.Shape.INNER -> "inner";
                case CrucibleBE.Shape.NW -> "nw";
                case CrucibleBE.Shape.SW -> "sw";
                case CrucibleBE.Shape.NE -> "ne";
                case CrucibleBE.Shape.SE -> "se";
                case CrucibleBE.Shape.NORTH -> "north";
                case CrucibleBE.Shape.SOUTH -> "south";
                case CrucibleBE.Shape.WEST -> "west";
                case CrucibleBE.Shape.EAST -> "east";
            };
            stringArray[1] = (Boolean)s.getValue((Property)CrucibleBE.TOP) != false ? "top" : "";
            stringArray[2] = (Boolean)s.getValue((Property)CrucibleBE.BOTTOM) != false ? "bottom" : "";
            ModelFile model = BlockHelper.getExistingModel((DataGenContext<Block, ? extends Block>)c, p, stringArray);
            ResourceLocation loc = model.getLocation();
            BlockModelBuilder wModel = (BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(loc.getPath() + "_window", loc)).texture("1", "block/crucible_side_window");
            return (Boolean)s.getValue((Property)CrucibleBE.WINDOW) != false ? wModel : model;
        };
        return ConfiguredModel.builder().modelFile(modelFunc.apply((BlockState)state)).build();
    })).properties(p -> p.sound((SoundType)AllSoundTypes.CRUCIBLE).noOcclusion().mapColor(MapColor.COLOR_GRAY).requiresCorrectToolForDrops()).recipe((c, p) -> {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)c.get()), (int)4).pattern("D D").pattern("D D").pattern("DBD").define(Character.valueOf('D'), AllTags.itemC("ingots/deep_alloy")).define(Character.valueOf('B'), AllTags.itemC("storage_blocks/deep_alloy")).unlockedBy("has_deep_alloy", RegistrateRecipeProvider.has(AllTags.itemC("ingots/deep_alloy"))).save((RecipeOutput)p, SlagEmbers.loc("crafting/" + c.getName()));
        AlloyingRecipeBuilder.create((Fluid)AllFluids.MOLTEN_OBSIDIAN.getSource(), 8, AlloyingRecipeBuilder.fluid((Fluid)Fluids.WATER, 8), AlloyingRecipeBuilder.fluid((Fluid)Fluids.LAVA, 8)).unlockedBy("has_lava", RegistrateRecipeProvider.has((ItemLike)Items.LAVA_BUCKET)).save((RecipeOutput)p, SlagEmbers.loc("alloying/molten_obsidian"));
        AlloyingRecipeBuilder.create((Fluid)AllFluids.MOLTEN_ROSE_GOLD.getSource(), 16, AlloyingRecipeBuilder.fluid((Fluid)AllFluids.MOLTEN_GOLD.getSource(), 8), AlloyingRecipeBuilder.fluid((Fluid)AllFluids.MOLTEN_COPPER.getSource(), 8)).unlockedBy("has_lava", RegistrateRecipeProvider.has((ItemLike)Items.LAVA_BUCKET)).save((RecipeOutput)p, SlagEmbers.loc("alloying/molten_rose_gold"));
    }).addLayer(() -> RenderType::cutoutMipped).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).item(CrucibleItem::new).model((c, p) -> p.withExistingParent("item/" + c.getName(), p.modLoc("block/" + c.getName() + "/block_top_bottom"))).build()).register();
    public static final BlockEntry<TableBlock> TABLE = ((BlockBuilder)SlagEmbers.REG.block("table", TableBlock::new).initialProperties(() -> Blocks.CAULDRON).lang("Casting Table").blockstate((c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)p.models().getExistingFile(p.modLoc("block/table")))).properties(p -> p.sound((SoundType)AllSoundTypes.CRUCIBLE).noOcclusion().mapColor(MapColor.COLOR_GRAY).requiresCorrectToolForDrops()).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).recipe((c, p) -> {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)c.get()), (int)1).pattern("AAA").pattern("A A").define(Character.valueOf('A'), AllTags.itemC("ingots/deep_alloy")).unlockedBy("has_deep_alloy", RegistrateRecipeProvider.has(AllTags.itemC("ingots/deep_alloy"))).save((RecipeOutput)p, SlagEmbers.loc("crafting/" + c.getName()));
        AllBlocks.create(p, "ingot", "copper", Items.COPPER_INGOT, AllFluids.MOLTEN_COPPER, 72, AllTags.CAST_INGOTS);
        AllBlocks.create(p, "ingot", "gold", Items.GOLD_INGOT, AllFluids.MOLTEN_GOLD, 72, AllTags.CAST_INGOTS);
        AllBlocks.create(p, "ingot", "iron", Items.IRON_INGOT, AllFluids.MOLTEN_IRON, 72, AllTags.CAST_INGOTS);
        AllBlocks.create(p, "ingot", "rose_gold", (Item)AllItems.ROSE_GOLD_INGOT.get(), AllFluids.MOLTEN_ROSE_GOLD, 72, AllTags.CAST_INGOTS);
        AllBlocks.create(p, "ingot", "netherite", Items.NETHERITE_INGOT, AllFluids.MOLTEN_NETHERITE, 72, AllTags.CAST_INGOTS);
        AllBlocks.create(p, "gem", "diamond", Items.DIAMOND, AllFluids.MOLTEN_DIAMOND, 72, AllTags.CAST_GEMS);
        AllBlocks.create(p, "gem", "emerald", Items.EMERALD, AllFluids.MOLTEN_EMERALD, 72, AllTags.CAST_GEMS);
        AllBlocks.create(p, "gem", "lapis", Items.LAPIS_LAZULI, AllFluids.MOLTEN_LAPIS, 72, AllTags.CAST_GEMS);
        AllBlocks.create(p, "gem", "quartz", Items.QUARTZ, AllFluids.MOLTEN_QUARTZ, 72, AllTags.CAST_GEMS);
        AllBlocks.create(p, "gem", "amethyst", Items.AMETHYST_SHARD, AllFluids.MOLTEN_AMETHYST, 72, AllTags.CAST_GEMS);
        AllBlocks.create(p, "gem", "prismarine", Items.PRISMARINE, AllFluids.MOLTEN_PRISMARINE, 72, AllTags.CAST_GEMS);
        AllBlocks.create(p, "dust", "redstone", Items.REDSTONE, AllFluids.MOLTEN_REDSTONE, 72, AllTags.CAST_DUSTS);
        AllBlocks.create(p, "nugget", "gold", Items.GOLD_NUGGET, AllFluids.MOLTEN_GOLD, 8, AllTags.CAST_NUGGETS);
        AllBlocks.create(p, "nugget", "iron", Items.IRON_NUGGET, AllFluids.MOLTEN_IRON, 8, AllTags.CAST_NUGGETS);
        AllBlocks.create(p, "nugget", "rose_gold", (Item)AllItems.ROSE_GOLD_NUGGET.get(), AllFluids.MOLTEN_ROSE_GOLD, 8, AllTags.CAST_NUGGETS);
    }).addLayer(() -> RenderType::cutoutMipped).item().model((c, p) -> p.withExistingParent("item/" + c.getName(), p.modLoc("block/table"))).build()).register();
    public static final BlockEntry<BasinBlock> BASIN = ((BlockBuilder)SlagEmbers.REG.block("basin", BasinBlock::new).initialProperties(() -> Blocks.CAULDRON).lang("Casting Basin").blockstate((c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)p.models().getExistingFile(p.modLoc("block/basin")))).properties(p -> p.sound((SoundType)AllSoundTypes.CRUCIBLE).noOcclusion().mapColor(MapColor.COLOR_GRAY).requiresCorrectToolForDrops()).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).recipe((c, p) -> {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)c.get()), (int)1).pattern("A A").pattern("A A").pattern("AAA").define(Character.valueOf('A'), AllTags.itemC("ingots/deep_alloy")).unlockedBy("has_deep_alloy", RegistrateRecipeProvider.has(AllTags.itemC("ingots/deep_alloy"))).save((RecipeOutput)p, SlagEmbers.loc("crafting/" + c.getName()));
        BasinCastingRecipeBuilder.create(Items.AMETHYST_BLOCK, 1, (Fluid)AllFluids.MOLTEN_AMETHYST.getSource(), 288).unlockedBy("has_block", RegistrateRecipeProvider.has(AllTags.itemC("storage_blocks/amethyst"))).save((RecipeOutput)p, SlagEmbers.loc("casting/basin/amethyst_block"));
        BasinCastingRecipeBuilder.create(Items.COPPER_BLOCK, 1, (Fluid)AllFluids.MOLTEN_COPPER.getSource(), 648).unlockedBy("has_block", RegistrateRecipeProvider.has(AllTags.COPPER_BLOCKS)).save((RecipeOutput)p, SlagEmbers.loc("casting/basin/copper_block"));
        BasinCastingRecipeBuilder.create(Items.DIAMOND_BLOCK, 1, (Fluid)AllFluids.MOLTEN_DIAMOND.getSource(), 648).unlockedBy("has_block", RegistrateRecipeProvider.has(AllTags.itemC("storage_blocks/diamond"))).save((RecipeOutput)p, SlagEmbers.loc("casting/basin/diamond_block"));
        BasinCastingRecipeBuilder.create(Items.EMERALD_BLOCK, 1, (Fluid)AllFluids.MOLTEN_EMERALD.getSource(), 648).unlockedBy("has_block", RegistrateRecipeProvider.has(AllTags.itemC("storage_blocks/emerald"))).save((RecipeOutput)p, SlagEmbers.loc("casting/basin/emerald_block"));
        BasinCastingRecipeBuilder.create(Items.GOLD_BLOCK, 1, (Fluid)AllFluids.MOLTEN_GOLD.getSource(), 648).unlockedBy("has_block", RegistrateRecipeProvider.has(AllTags.itemC("storage_blocks/gold"))).save((RecipeOutput)p, SlagEmbers.loc("casting/basin/gold_block"));
        BasinCastingRecipeBuilder.create(Items.IRON_BLOCK, 1, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 648).unlockedBy("has_block", RegistrateRecipeProvider.has(AllTags.itemC("storage_blocks/iron"))).save((RecipeOutput)p, SlagEmbers.loc("casting/basin/iron_block"));
        BasinCastingRecipeBuilder.create(Items.LAPIS_BLOCK, 1, (Fluid)AllFluids.MOLTEN_LAPIS.getSource(), 648).unlockedBy("has_block", RegistrateRecipeProvider.has(AllTags.itemC("storage_blocks/lapis"))).save((RecipeOutput)p, SlagEmbers.loc("casting/basin/lapis_block"));
        BasinCastingRecipeBuilder.create(Items.NETHERITE_BLOCK, 1, (Fluid)AllFluids.MOLTEN_NETHERITE.getSource(), 648).unlockedBy("has_block", RegistrateRecipeProvider.has(AllTags.itemC("storage_blocks/netherite"))).save((RecipeOutput)p, SlagEmbers.loc("casting/basin/netherite_block"));
        BasinCastingRecipeBuilder.create(Items.QUARTZ_BLOCK, 1, (Fluid)AllFluids.MOLTEN_QUARTZ.getSource(), 288).unlockedBy("has_block", RegistrateRecipeProvider.has(AllTags.QUARTZ_BLOCKS)).save((RecipeOutput)p, SlagEmbers.loc("casting/basin/quartz_block"));
        BasinCastingRecipeBuilder.create(Items.REDSTONE_BLOCK, 1, (Fluid)AllFluids.MOLTEN_REDSTONE.getSource(), 648).unlockedBy("has_block", RegistrateRecipeProvider.has(AllTags.itemC("storage_blocks/redstone"))).save((RecipeOutput)p, SlagEmbers.loc("casting/basin/redstone_block"));
        BasinCastingRecipeBuilder.create(ROSE_GOLD_BLOCK.asItem(), 1, (Fluid)AllFluids.MOLTEN_ROSE_GOLD.getSource(), 648).unlockedBy("has_block", RegistrateRecipeProvider.has(AllTags.itemC("storage_blocks/rose_gold"))).save((RecipeOutput)p, SlagEmbers.loc("casting/basin/rose_gold_block"));
        BasinCastingRecipeBuilder.create(Items.OBSIDIAN, 1, (Fluid)AllFluids.MOLTEN_OBSIDIAN.getSource(), 648).unlockedBy("has_block", RegistrateRecipeProvider.has((TagKey)Tags.Items.OBSIDIANS)).save((RecipeOutput)p, SlagEmbers.loc("casting/basin/obsidian"));
    }).addLayer(() -> RenderType::cutoutMipped).item().model((c, p) -> p.withExistingParent("item/" + c.getName(), p.modLoc("block/basin"))).build()).register();
    public static final BlockEntry<DrainBlock> DRAIN = ((BlockBuilder)SlagEmbers.REG.block("drain", DrainBlock::new).initialProperties(() -> Blocks.CAULDRON).blockstate(BlockHelper::genHorizontalDirectional).properties(p -> p.sound((SoundType)AllSoundTypes.CRUCIBLE).noOcclusion().mapColor(MapColor.COLOR_GRAY).requiresCorrectToolForDrops()).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).recipe((c, p) -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)c.get()), (int)1).requires(AllTags.itemC("ingots/deep_alloy")).unlockedBy("has_deep_alloy", RegistrateRecipeProvider.has(AllTags.itemC("ingots/deep_alloy"))).save((RecipeOutput)p, SlagEmbers.loc("crafting/" + c.getName()))).addLayer(() -> RenderType::cutoutMipped).item().model((c, p) -> p.withExistingParent("item/" + c.getName(), p.modLoc("block/drain"))).build()).register();
    public static final BlockEntry<MelterBlock> MELTER = ((BlockBuilder)SlagEmbers.REG.block("melter", MelterBlock::new).initialProperties(() -> Blocks.CAULDRON).blockstate(BlockHelper::genHorizontalDirectional).properties(p -> p.sound((SoundType)AllSoundTypes.CRUCIBLE).noOcclusion().mapColor(MapColor.COLOR_GRAY).requiresCorrectToolForDrops()).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).recipe((c, p) -> {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)c.get()), (int)1).pattern("AAA").pattern("RDR").pattern("AAA").define(Character.valueOf('A'), AllTags.itemC("ingots/deep_alloy")).define(Character.valueOf('R'), AllTags.itemC("ingots/rose_gold")).define(Character.valueOf('D'), (ItemLike)DRAIN.get()).unlockedBy("has_deep_alloy", RegistrateRecipeProvider.has(AllTags.itemC("ingots/deep_alloy"))).save((RecipeOutput)p, SlagEmbers.loc("crafting/" + c.getName()));
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_NETHERITE.getSource(), 72, Items.NETHERITE_HELMET);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_NETHERITE.getSource(), 72, Items.NETHERITE_CHESTPLATE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_NETHERITE.getSource(), 72, Items.NETHERITE_LEGGINGS);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_NETHERITE.getSource(), 72, Items.NETHERITE_BOOTS);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_NETHERITE.getSource(), 72, Items.NETHERITE_SWORD);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_NETHERITE.getSource(), 72, Items.NETHERITE_PICKAXE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_NETHERITE.getSource(), 72, Items.NETHERITE_AXE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_NETHERITE.getSource(), 72, Items.NETHERITE_SHOVEL);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_NETHERITE.getSource(), 72, Items.NETHERITE_HOE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_DIAMOND.getSource(), 360, Items.DIAMOND_HELMET);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_DIAMOND.getSource(), 576, Items.DIAMOND_CHESTPLATE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_DIAMOND.getSource(), 504, Items.DIAMOND_LEGGINGS);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_DIAMOND.getSource(), 288, Items.DIAMOND_BOOTS);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_DIAMOND.getSource(), 144, Items.DIAMOND_SWORD);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_DIAMOND.getSource(), 216, Items.DIAMOND_PICKAXE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_DIAMOND.getSource(), 216, Items.DIAMOND_AXE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_DIAMOND.getSource(), 72, Items.DIAMOND_SHOVEL);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_DIAMOND.getSource(), 144, Items.DIAMOND_HOE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_GOLD.getSource(), 360, Items.GOLDEN_HELMET);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_GOLD.getSource(), 576, Items.GOLDEN_CHESTPLATE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_GOLD.getSource(), 504, Items.GOLDEN_LEGGINGS);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_GOLD.getSource(), 288, Items.GOLDEN_BOOTS);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_GOLD.getSource(), 144, Items.GOLDEN_SWORD);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_GOLD.getSource(), 216, Items.GOLDEN_PICKAXE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_GOLD.getSource(), 216, Items.GOLDEN_AXE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_GOLD.getSource(), 72, Items.GOLDEN_SHOVEL);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_GOLD.getSource(), 144, Items.GOLDEN_HOE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 360, Items.IRON_HELMET);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 576, Items.IRON_CHESTPLATE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 504, Items.IRON_LEGGINGS);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 288, Items.IRON_BOOTS);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 144, Items.IRON_SWORD);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 216, Items.IRON_PICKAXE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 216, Items.IRON_AXE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 72, Items.IRON_SHOVEL);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 144, Items.IRON_HOE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 27, Items.IRON_BARS);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 108, Items.CROSSBOW);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 36, Items.TRIPWIRE_HOOK);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 36, Items.TRAPPED_CHEST);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 27, Items.RAIL);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 216, Items.IRON_DOOR);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 288, Items.IRON_TRAPDOOR);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 216, Items.BUCKET);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 144, Items.SHEARS);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 144, Items.HEAVY_WEIGHTED_PRESSURE_PLATE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 72, Items.FLINT_AND_STEEL);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 72, Items.SHIELD);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 72, Items.ACTIVATOR_RAIL);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 72, Items.DETECTOR_RAIL);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 72, Items.LODESTONE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 288, Items.COMPASS);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 288, Items.RECOVERY_COMPASS);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 360, Items.HOPPER);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 504, Items.CAULDRON);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 360, Items.MINECART);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 360, Items.CHEST_MINECART);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 864, Items.HOPPER_MINECART);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 1728, Items.HEAVY_CORE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 88, Items.CHAIN);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 144, Items.SMITHING_TABLE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 64, Items.SOUL_LANTERN);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_IRON.getSource(), 64, Items.LANTERN);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_GOLD.getSource(), 576, Items.GOLDEN_APPLE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_GOLD.getSource(), 2304, Items.ENCHANTED_GOLDEN_APPLE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_GOLD.getSource(), 64, Items.GOLDEN_CARROT);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_GOLD.getSource(), 648, Items.BELL);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_GOLD.getSource(), 144, Items.LIGHT_WEIGHTED_PRESSURE_PLATE);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_GOLD.getSource(), 288, Items.CLOCK);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_GOLD.getSource(), 72, Items.POWERED_RAIL);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_COPPER.getSource(), 72, Items.BRUSH);
        MeltingRecipeBuilder.create(p, MeltingRecipeBuilder.fluids(AlloyingRecipeBuilder.fluid((Fluid)AllFluids.MOLTEN_COPPER.getSource(), 144), AlloyingRecipeBuilder.fluid((Fluid)AllFluids.MOLTEN_AMETHYST.getSource(), 72)), Items.SPYGLASS);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_COPPER.getSource(), 216, Items.LIGHTNING_ROD);
        MeltingRecipeBuilder.create(p, "copper_doors", (Fluid)AllFluids.MOLTEN_COPPER.getSource(), 216, AllTags.itemC("doors/copper"));
        MeltingRecipeBuilder.create(p, "copper_trapdoors", (Fluid)AllFluids.MOLTEN_COPPER.getSource(), 216, AllTags.itemC("trapdoors/copper"));
        MeltingRecipeBuilder.create(p, "copper_chiseled_blocks", (Fluid)AllFluids.MOLTEN_COPPER.getSource(), 162, AllTags.itemC("chiseled_blocks/copper"));
        MeltingRecipeBuilder.create(p, "copper_grate_blocks", (Fluid)AllFluids.MOLTEN_COPPER.getSource(), 162, AllTags.itemC("grate_blocks/copper"));
        MeltingRecipeBuilder.create(p, "copper_cut_blocks", (Fluid)AllFluids.MOLTEN_COPPER.getSource(), 162, AllTags.itemC("cut_blocks/copper"));
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_DIAMOND.getSource(), 72, Items.JUKEBOX);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_REDSTONE.getSource(), 72, Items.NOTE_BLOCK);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_REDSTONE.getSource(), 288, Items.TARGET);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_AMETHYST.getSource(), 216, Items.CALIBRATED_SCULK_SENSOR);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_PRISMARINE.getSource(), 360, Items.SEA_LANTERN);
        MeltingRecipeBuilder.create(p, (Fluid)AllFluids.MOLTEN_OBSIDIAN.getSource(), 3888, Items.RESPAWN_ANCHOR);
        MeltingRecipeBuilder.gemMeltable(p, "diamond", (Fluid)AllFluids.MOLTEN_DIAMOND.getSource(), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, AllTags.itemC("nuggets/diamond"));
        MeltingRecipeBuilder.gemMeltable(p, "emerald", (Fluid)AllFluids.MOLTEN_EMERALD.getSource(), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_EMERALD, (TagKey<Item>)Tags.Items.GEMS_EMERALD, AllTags.itemC("nuggets/emerald"));
        MeltingRecipeBuilder.gemMeltable(p, "lapis", (Fluid)AllFluids.MOLTEN_LAPIS.getSource(), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS, (TagKey<Item>)Tags.Items.GEMS_LAPIS, AllTags.itemC("nuggets/lapis"));
        MeltingRecipeBuilder.dustMeltable(p, "redstone", (Fluid)AllFluids.MOLTEN_REDSTONE.getSource(), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE, (TagKey<Item>)Tags.Items.DUSTS_REDSTONE);
        MeltingRecipeBuilder.crystalMeltable(p, "quartz", (Fluid)AllFluids.MOLTEN_QUARTZ.getSource(), AllTags.QUARTZ_BLOCKS, (TagKey<Item>)Tags.Items.GEMS_QUARTZ);
        MeltingRecipeBuilder.crystalMeltable(p, "amethyst", (Fluid)AllFluids.MOLTEN_AMETHYST.getSource(), AllTags.AMETHYST_BLOCKS, (TagKey<Item>)Tags.Items.GEMS_AMETHYST);
        MeltingRecipeBuilder.crystalMeltable(p, "prismarine", (Fluid)AllFluids.MOLTEN_PRISMARINE.getSource(), null, (TagKey<Item>)Tags.Items.GEMS_PRISMARINE);
        MeltingRecipeBuilder.ingotMeltable(p, "copper", (Fluid)AllFluids.MOLTEN_COPPER.getSource(), AllTags.COPPER_BLOCKS, (TagKey<Item>)Tags.Items.INGOTS_COPPER, AllTags.itemC("nuggets/copper"));
        MeltingRecipeBuilder.ingotMeltable(p, "gold", (Fluid)AllFluids.MOLTEN_GOLD.getSource(), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_GOLD, (TagKey<Item>)Tags.Items.INGOTS_GOLD, (TagKey<Item>)Tags.Items.NUGGETS_GOLD);
        MeltingRecipeBuilder.ingotMeltable(p, "iron", (Fluid)AllFluids.MOLTEN_IRON.getSource(), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_IRON, (TagKey<Item>)Tags.Items.INGOTS_IRON, (TagKey<Item>)Tags.Items.NUGGETS_IRON);
        MeltingRecipeBuilder.ingotMeltable(p, "netherite", (Fluid)AllFluids.MOLTEN_NETHERITE.getSource(), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_NETHERITE, (TagKey<Item>)Tags.Items.INGOTS_NETHERITE, AllTags.itemC("nuggets/netherite"));
        MeltingRecipeBuilder.ingotMeltable(p, "rose_gold", (Fluid)AllFluids.MOLTEN_ROSE_GOLD.getSource(), AllTags.itemC("storage_blocks/rose_gold"), AllTags.itemC("ingots/rose_gold"), AllTags.itemC("nuggets/rose_gold"));
        MeltingRecipeBuilder.oreMeltable(p, "raw_copper", (Fluid)AllFluids.MOLTEN_COPPER.getSource(), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_RAW_COPPER, AllTags.COPPER_RAW_MATERIALS, null);
        MeltingRecipeBuilder.oreMeltable(p, "raw_iron", (Fluid)AllFluids.MOLTEN_IRON.getSource(), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_RAW_IRON, AllTags.IRON_RAW_MATERIALS, null);
        MeltingRecipeBuilder.oreMeltable(p, "raw_gold", (Fluid)AllFluids.MOLTEN_GOLD.getSource(), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_RAW_GOLD, AllTags.GOLD_RAW_MATERIALS, null);
        MeltingRecipeBuilder.oreMeltableGem(p, "raw_diamond", (Fluid)AllFluids.MOLTEN_DIAMOND.getSource(), null, (TagKey<Item>)Tags.Items.ORES_DIAMOND, null);
        MeltingRecipeBuilder.oreMeltableGem(p, "raw_emerald", (Fluid)AllFluids.MOLTEN_EMERALD.getSource(), null, (TagKey<Item>)Tags.Items.ORES_EMERALD, null);
        MeltingRecipeBuilder.oreMeltableGem(p, "raw_quartz", (Fluid)AllFluids.MOLTEN_QUARTZ.getSource(), null, (TagKey<Item>)Tags.Items.ORES_QUARTZ, null);
        MeltingRecipeBuilder.create((Fluid)AllFluids.MOLTEN_OBSIDIAN.getSource(), 648, (TagKey<Item>)Tags.Items.OBSIDIANS).unlockedBy("has_meltable_obsidian", RegistrateRecipeProvider.has((TagKey)Tags.Items.OBSIDIANS)).save((RecipeOutput)p, SlagEmbers.loc("melting/obsidian_blocks"));
        MeltingRecipeBuilder.create((Fluid)AllFluids.MOLTEN_AMETHYST.getSource(), 216, (ItemLike)Items.LARGE_AMETHYST_BUD).unlockedBy("has_meltable_buds", RegistrateRecipeProvider.has((TagKey)Tags.Items.BUDS)).save((RecipeOutput)p, SlagEmbers.loc("melting/large_amethyst_bud"));
        MeltingRecipeBuilder.create((Fluid)AllFluids.MOLTEN_AMETHYST.getSource(), 144, (ItemLike)Items.MEDIUM_AMETHYST_BUD).unlockedBy("has_meltable_buds", RegistrateRecipeProvider.has((TagKey)Tags.Items.BUDS)).save((RecipeOutput)p, SlagEmbers.loc("melting/medium_amethyst_bud"));
        MeltingRecipeBuilder.create((Fluid)AllFluids.MOLTEN_AMETHYST.getSource(), 72, (ItemLike)Items.SMALL_AMETHYST_BUD).unlockedBy("has_meltable_buds", RegistrateRecipeProvider.has((TagKey)Tags.Items.BUDS)).save((RecipeOutput)p, SlagEmbers.loc("melting/small_amethyst_bud"));
    }).addLayer(() -> RenderType::cutoutMipped).item().model((c, p) -> p.withExistingParent("item/" + c.getName(), p.modLoc("block/melter"))).build()).register();
    public static final BlockEntry<InterfaceBlock> INTERFACE = SlagEmbers.REG.block("crucible_interface", InterfaceBlock::new).initialProperties(() -> Blocks.CAULDRON).properties(p -> p.mapColor(MapColor.COLOR_GRAY).sound((SoundType)AllSoundTypes.CRUCIBLE).requiresCorrectToolForDrops()).blockstate(BlockHelper::genHorizontalDirectional).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).recipe((c, p) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)c.get()), (int)1).pattern("AA").pattern("GG").define(Character.valueOf('A'), AllTags.itemC("ingots/deep_alloy")).define(Character.valueOf('G'), AllTags.itemC("ingots/gold")).unlockedBy("has_deep_alloy", RegistrateRecipeProvider.has(AllTags.itemC("ingots/deep_alloy"))).save((RecipeOutput)p, SlagEmbers.loc("crafting/" + c.getName()))).lang("Fluid Interface").simpleItem().register();
    public static final BlockEntry<ForgeBlock> FORGE = SlagEmbers.REG.block("brick_forge", ForgeBlock::new).properties(p -> p.mapColor(MapColor.TERRACOTTA_LIGHT_GRAY).sound(SoundType.MUD_BRICKS).strength(2.5f, 3.0f).requiresCorrectToolForDrops().lightLevel(BlockHelper.litBlockEmission(13))).blockstate(BlockHelper.empty()).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).recipe((c, p) -> {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)c.get()), (int)1).pattern("BLB").pattern("LFL").pattern("BLB").define(Character.valueOf('F'), (ItemLike)Items.FURNACE).define(Character.valueOf('B'), (ItemLike)Items.MUD_BRICKS).define(Character.valueOf('L'), ItemTags.LOGS).unlockedBy("has_furnace", RegistrateRecipeProvider.has((ItemLike)Items.FURNACE)).save((RecipeOutput)p, SlagEmbers.loc("crafting/" + c.getName()));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.GLASS, Ingredient.of((TagKey)ItemTags.SMELTS_TO_GLASS), 0.1f).unlockedBy("has_smelts_to_glass", RegistrateRecipeProvider.has((TagKey)ItemTags.SMELTS_TO_GLASS)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/smelts_to_glass"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.MISC, (ItemLike)Items.BRICK, Ingredient.of((ItemLike[])new ItemLike[]{Items.CLAY_BALL}), 0.3f).unlockedBy("has_clay_ball", RegistrateRecipeProvider.has((ItemLike)Items.CLAY_BALL)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/brick"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.MISC, (ItemLike)Items.CHARCOAL, Ingredient.of((TagKey)ItemTags.LOGS_THAT_BURN), 0.15f).unlockedBy("has_log", RegistrateRecipeProvider.has((TagKey)ItemTags.LOGS_THAT_BURN)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/charcoal"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.MISC, (ItemLike)Items.POPPED_CHORUS_FRUIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.CHORUS_FRUIT}), 0.1f).unlockedBy("has_chorus_fruit", RegistrateRecipeProvider.has((ItemLike)Items.CHORUS_FRUIT)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/popped_chorus_fruit"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.MISC, (ItemLike)Items.LIME_DYE, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SEA_PICKLE}), 0.1f).unlockedBy("has_sea_pickle", RegistrateRecipeProvider.has((ItemLike)Blocks.SEA_PICKLE)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/lime_dye"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.MISC, (ItemLike)Items.GREEN_DYE, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CACTUS}), 1.0f).unlockedBy("has_cactus", RegistrateRecipeProvider.has((ItemLike)Blocks.CACTUS)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/green_dye"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.TERRACOTTA.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CLAY}), 0.35f).unlockedBy("has_clay_block", RegistrateRecipeProvider.has((ItemLike)Blocks.CLAY)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/terracotta"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.MISC, (ItemLike)Items.NETHER_BRICK, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.NETHERRACK}), 0.1f).unlockedBy("has_netherrack", RegistrateRecipeProvider.has((ItemLike)Blocks.NETHERRACK)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/nether_brick"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.SMOOTH_STONE.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.STONE}), 0.1f).unlockedBy("has_stone", RegistrateRecipeProvider.has((ItemLike)Blocks.STONE)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/smooth_stone"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.SMOOTH_SANDSTONE.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SANDSTONE}), 0.1f).unlockedBy("has_sandstone", RegistrateRecipeProvider.has((ItemLike)Blocks.SANDSTONE)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/smooth_sandstone"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.SMOOTH_RED_SANDSTONE.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.RED_SANDSTONE}), 0.1f).unlockedBy("has_red_sandstone", RegistrateRecipeProvider.has((ItemLike)Blocks.RED_SANDSTONE)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/smooth_red_sandstone"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.SMOOTH_QUARTZ.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.QUARTZ_BLOCK}), 0.1f).unlockedBy("has_quartz_block", RegistrateRecipeProvider.has((ItemLike)Blocks.QUARTZ_BLOCK)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/smooth_quartz"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.SMOOTH_BASALT, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.BASALT}), 0.1f).unlockedBy("has_basalt", RegistrateRecipeProvider.has((ItemLike)Blocks.BASALT)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/smooth_basalt"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.STONE.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.COBBLESTONE}), 0.1f).unlockedBy("has_cobblestone", RegistrateRecipeProvider.has((ItemLike)Blocks.COBBLESTONE)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/stone"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.DEEPSLATE, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.COBBLED_DEEPSLATE}), 0.1f).unlockedBy("has_cobbled_deepslate", RegistrateRecipeProvider.has((ItemLike)Blocks.COBBLED_DEEPSLATE)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/deepslate"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.CRACKED_STONE_BRICKS.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.STONE_BRICKS}), 0.1f).unlockedBy("has_stone_bricks", RegistrateRecipeProvider.has((ItemLike)Blocks.STONE_BRICKS)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/cracked_stone_bricks"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.POLISHED_BLACKSTONE_BRICKS}), 0.1f).unlockedBy("has_polished_blackstone_bricks", RegistrateRecipeProvider.has((ItemLike)Blocks.POLISHED_BLACKSTONE_BRICKS)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/cracked_polished_blackstone_bricks"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.CRACKED_NETHER_BRICKS.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.NETHER_BRICKS}), 0.1f).unlockedBy("has_nether_bricks", RegistrateRecipeProvider.has((ItemLike)Blocks.NETHER_BRICKS)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/cracked_nether_bricks"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.CRACKED_DEEPSLATE_BRICKS.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DEEPSLATE_BRICKS}), 0.1f).unlockedBy("has_deepslate_bricks", RegistrateRecipeProvider.has((ItemLike)Blocks.DEEPSLATE_BRICKS)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/cracked_deepslate_bricks"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.CRACKED_DEEPSLATE_TILES.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DEEPSLATE_TILES}), 0.1f).unlockedBy("has_deepslate_tiles", RegistrateRecipeProvider.has((ItemLike)Blocks.DEEPSLATE_TILES)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/cracked_deepslate_tiles"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.DECORATIONS, (ItemLike)Blocks.BLACK_GLAZED_TERRACOTTA.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.BLACK_TERRACOTTA}), 0.1f).unlockedBy("has_black_terracotta", RegistrateRecipeProvider.has((ItemLike)Blocks.BLACK_TERRACOTTA)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/black_glazed_terracotta"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.DECORATIONS, (ItemLike)Blocks.BLUE_GLAZED_TERRACOTTA.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.BLUE_TERRACOTTA}), 0.1f).unlockedBy("has_blue_terracotta", RegistrateRecipeProvider.has((ItemLike)Blocks.BLUE_TERRACOTTA)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/blue_glazed_terracotta"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.DECORATIONS, (ItemLike)Blocks.BROWN_GLAZED_TERRACOTTA.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.BROWN_TERRACOTTA}), 0.1f).unlockedBy("has_brown_terracotta", RegistrateRecipeProvider.has((ItemLike)Blocks.BROWN_TERRACOTTA)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/brown_glazed_terracotta"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.DECORATIONS, (ItemLike)Blocks.CYAN_GLAZED_TERRACOTTA.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CYAN_TERRACOTTA}), 0.1f).unlockedBy("has_cyan_terracotta", RegistrateRecipeProvider.has((ItemLike)Blocks.CYAN_TERRACOTTA)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/cyan_glazed_terracotta"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.DECORATIONS, (ItemLike)Blocks.GRAY_GLAZED_TERRACOTTA.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.GRAY_TERRACOTTA}), 0.1f).unlockedBy("has_gray_terracotta", RegistrateRecipeProvider.has((ItemLike)Blocks.GRAY_TERRACOTTA)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/gray_glazed_terracotta"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.DECORATIONS, (ItemLike)Blocks.GREEN_GLAZED_TERRACOTTA.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.GREEN_TERRACOTTA}), 0.1f).unlockedBy("has_green_terracotta", RegistrateRecipeProvider.has((ItemLike)Blocks.GREEN_TERRACOTTA)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/green_glazed_terracotta"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.DECORATIONS, (ItemLike)Blocks.LIGHT_BLUE_GLAZED_TERRACOTTA.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.LIGHT_BLUE_TERRACOTTA}), 0.1f).unlockedBy("has_light_blue_terracotta", RegistrateRecipeProvider.has((ItemLike)Blocks.LIGHT_BLUE_TERRACOTTA)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/light_blue_glazed_terracotta"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.DECORATIONS, (ItemLike)Blocks.LIGHT_GRAY_GLAZED_TERRACOTTA.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.LIGHT_GRAY_TERRACOTTA}), 0.1f).unlockedBy("has_light_gray_terracotta", RegistrateRecipeProvider.has((ItemLike)Blocks.LIGHT_GRAY_TERRACOTTA)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/light_gray_glazed_terracotta"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.DECORATIONS, (ItemLike)Blocks.LIME_GLAZED_TERRACOTTA.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.LIME_TERRACOTTA}), 0.1f).unlockedBy("has_lime_terracotta", RegistrateRecipeProvider.has((ItemLike)Blocks.LIME_TERRACOTTA)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/lime_glazed_terracotta"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.DECORATIONS, (ItemLike)Blocks.MAGENTA_GLAZED_TERRACOTTA.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.MAGENTA_TERRACOTTA}), 0.1f).unlockedBy("has_magenta_terracotta", RegistrateRecipeProvider.has((ItemLike)Blocks.MAGENTA_TERRACOTTA)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/magenta_glazed_terracotta"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.DECORATIONS, (ItemLike)Blocks.ORANGE_GLAZED_TERRACOTTA.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.ORANGE_TERRACOTTA}), 0.1f).unlockedBy("has_orange_terracotta", RegistrateRecipeProvider.has((ItemLike)Blocks.ORANGE_TERRACOTTA)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/orange_glazed_terracotta"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.DECORATIONS, (ItemLike)Blocks.PINK_GLAZED_TERRACOTTA.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.PINK_TERRACOTTA}), 0.1f).unlockedBy("has_pink_terracotta", RegistrateRecipeProvider.has((ItemLike)Blocks.PINK_TERRACOTTA)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/pink_glazed_terracotta"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.DECORATIONS, (ItemLike)Blocks.PURPLE_GLAZED_TERRACOTTA.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.PURPLE_TERRACOTTA}), 0.1f).unlockedBy("has_purple_terracotta", RegistrateRecipeProvider.has((ItemLike)Blocks.PURPLE_TERRACOTTA)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/purple_glazed_terracotta"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.DECORATIONS, (ItemLike)Blocks.RED_GLAZED_TERRACOTTA.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.RED_TERRACOTTA}), 0.1f).unlockedBy("has_red_terracotta", RegistrateRecipeProvider.has((ItemLike)Blocks.RED_TERRACOTTA)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/red_glazed_terracotta"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.DECORATIONS, (ItemLike)Blocks.WHITE_GLAZED_TERRACOTTA.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.WHITE_TERRACOTTA}), 0.1f).unlockedBy("has_white_terracotta", RegistrateRecipeProvider.has((ItemLike)Blocks.WHITE_TERRACOTTA)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/white_glazed_terracotta"));
        DualCookingRecipeBuilder.doubleSingle(RecipeCategory.DECORATIONS, (ItemLike)Blocks.YELLOW_GLAZED_TERRACOTTA.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.YELLOW_TERRACOTTA}), 0.1f).unlockedBy("has_yellow_terracotta", RegistrateRecipeProvider.has((ItemLike)Blocks.YELLOW_TERRACOTTA)).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/yellow_glazed_terracotta"));
    }).simpleItem().register();
    public static final BlockEntry<Block> DEEP_ALLOY_BRICKS = SlagEmbers.REG.block("deep_alloy_bricks", Block::new).lang("Deep Alloy Bricks").properties(p -> p.mapColor(MapColor.COLOR_GRAY).sound((SoundType)AllSoundTypes.CRUCIBLE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE, BlockTags.NEEDS_STONE_TOOL}).recipe((c, p) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)c.get()), (int)4).pattern("DD").pattern("DD").define(Character.valueOf('D'), AllTags.itemC("ingots/deep_alloy")).unlockedBy("has_deep_alloy", RegistrateRecipeProvider.has(AllTags.itemC("ingots/deep_alloy"))).save((RecipeOutput)p, SlagEmbers.loc("crafting/" + c.getName()))).simpleItem().register();
    public static final BlockEntry<StairBlock> DEEP_ALLOY_BRICK_STAIRS = SlagEmbers.REG.block("deep_alloy_brick_stairs", p -> new StairBlock(DEEP_ALLOY_BRICKS.getDefaultState(), p)).lang("Deep Alloy Brick Stairs").properties(p -> p.mapColor(MapColor.COLOR_GRAY).sound((SoundType)AllSoundTypes.CRUCIBLE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE, BlockTags.NEEDS_STONE_TOOL}).recipe((c, p) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)c.get()), (int)4).pattern("D  ").pattern("DD ").pattern("DDD").define(Character.valueOf('D'), (ItemLike)DEEP_ALLOY_BRICKS.get()).unlockedBy("has_deep_alloy", RegistrateRecipeProvider.has(AllTags.itemC("ingots/deep_alloy"))).save((RecipeOutput)p, SlagEmbers.loc("crafting/" + c.getName()))).blockstate((c, p) -> p.stairsBlock((StairBlock)c.get(), SlagEmbers.loc("block/deep_alloy_bricks"))).simpleItem().register();
    public static final BlockEntry<SlabBlock> DEEP_ALLOY_BRICK_SLAB = SlagEmbers.REG.block("deep_alloy_brick_slab", SlabBlock::new).initialProperties(() -> Blocks.DEEPSLATE_BRICK_SLAB).lang("Deep Alloy Brick Slab").properties(p -> p.mapColor(MapColor.COLOR_GRAY).sound((SoundType)AllSoundTypes.CRUCIBLE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE, BlockTags.NEEDS_STONE_TOOL}).recipe((c, p) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)c.get()), (int)6).pattern("DDD").define(Character.valueOf('D'), (ItemLike)DEEP_ALLOY_BRICKS.get()).unlockedBy("has_deep_alloy", RegistrateRecipeProvider.has(AllTags.itemC("ingots/deep_alloy"))).save((RecipeOutput)p, SlagEmbers.loc("crafting/" + c.getName()))).blockstate((c, p) -> p.slabBlock((SlabBlock)c.get(), SlagEmbers.loc("block/deep_alloy_bricks"), SlagEmbers.loc("block/deep_alloy_bricks"))).loot((p, c) -> p.add((Block)c, p.createSlabItemTable((Block)c))).simpleItem().register();

    public static void create(RegistrateRecipeProvider p, String key, String type, Item result, FluidEntry<?> fluid, int mb, TagKey<Item> castType) {
        AllBlocks.create(p, key, type, result, (Fluid)fluid.getSource(), mb, castType);
    }

    public static void create(RegistrateRecipeProvider p, String key, String type, ItemStack result, FluidEntry<?> fluid, int mb, TagKey<Item> castType) {
        AllBlocks.create(p, key, type, result, (Fluid)fluid.getSource(), mb, castType);
    }

    public static void create(RegistrateRecipeProvider p, String key, String type, Item result, Fluid fluid, int mb, TagKey<Item> castType) {
        AllBlocks.create(p, key, type, new ItemStack((ItemLike)result), fluid, mb, castType);
    }

    public static void create(RegistrateRecipeProvider p, String key, String type, ItemStack result, Fluid fluid, int mb, TagKey<Item> castType) {
        TableCastingRecipeBuilder.create(result, fluid, mb, castType).unlockedBy("has_" + key, RegistrateRecipeProvider.has(AllTags.itemC(key + "s/" + type))).save((RecipeOutput)p, SlagEmbers.loc("casting/table/" + type + "_" + key));
    }

    public static void register() {
    }
}

